/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzGT;
import com.aspose.words.internal.zzIz;
import com.aspose.words.internal.zzJt;
import com.aspose.words.internal.zzW0o;
import com.aspose.words.internal.zzW4O;
import com.aspose.words.internal.zzXZJ;
import com.aspose.words.internal.zzXg9;
import com.aspose.words.internal.zzXtG;
import com.aspose.words.internal.zzYDe;
import com.aspose.words.internal.zzYFO;
import com.aspose.words.internal.zzYQf;
import com.aspose.words.internal.zzYWi;
import com.aspose.words.internal.zzYmV;
import com.aspose.words.internal.zzZHI;
import com.aspose.words.internal.zzZN0;
import com.aspose.words.internal.zzZRU;
import com.aspose.words.internal.zzZXx;
import com.aspose.words.internal.zzZjX;
import com.aspose.words.internal.zzZpM;
import com.aspose.words.internal.zzZuA;
import com.aspose.words.internal.zza8;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzXvo
extends X509CRL {
    private final Provider zzXe8;
    private final zzZjX zzxL;
    private final String zzXox;
    private final byte[] zzZcu;
    private final boolean zzVUJ;
    private volatile boolean zzYqB = false;
    private volatile int zzYu2;

    static boolean zzXlm(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(zzZRU.zzWM7.getId());
            return byArray != null && zzXZJ.zzWpd(zzW4O.zzvI(byArray).zzYWp()).zzWZf();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected zzXvo(Provider provider, zzZjX zzZjX2) throws CRLException {
        this.zzXe8 = provider;
        this.zzxL = zzZjX2;
        try {
            this.zzXox = zzXg9.zzHP(zzZjX2.zzX8b());
            this.zzZcu = (byte[])(zzZjX2.zzX8b().zzuj() != null ? zzZjX2.zzX8b().zzuj().zzZLw().getEncoded("DER") : null);
            this.zzVUJ = zzXvo.zzXlm(this);
            return;
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(zzYQf.zzWs3);
        return !set.isEmpty();
    }

    private Set zzZZl(boolean bl) {
        zzGT zzGT2;
        if (this.getVersion() == 2 && (zzGT2 = this.zzxL.zzZX8().zzXOh()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = zzGT2.zzW9T();
            while (enumeration.hasMoreElements()) {
                zzZpM zzZpM2 = (zzZpM)enumeration.nextElement();
                zzZRU zzZRU2 = zzGT2.zzWD0(zzZpM2);
                if (bl != zzZRU2.isCritical()) continue;
                hashSet.add(zzZpM2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public final Set getCriticalExtensionOIDs() {
        return this.zzZZl(true);
    }

    public final Set getNonCriticalExtensionOIDs() {
        return this.zzZZl(false);
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        zzZRU zzZRU2;
        zzGT zzGT2 = this.zzxL.zzZX8().zzXOh();
        if (zzGT2 != null && (zzZRU2 = zzGT2.zzWD0(new zzZpM(oid))) != null) {
            try {
                return zzZRU2.zz8f().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public final byte[] getEncoded() throws CRLException {
        try {
            return this.zzxL.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.zzXe8);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.zzYn3(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        this.zzYn3(key, signature);
    }

    private void zzYn3(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.zzxL.zzX8b().equals(this.zzxL.zzZX8().zzYo0())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.zzZcu != null) {
            try {
                zzXg9.zzYn3(signature, zzYDe.zzXM4(this.zzZcu));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public final int getVersion() {
        return this.zzxL.zzXy();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.zzxL.zzXnp().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public final Date getThisUpdate() {
        return this.zzxL.zzXXo().zzZDF();
    }

    @Override
    public final Date getNextUpdate() {
        if (this.zzxL.zzYLa() != null) {
            return this.zzxL.zzYLa().zzZDF();
        }
        return null;
    }

    private Set zz7b() {
        HashSet<zzJt> hashSet = new HashSet<zzJt>();
        Enumeration enumeration = this.zzxL.zzZGn();
        zzZuA zzZuA2 = null;
        while (enumeration.hasMoreElements()) {
            zzZRU zzZRU2;
            zzIz.zzYn3 zzYn32 = (zzIz.zzYn3)enumeration.nextElement();
            zzJt zzJt2 = new zzJt(zzYn32, this.zzVUJ, zzZuA2);
            hashSet.add(zzJt2);
            if (!this.zzVUJ || !zzYn32.hasExtensions() || (zzZRU2 = zzYn32.zzXOh().zzWD0(zzZRU.zzb)) == null) continue;
            zzZuA2 = zzZuA.zzEu(zzYWi.zzY3N(zzZRU2.zzZH1()).zzrc()[0].zzqa());
        }
        return hashSet;
    }

    @Override
    public final X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        Enumeration enumeration = this.zzxL.zzZGn();
        zzZuA zzZuA2 = null;
        while (enumeration.hasMoreElements()) {
            zzZRU zzZRU2;
            zzIz.zzYn3 zzYn32 = (zzIz.zzYn3)enumeration.nextElement();
            if (serialNumber.equals(zzYn32.zzZ3p().zzWJr())) {
                return new zzJt(zzYn32, this.zzVUJ, zzZuA2);
            }
            if (!this.zzVUJ || !zzYn32.hasExtensions() || (zzZRU2 = zzYn32.zzXOh().zzWD0(zzZRU.zzb)) == null) continue;
            zzZuA2 = zzZuA.zzEu(zzYWi.zzY3N(zzZRU2.zzZH1()).zzrc()[0].zzqa());
        }
        return null;
    }

    public final Set getRevokedCertificates() {
        Set set = this.zz7b();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public final byte[] getTBSCertList() throws CRLException {
        try {
            return this.zzxL.zzZX8().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public final byte[] getSignature() {
        return this.zzxL.zzZkG().zzYWp();
    }

    @Override
    public final String getSigAlgName() {
        return this.zzXox;
    }

    @Override
    public final String getSigAlgOID() {
        return this.zzxL.zzX8b().zzXn4().getId();
    }

    @Override
    public final byte[] getSigAlgParams() {
        if (this.zzZcu != null) {
            byte[] byArray = new byte[this.zzZcu.length];
            System.arraycopy(this.zzZcu, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public final String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzYmV.zzXiV();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(zzYmV.zzv6(zzZXx.zzWPh(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(zzYmV.zzv6(zzZXx.zzWPh(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(zzYmV.zzv6(zzZXx.zzWPh(byArray, i, byArray.length - i))).append(string);
        }
        zzGT zzGT2 = this.zzxL.zzZX8().zzXOh();
        if (zzGT2 != null) {
            object2 = zzGT2.zzW9T();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (zzZpM)object2.nextElement();
                zzZRU zzZRU2 = zzGT2.zzWD0((zzZpM)object);
                if (zzZRU2.zz8f() != null) {
                    byte[] byArray2 = zzZRU2.zz8f().zzYWp();
                    stringBuffer.append("                       critical(").append(zzZRU2.isCritical()).append(") ");
                    try {
                        zzYDe zzYDe2 = zzYDe.zzXM4(byArray2);
                        if (((zzYDe)object).equals(zzZRU.zzYiC)) {
                            stringBuffer.append(new zzZHI(zzW0o.zzYDZ(zzYDe2).zzZMI())).append(string);
                            continue;
                        }
                        if (((zzYDe)object).equals(zzZRU.zzXrb)) {
                            stringBuffer.append("Base CRL: " + new zzZHI(zzW0o.zzYDZ(zzYDe2).zzZMI())).append(string);
                            continue;
                        }
                        if (((zzYDe)object).equals(zzZRU.zzWM7)) {
                            stringBuffer.append(zzXZJ.zzWpd(zzYDe2)).append(string);
                            continue;
                        }
                        if (((zzYDe)object).equals(zzZRU.zzX0Y)) {
                            stringBuffer.append(zzYFO.zzX5k(zzYDe2)).append(string);
                            continue;
                        }
                        if (((zzYDe)object).equals(zzZRU.zzZ5S)) {
                            stringBuffer.append(zzYFO.zzX5k(zzYDe2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((zzZpM)object).getId());
                        stringBuffer.append(" value = ").append(zza8.zzlG(zzYDe2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((zzZpM)object).getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final boolean isRevoked(Certificate cert) {
        if (!cert.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.zzxL.zzZGn();
        zzZuA zzZuA2 = this.zzxL.zzXnp();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)cert).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                zzXtG zzXtG2;
                zzIz.zzYn3 zzYn32 = zzIz.zzYn3.zzZI1(enumeration.nextElement());
                if (this.zzVUJ && zzYn32.hasExtensions() && (zzXtG2 = zzYn32.zzXOh().zzWD0(zzZRU.zzb)) != null) {
                    zzZuA2 = zzZuA.zzEu(zzYWi.zzY3N(zzXtG2.zzZH1()).zzrc()[0].zzqa());
                }
                if (!zzYn32.zzZ3p().zzWJr().equals(bigInteger)) continue;
                if (cert instanceof X509Certificate) {
                    zzXtG2 = zzZuA.zzEu(((X509Certificate)cert).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        zzXtG2 = zzZN0.zzZg7(cert.getEncoded()).zzXnp();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return zzZuA2.equals(zzXtG2);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        if (other instanceof zzXvo) {
            boolean bl;
            zzXvo zzXvo2 = (zzXvo)other;
            if (this.zzYqB && (bl = zzXvo2.zzYqB) && zzXvo2.zzYu2 != this.zzYu2) {
                return false;
            }
            return this.zzxL.equals(zzXvo2.zzxL);
        }
        return super.equals(other);
    }

    @Override
    public final int hashCode() {
        if (!this.zzYqB) {
            this.zzYu2 = super.hashCode();
            this.zzYqB = true;
        }
        return this.zzYu2;
    }
}

