/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.zzWGz;
import com.aspose.words.zzWP7;
import com.aspose.words.zzYsN;

public class ListFormat {
    private zzYsN zzhr;
    private zzWGz zzXNz;
    private ListCollection zzYXI;
    private ListLevel zzYQm;
    private ListLevel zzZKV;

    ListFormat(zzYsN parentParaAttrs, zzWGz parentRunAttrs, ListCollection lists) {
        this.zzhr = parentParaAttrs;
        this.zzXNz = parentRunAttrs;
        this.zzYXI = lists;
    }

    public void applyBulletDefault() {
        if (this.zzYXI.getCount() > 2046) {
            zzWP7.zzWOc(this.zzYXI.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzZ9I(listFormat.zzYXI.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYQm = null;
    }

    public void applyNumberDefault() {
        if (this.zzYXI.getCount() > 2046) {
            zzWP7.zzWOc(this.zzYXI.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzZ9I(listFormat.zzYXI.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYQm = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzYQm = null;
    }

    public void listIndent() throws Exception {
        if (this.zzYdx() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYdx() + 1);
            ListFormat listFormat2 = this;
            this.zzYQm = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzYdx() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYdx() - 1);
            ListFormat listFormat2 = this;
            this.zzYQm = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzWAB.zzYn3((Object)this.zzYXI.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzZOj();
        }
        return this.zzYdx();
    }

    public void setListLevelNumber(int value) {
        this.zzhr.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzYQm = null;
    }

    final int zzYdx() {
        return (Integer)this.zzhr.fetchParaAttr(1110);
    }

    final int zzZOj() {
        Paragraph paragraph = zzWAB.zzYn3((Object)this.zzhr, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzXAb(1110, 1);
        }
        return this.zzYdx();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzYXI.zzX1k(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzZ9I(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzYXI.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzZ9I(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzYQm = null;
    }

    final List zzWdZ() {
        int n = this.zzZuG();
        if (n != 0) {
            return this.zzYXI.zzX1k(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzWAB.zzYn3((Object)this.zzYXI.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzXKb();
            }
            return this.zzXwI();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzXwI() {
        try {
            if (this.zzYQm == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzVVG(this.zzYdx()) : null;
                this.zzYQm = listLevel != null ? new ListLevel(listLevel, this.zzXNz) : null;
            }
            return this.zzYQm;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzXKb() {
        if (this.zzZKV == null) {
            List list = this.zzWdZ();
            ListLevel listLevel = list != null ? list.zzVVG(this.zzZOj()) : null;
            this.zzZKV = listLevel != null ? new ListLevel(listLevel, this.zzXNz) : null;
        }
        return this.zzZKV;
    }

    final int getListId() {
        return (Integer)this.zzhr.fetchParaAttr(1120);
    }

    private void zzZ9I(int n) {
        Object object = this.zzhr.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzZo().zzZzF() + this.getListLevel().zzZo().zz2y())) {
            n3 = 0;
        }
        this.zzhr.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzYQm = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzhr.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzZo().zzZzF() + this.getListLevel().zzZo().zz2y();
        this.zzhr.setParaAttr(1160, n4);
    }

    private int zzZuG() {
        Paragraph paragraph = zzWAB.zzYn3((Object)this.zzhr, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzXAb(1120, 1);
        }
        return this.getListId();
    }
}

