/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.internal.zzXOD;
import com.aspose.words.internal.zzXrY;
import com.aspose.words.internal.zzZ1S;
import com.aspose.words.internal.zzZ7C;
import com.aspose.words.internal.zzZdC;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXSz;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWIx = new HashMap();
    private static HashMap<Integer, Integer> zzWED = new HashMap();
    private static HashMap<Integer, Integer> zzYBn = new HashMap();
    private static HashMap<Integer, Integer> zzWd9 = new HashMap();
    private static HashMap<Integer, Integer> zzYZN = new HashMap();
    private static HashMap<Integer, Integer> zzX8h = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzWAB.zzYn3(fileName, "fileName");
        try (zzZ7C zzZ7C2 = zzWAB.zzYkS(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzX9N(zzZ7C2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzX9N(zzZdC.zzYn3(stream));
    }

    static FileFormatInfo zzX9N(zzXrY zzXrY2) throws Exception {
        if (zzXrY2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzXSz zzXSz2 = new zzXSz();
            zzXrY zzXrY3 = zzXrY2;
            zzXSz zzXSz3 = zzXSz2;
            return zzXSz2.zzWOc(zzXrY3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzXlm(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzY7s(zzXOD.zzZzz(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzTR(zzXOD.zzZzz(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZ1S.zz6Y(string = zzXOD.zzaC(FileFormatUtil.zzWFU(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzY7s(FileFormatUtil.zzqW(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzTR(FileFormatUtil.zzWFU(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXOD.zzaC(FileFormatUtil.zzqW(saveFormat));
        if (zzZ1S.zz6Y(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzTR(zzXOD.zzYKv(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXOD.zzaC(FileFormatUtil.zzWpj(imageType));
    }

    static Exception zzXlm(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzmZ(int n) {
        return zzXOD.toString(FileFormatUtil.zzqW(n));
    }

    static int zzTR(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWAB.zzYn3(zzYZN, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzYgf(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzWAB.zzYn3(zzX8h, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzaf(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWFU(int n) {
        return zzWAB.zzYn3(zzWIx, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzqW(int n) {
        return zzWAB.zzYn3(zzWED, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWpj(int n) {
        return zzWAB.zzYn3(zzYBn, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzY7s(int n) {
        return zzWAB.zzYn3(zzWd9, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzWNY(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzWAB.zzWOc(zzYZN, Integer.valueOf(n), Integer.valueOf(n2));
            zzWAB.zzWOc(zzWED, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWd9.containsKey(n)) {
                zzWAB.zzWOc(zzWd9, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzWAB.zzWOc(zzWIx, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzWAB.zzWOc(zzX8h, Integer.valueOf(n), Integer.valueOf(n4));
            zzWAB.zzWOc(zzYBn, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzWNY(11, 10, 10, 1);
        FileFormatUtil.zzWNY(11, 0, 0, 1);
        FileFormatUtil.zzWNY(12, 11, 11, 1);
        FileFormatUtil.zzWNY(13, 20, 20, 1);
        FileFormatUtil.zzWNY(13, 0, 254, 1);
        FileFormatUtil.zzWNY(14, 21, 21, 1);
        FileFormatUtil.zzWNY(15, 22, 22, 1);
        FileFormatUtil.zzWNY(16, 23, 23, 1);
        FileFormatUtil.zzWNY(18, 24, 24, 1);
        FileFormatUtil.zzWNY(19, 25, 25, 1);
        FileFormatUtil.zzWNY(20, 26, 26, 1);
        FileFormatUtil.zzWNY(21, 27, 27, 1);
        FileFormatUtil.zzWNY(24, 30, 30, 1);
        FileFormatUtil.zzWNY(17, 31, 31, 1);
        FileFormatUtil.zzWNY(25, 50, 50, 1);
        FileFormatUtil.zzWNY(26, 45, 255, 1);
        FileFormatUtil.zzWNY(27, 51, 51, 1);
        FileFormatUtil.zzWNY(28, 0, 52, 1);
        FileFormatUtil.zzWNY(29, 0, 53, 1);
        FileFormatUtil.zzWNY(31, 0, 54, 1);
        FileFormatUtil.zzWNY(22, 60, 60, 1);
        FileFormatUtil.zzWNY(23, 61, 61, 1);
        FileFormatUtil.zzWNY(34, 40, 64, 1);
        FileFormatUtil.zzWNY(41, 47, 255, 1);
        FileFormatUtil.zzWNY(42, 48, 255, 1);
        FileFormatUtil.zzWNY(35, 41, 255, 1);
        FileFormatUtil.zzWNY(36, 46, 255, 1);
        FileFormatUtil.zzWNY(38, 42, 255, 1);
        FileFormatUtil.zzWNY(37, 44, 255, 1);
        FileFormatUtil.zzWNY(30, 52, 255, 1);
        FileFormatUtil.zzWNY(32, 70, 62, 1);
        FileFormatUtil.zzWNY(33, 73, 63, 1);
        FileFormatUtil.zzWNY(39, 71, 255, 1);
        FileFormatUtil.zzWNY(8, 100, 255, 1);
        FileFormatUtil.zzWNY(9, 105, 255, 1);
        FileFormatUtil.zzWNY(6, 101, 255, 6);
        FileFormatUtil.zzWNY(7, 102, 255, 7);
        FileFormatUtil.zzWNY(5, 104, 255, 5);
        FileFormatUtil.zzWNY(4, 0, 255, 4);
        FileFormatUtil.zzWNY(3, 0, 255, 3);
        FileFormatUtil.zzWNY(40, 72, 255, 1);
        FileFormatUtil.zzWNY(2, 103, 255, 2);
    }
}

