/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzW1g;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.internal.zzWFy;
import com.aspose.words.internal.zzWgv;
import com.aspose.words.internal.zzWlc;
import com.aspose.words.internal.zzWqH;
import com.aspose.words.internal.zzXCz;
import com.aspose.words.internal.zzXIK;
import com.aspose.words.internal.zzXSg;
import com.aspose.words.internal.zzXrY;
import com.aspose.words.internal.zzY3x;
import com.aspose.words.internal.zzY5F;
import com.aspose.words.internal.zzYOz;
import com.aspose.words.internal.zzZ1S;
import com.aspose.words.internal.zzZFs;
import com.aspose.words.internal.zzZn6;
import com.aspose.words.internal.zzjk;
import com.aspose.words.internal.zzsB;
import com.aspose.words.zz2r;
import com.aspose.words.zz70;
import com.aspose.words.zzEF;
import com.aspose.words.zzK2;
import com.aspose.words.zzL4;
import com.aspose.words.zzLu;
import com.aspose.words.zzVUG;
import com.aspose.words.zzW8e;
import com.aspose.words.zzWGz;
import com.aspose.words.zzWMe;
import com.aspose.words.zzWP7;
import com.aspose.words.zzWoH;
import com.aspose.words.zzWsG;
import com.aspose.words.zzX4u;
import com.aspose.words.zzX59;
import com.aspose.words.zzXO3;
import com.aspose.words.zzXO6;
import com.aspose.words.zzXP0;
import com.aspose.words.zzXPK;
import com.aspose.words.zzXc8;
import com.aspose.words.zzXja;
import com.aspose.words.zzY0C;
import com.aspose.words.zzY3T;
import com.aspose.words.zzY5U;
import com.aspose.words.zzYLw;
import com.aspose.words.zzYNV;
import com.aspose.words.zzYPP;
import com.aspose.words.zzYdG;
import com.aspose.words.zzYfe;
import com.aspose.words.zzYjy;
import com.aspose.words.zzYyz;
import com.aspose.words.zzZ3c;
import com.aspose.words.zzZ76;
import com.aspose.words.zzZ9l;
import com.aspose.words.zzZGs;
import com.aspose.words.zzZL9;
import com.aspose.words.zzZVd;
import com.aspose.words.zzZgN;
import com.aspose.words.zzZi7;
import com.aspose.words.zzZiK;
import com.aspose.words.zzZwv;
import com.aspose.words.zzaL;
import com.aspose.words.zziX;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWGz,
zzZL9,
zzZiK {
    private Document zzxH;
    private Node zzlZ;
    private Node zzW79;
    private zzYNV zzXZb;
    private Font zzYI9;
    private zzZFs<zzYNV> zzAw;
    private zzZFs<zzZ3c> zzRc;
    private zzZFs<zzYn3> zzX87;
    private zzLu zzYKx = zzLu.zzVTw();
    private zzZi7 zzXaM = new zzZi7();
    private RowFormat zzZFx;
    private CellFormat zzwV;
    private zzZFs<zzaL> zzWVi;
    private int zzZLC = 0;
    private int zzXEm = -1;
    private int zzZMT;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzO6(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzO6(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzO6(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYn3(documentBuilder.getCurrentSection(), zzYfe.zzW0s(headerFooterType), 0, 0);
    }

    private void zzO6(int n, int n2, int n3, int n4) {
        this.zzxH.ensureMinimum();
        Section section = (Section)this.zzxH.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYn3(section, 1, n3, n4);
    }

    private void zzYn3(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYfe.zzWLj(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzxH, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzxH));
            }
        }
        this.zzYn3(story, n2, n3);
    }

    private void zzYn3(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYn3(paragraph2, n3);
    }

    final void zzXlm(Paragraph paragraph, int n) {
        this.zzYn3(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz71().zzX9u() ? zzWMe.zzWD0(this.zzxH, fieldName) : zzWMe.zzHP(this.zz71(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYn3(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYn3(field, isAfter, false);
    }

    private boolean zzYn3(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXc8 zzXc82 = field.getFormat().zzXA6();
        Inline inline = zzXc82.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYn3(inline.zzYCz(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzY0C.zzYn3(this.zzxH, bookmarkName) : zzY0C.zzWOc(this.zzxH, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWYZ() == 6) {
            this.zzWOc((Paragraph)node.zzqz(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzWP7.zzXq8(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzWOc(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYn3(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzW6J(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYn3(cell, characterIndex);
    }

    private void zzWOc(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWYZ() == 6) {
            this.zzXXd(node);
        } else {
            Node node2 = node;
            if (zzWP7.zzZyp(node2.getNodeType())) {
                Paragraph paragraph = zzWP7.zzXq8(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzXXd(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWYZ() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzXXd(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzZMT = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzc8();
            return;
        }
        if (!this.zzWse()) {
            this.zzc8();
        }
    }

    private boolean zzWse() {
        Node node = this.zz71();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz71(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYn3(inline.zzYCz(), true);
            return true;
        }
        return false;
    }

    private void zzc8() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYn3(documentBuilder.getCurrentParagraph().zzXhl(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzW6J(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz3N() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz71().zzXYN(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZbE();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYn3(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzY5U(text, false);
    }

    public void writeln(String text) {
        this.zzY5U(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzVZ0();
        Paragraph paragraph = this.getCurrentParagraph();
        zzZVd zzZVd2 = new zzZVd(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzxH, this.zzXs4(), this.zzwW());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzWOc(this.zz71(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzZVd2.dispose();
        }
        if (this.getDocument().zzZFQ()) {
            zzWP7.zzXlm((zzZGs)paragraph, this.getDocument().zzZ1i());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzXir() {
        zzYNV zzYNV2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzVZ0();
        Node node = this.zz71();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzY3x(false);
        } else {
            run2 = run = (Run)node.zzhf(21);
        }
        if (run2 == null && zzWAB.zzsK(node, paragraph.zzXfo())) {
            run = paragraph.zzXfo();
        }
        if (run != null) {
            cloneable = run.zzYCz();
            zzYNV2 = (zzYNV)((zzZ76)cloneable).zzXCD();
        } else {
            cloneable = paragraph.zzXhl();
            zzYNV2 = (zzYNV)((zzZ76)cloneable).zzXCD();
        }
        zzYNV zzYNV3 = zzYNV2;
        Paragraph paragraph2 = new Paragraph(this.zzxH, this.zzXs4(), zzYNV3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzZVd zzZVd2 = new zzZVd(this.zzxH);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWOc(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzZVd2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzK2.zzWD0(this);
    }

    public void insertBreak(int breakType) {
        this.zzWPh(breakType, true);
    }

    final void zzWPh(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzXmo(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZwF(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXr1())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzXmo(bl)) {
                        this.zzZwF(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzXmo(bl)) {
                        this.zzwM(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzXmo(bl)) {
                        this.zzwM(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzXmo(bl)) {
                        this.zzwM(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzXmo(bl)) {
                        this.zzwM(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzXmo(bl)) {
                        this.zzwM(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZwF(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZ1S.zz6Y(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzW1g.zzWOc("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzVZ0();
        return zzWP7.zzYn3(fieldType, updateField, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzVZ0();
        return zzWP7.zzYn3(fieldCode, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzVZ0();
        return zzWP7.zzYn3(fieldCode, fieldValue, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzWAB.zzWOc((Object)displayText, "displayText");
        zzWAB.zzWOc((Object)urlOrBookmark, "hrefOrBookmark");
        zzL4 zzL42 = this.zzWOc(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzL42.zzWOc(documentBuilder.zzXq8(88, true));
        return zzWP7.zzYn3(zzL42.getStart(), zzL42.getSeparator(), zzL42.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzY0Y(70);
        if (zzZ1S.zz6Y(name)) {
            this.startBookmark(name);
        }
        this.zzFb(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXsr(70);
        String string = zzZ1S.zz6Y(fieldValue) ? fieldValue : FormField.zzWuY;
        Run run = new Run(this.zzxH, string, this.zzwW());
        this.insertNode(run);
        Node node = this.zzXq8(70, true);
        if (zzZ1S.zz6Y(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzW6t(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzWOc((Paragraph)node.zzqz(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzY0Y(71);
        if (zzZ1S.zz6Y(name)) {
            this.startBookmark(name);
        }
        this.zzFb(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXq8(71, false);
        if (zzZ1S.zz6Y(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW6t(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzY0Y(83);
        if (zzZ1S.zz6Y(name)) {
            this.startBookmark(name);
        }
        this.zzFb(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXq8(83, false);
        if (zzZ1S.zz6Y(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW6t(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzxH, footnoteType, !zzZ1S.zz6Y(referenceMark), referenceMark, this.zzwW());
        Style style = this.getDocument().getStyles().zzay(zzWP7.zzY1G(footnoteType));
        footnote.zzYCz().set(50, style.zzWM5());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzxH);
        Style style2 = this.getDocument().getStyles().zzay(zzWP7.zzZcp(footnoteType));
        paragraph.zzZo().set(1000, style2.zzWM5());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzxH, '\u0002', new zzYNV()) : new Run(this.zzxH, footnote.getReferenceMark(), new zzYNV());
        inline.zzYCz().set(50, style.zzWM5());
        paragraph.appendChild(inline);
        if (zzZ1S.zz6Y(footnoteText)) {
            Node node = this.zz71();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzXXd(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZlX(zzXrY zzXrY2) throws Exception {
        return this.zzYn3(zzXrY2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZlX(zzXrY.zzWOc(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYn3(zzXrY zzXrY2, double d, double d2) throws Exception {
        return this.zzYn3(zzXrY2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYn3(zzXrY.zzWOc(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzY5F zzY5F2 = new zzY5F();){
            zzsB.zzYn3(image, zzY5F2);
            Shape shape = this.zzYn3(zzY5F2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzWAB.zzYn3(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzWlc.zzhF(fileName);
        try {
            Shape shape = this.zzYn3((zzXrY)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXrY)object).close();
            }
        }
    }

    private Shape zzYn3(zzXrY zzXrY2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXrY2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzWAB.zzWD0(zzXrY2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYn3(zzXrY.zzWOc(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYn3(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzYn3(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzY3x.zzW6t(object)) {
            object4 = new zzsB((byte[])object);
            bl2 = true;
            ((zzWqH)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzxH.getCompatibilityOptions().getMswVersion() > 12 || this.zzxH.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzxH, 0);
            object3 = new zzWsG();
            ((zzEF)object3).zzYn3(zzVUG.zzY4g("rect"));
            ((zzWsG)object3).zzYn3(new zzY3T());
            ((zzWsG)object3).zzX7E().zzZ2N().zzAY(this.zzxH);
            object2 = new zziX();
            ((zzYyz)object2).zzWOc(new zz2r(this.zzxH.zzZkI(), ""));
            ((zzYyz)object2).zzYn3(new zzZgN());
            ((zzXO3)object3).zzYn3((zzYyz)object2);
            shape.zzvZ(75);
            shape.zzXMK((zzXO3)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzxH, 75);
        }
        if (zzY3x.zzNL(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzYn3((byte[])object, new zzXPK(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzXPK(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzY3x.zzWjd((byte[])object2));
                this.zzYn3((zzWsG)shape.zzXax(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzWsG)shape.zzXax()).zzX7E().zzZ2N().zzWND((byte[])object);
            object3 = zzY3x.zzWK8(object);
            object4 = new zzXPK(((zzXIK)object3).getWidthPoints(), ((zzXIK)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzYn3(this.zzwW());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzY3x.zzZP4(object)) {
            d5 = DocumentBuilder.zzYn3(shape, object);
        }
        shape.zzYn3(d3, d4, (zzXPK)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYn3(Shape shape, byte[] byArray) throws Exception {
        int n = zzY3x.zzWPS(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzWP7.zzY9b(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzWP7.zz5I(n);
        return d;
    }

    private void zzYn3(zzWsG zzWsG2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzWsG2.zzX7E().zzZ2N().getExtensions();
        try (zzY5F zzY5F2 = new zzY5F(byArray);){
            object = zzWP7.zzYn3(zzY5F2, this.zzxH);
            ((zzXja)object).zz3f(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzXja)object).zzXqS();
            byArray2 = ((zzXja)object).zzXtj(true);
        }
        zzWsG2.zzX7E().zzZ2N().setExtensions(new zzjk<zzXP0>());
        object = zzXP0.zzYn3(byArray2, this.zzxH);
        zzWsG2.zzX7E().zzZ2N().getExtensions().zzWfA(((zzXP0)object).getUri(), (zzXP0)object);
    }

    private Shape zzYn3(zzXrY zzXrY2, String string, boolean bl, zzXrY zzXrY3) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzWtE(string);
        Shape shape = this.zzYn3(zzXrY3, bl, zzZwv2, null);
        zzX4u zzX4u2 = zzW8e.zzYn3(zzXrY2, string, bl);
        return DocumentBuilder.zzYn3(null, false, shape, zzZwv2.zzXSR, zzX4u2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYn3(zzXrY.zzWOc(stream), progId, asIcon, zzXrY.zzWOc(presentation));
    }

    private Shape zzYn3(String string, boolean bl, boolean bl2, zzXrY zzXrY2) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzVRC(zzWFy.zzX6Y(string));
        return this.zzYn3(string, bl, bl2, zzXrY2, zzZwv2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYn3(fileName, isLinked, asIcon, zzXrY.zzWOc(presentation));
    }

    private Shape zzYn3(String string, String string2, boolean bl, boolean bl2, zzXrY zzXrY2) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzWtE(string2);
        return this.zzYn3(string, bl, bl2, zzXrY2, zzZwv2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYn3(fileName, progId, isLinked, asIcon, zzXrY.zzWOc(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzVRC(zzWFy.zzX6Y(fileName));
        return this.zzYn3(fileName, isLinked, iconFile, iconCaption, zzZwv2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzWtE(progId);
        return this.zzYn3(fileName, isLinked, iconFile, iconCaption, zzZwv2);
    }

    private Shape zzYn3(zzXrY zzXrY2, String string, String string2, String string3) throws Exception {
        zzZwv zzZwv2 = zzZwv.zzWtE(string);
        Shape shape = this.zzYn3(string2, string3, zzZwv2);
        zzX4u zzX4u2 = zzW8e.zzYn3(zzXrY2, string, true);
        return DocumentBuilder.zzYn3(null, false, shape, zzZwv2.zzXSR, zzX4u2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYn3(zzXrY.zzWOc(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYn3(zzXO6 zzXO62, zzXrY zzXrY2) throws Exception {
        Shape shape = this.zzWk4(zzXrY2);
        shape.zzvZ(201);
        shape.getOleFormat().zzWOc(zzXO62.zzWhu());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzVZ0();
        if (this.zzkl()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzZfD(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzYjy zzYjy2 = zzWP7.zzYn3(html, options, this);
        zzYjy2.zzWWu();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzVZ0();
        return zzWP7.zzYn3(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzVZ0();
        return zzWP7.zzYn3(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWoH zzWoH2 = new zzWoH();
        return zzWoH2.zzYn3(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zz70(this).zzYn3(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zz70(this).zzYn3(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzxH, 75);
        shape.zzYn3(this.zzwW());
        shape.zzXoa(true);
        shape.getSignatureLine().zzYn3(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZtA(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYqy(this.zzxH);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzkl() {
        boolean bl = false;
        if (this.zz71().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zz71().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZfD(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzVZ0();
        if (this.zz3N() == null) {
            this.startTable();
        }
        if (this.zz3N().zzX0t() == 1) {
            this.zz3N().zzVQh();
        }
        if (this.zz3N().zzX0t() == 3) {
            this.zz3N().zzZsc();
        }
        return this.zz3N().zzZId();
    }

    public Table startTable() {
        this.zzWVi.push(new zzaL(this));
        return this.zz3N().startTable();
    }

    public Table endTable() {
        if (this.zz3N() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz3N().endTable();
        this.zzWVi.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz3N() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz3N().endRow();
        if (this.zzYI9 != null && this.zzYI9.getHidden()) {
            row.zzW7b().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzxH, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzxH, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYh8();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzxH, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXji();
        bookmarkStart.zzWVb(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzYh8();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXji();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzxH, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzVn(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzxH);
        this.zzXEm = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzXEm == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzxH, this.zzXEm);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzxH, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzWAB.zzWOc((Object)importFormatOptions, "ImportFormatOptions");
        this.zzVZ0();
        return zzYdG.zzYn3(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzxH;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzxH) {
            return;
        }
        this.zzxH = value;
        this.zzXXd(null);
        this.zzXZb = new zzYNV();
        this.zzAw = null;
        this.zzRc = null;
        this.zzYI9 = null;
        this.zzWVi = new zzZFs();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYI9 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYI9 = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYI9;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZFx == null) {
            this.zzZFx = new RowFormat(this);
        }
        return this.zzZFx;
    }

    public CellFormat getCellFormat() {
        if (this.zzwV == null) {
            this.zzwV = new CellFormat(this);
        }
        return this.zzwV;
    }

    final void zzXke(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzYNV zzYNV2 = this.getCurrentParagraph().zzXhl();
        this.zzWfo().push(new zzYn3(this.zzwW(), (zzYNV)zzYNV2.zzXCD()));
    }

    public void popFont() {
        zzZFs<zzYn3> zzZFs2 = this.zzWfo();
        if (zzZFs2.size() > 0) {
            zzYn3 zzYn32 = (zzYn3)this.zzWfo().pop();
            this.zzYn3(zzYn32.zzYCz(), false);
            this.getCurrentParagraph().zzW4p(zzYn32.zzX3V());
        }
    }

    final void zzYlH() {
        this.zzZ8N().push(this.zzwW());
    }

    final void zzXXZ() {
        zzZFs<zzYNV> zzZFs2 = this.zzZ8N();
        if (zzZFs2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYn3((zzYNV)documentBuilder.zzZ8N().pop(), false);
        }
    }

    final void zzU2() {
        this.zzZ4q().push(this.zzXs4());
    }

    final void zzZtJ() {
        zzZFs<zzZ3c> zzZFs2 = this.zzZ4q();
        if (zzZFs2.size() > 0) {
            this.getCurrentParagraph().zzYn3((zzZ3c)this.zzZ4q().pop());
        }
    }

    final zzL4 zzWOc(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzY0Y(88);
        zzX59 zzX592 = new zzX59();
        zzX592.setTarget(string2);
        zzX592.setScreenTip(string3);
        if (bl) {
            zzX592.setSubAddress(string);
        } else {
            zzX592.setAddress(zzWgv.zzWOV(string));
            zzX592.setSubAddress(zzWgv.zzWq1(string));
        }
        this.zzFb(zzX592.zzZAP());
        FieldSeparator fieldSeparator = this.zzXsr(88);
        return new zzL4(fieldStart, fieldSeparator, null);
    }

    final zzL4 zzO6(String string, String string2, String string3) {
        boolean bl = zzWgv.zzXq3(string);
        String string4 = bl ? zzWgv.zzWq1(string) : string;
        return this.zzWOc(string4, bl, string2, string3);
    }

    final FieldEnd zzXM5() {
        return this.zzXq8(88, true);
    }

    final zzYNV zzwW() {
        zzYNV zzYNV2 = this.zzXZb;
        return (zzYNV)zzYNV2.zzXCD();
    }

    final zzZ3c zzXs4() {
        zzZ3c zzZ3c2 = this.getCurrentParagraph().zzZo();
        return (zzZ3c)zzZ3c2.zzXCD();
    }

    final zzLu zzQy() {
        zzLu zzLu2 = this.zzW7b();
        return (zzLu)zzLu2.zzXCD();
    }

    final zzZi7 zzXXR() {
        zzZi7 zzZi72 = this.zzZL5();
        return (zzZi7)zzZi72.zzXCD();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz71(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz71().getNodeType() == 8;
    }

    private void zzY5U(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYfe.zzWu6(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzWjc(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZLC) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZwF(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzWjc(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzVZ0();
        if (this.zz3N() != null && this.zz3N().zzX0t() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz71().getParentNode().insertBefore(node, this.zz71());
    }

    final void zzZwi(int n) {
        this.zzXmo(true);
        this.zzwM(n);
    }

    private void zzwM(int n) {
        this.insertParagraph();
        zzZVd zzZVd2 = new zzZVd(this.getDocument());
        try {
            zzZ9l zzZ9l2 = this.getCurrentSection().zzWz3();
            zzZ9l zzZ9l3 = (zzZ9l)zzZ9l2.zzXCD();
            Section section = new Section(this.zzxH, zzZ9l3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzxH));
            this.zzxH.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWOc(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZVd2.dispose();
        }
    }

    final FieldStart zzY0Y(int n) {
        this.zzVZ0();
        return zzWP7.zzYn3(n, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzFb(String string) {
        return zzWP7.zzWOc(string, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzXq8(int n, boolean bl) {
        return zzWP7.zzWOc(n, bl, this.zzwW(), this.zz71(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzXsr(int n) {
        return zzWP7.zzWOc(n, this.zzwW(), this.zz71(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzW6t(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzxH, new zzYPP(), this.zzwW());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzXmo(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz3N() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzW6J(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzWjc(String string) {
        if (this.zz7w(string)) {
            zzYOz zzYOz2 = new zzYOz(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXSg zzXSg2 : zzYOz2.zzYZF(this.getParagraphFormat().getBidi())) {
                zzY5U zzY5U2 = zzY5U.zzXqj(zzXSg2.zzXN9());
                zzYNV zzYNV2 = this.zzwW();
                zzYNV2.zzO6(265, zzY5U2);
                if (zzXSg2.zzWLd()) {
                    zzYNV2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzxH, zzXSg2.getText(), zzYNV2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZwF(string);
    }

    private boolean zz7w(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzZn6.zzXB1(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYn3(zzYNV zzYNV2, boolean bl) {
        zzYNV zzYNV3;
        if (bl) {
            zzYNV zzYNV4 = zzYNV2;
            zzYNV3 = (zzYNV)zzYNV4.zzXCD();
        } else {
            zzYNV3 = zzYNV2;
        }
        this.zzXZb = zzYNV3;
    }

    final void zzYEX() {
        this.zzXZb.clear();
    }

    final void zzZaY() {
        if (this.zzYh8() != null) {
            zzZi7 zzZi72;
            zzZi7 zzZi73 = zzZi72 = this.zzYh8().zzZL5();
            this.zzXaM = (zzZi7)zzZi73.zzXCD();
            zzZi72.zzWOc(this.zzXaM);
        }
    }

    private Shape zzYn3(String string, boolean bl, boolean bl2, zzXrY zzXrY2, zzZwv zzZwv2) throws Exception {
        if (zzZwv2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYn3(zzXrY2, bl2, zzZwv2, string);
        zzX4u zzX4u2 = zzW8e.zzYn3(string, bl, bl2, zzZwv2);
        return DocumentBuilder.zzYn3(string, bl, shape, zzZwv2.zzXSR, zzX4u2);
    }

    private Shape zzYn3(String string, boolean bl, String string2, String string3, zzZwv zzZwv2) throws Exception {
        if (zzZwv2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzWFy.zzW4j(string);
        }
        Shape shape = string2 != null ? this.zzWdg(string2, string3) : this.zzYn3(null, string3, zzZwv2);
        zzX4u zzX4u2 = zzW8e.zzYn3(string, bl, true, zzZwv2);
        return DocumentBuilder.zzYn3(string, bl, shape, zzZwv2.zzXSR, zzX4u2);
    }

    private static Shape zzYn3(String string, boolean bl, Shape shape, String string2, zzX4u zzX4u2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzvZ(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWOc(zzX4u2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYn3(zzXrY zzXrY2, boolean bl, zzZwv zzZwv2, String string) throws Exception {
        if (zzZwv2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXrY2 != null) {
            return this.zzWk4(zzXrY2);
        }
        if (!bl) {
            return this.zzZVF(zzW8e.zzW5y().get("normal"));
        }
        String string2 = string != null ? zzWFy.zzW4j(string) : zzW8e.zzWcX(zzZwv2.zzY7);
        return this.zzYn3(zzZwv2, string2);
    }

    private Shape zzYn3(String string, String string2, zzZwv zzZwv2) throws Exception {
        if (zzZwv2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzW8e.zzWcX(zzZwv2.zzY7);
        }
        if (string != null) {
            return this.zzWdg(string, string2);
        }
        return this.zzYn3(zzZwv2, string2);
    }

    private Shape zzYn3(zzZwv zzZwv2, String string) throws Exception {
        if (zzZwv2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzW8e.zzYOz(zzZwv2.zzY7);
        zzXCz zzXCz2 = new zzXCz(byArray, null, string, this.getDocument().zzYEt());
        return this.zzZVF(zzXCz2.zzWpV());
    }

    private Shape zzWdg(String string, String string2) throws Exception {
        zzXCz zzXCz2 = new zzXCz(string, string2, this.getDocument().zzYEt());
        return this.zzZVF(zzXCz2.zzWpV());
    }

    private Shape zzWk4(zzXrY zzXrY2) throws Exception {
        byte[] byArray = zzWAB.zzWD0(zzXrY2);
        return this.zzZVF(byArray);
    }

    private Shape zzZVF(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzxH, 1);
        shape.zzvZ(75);
        shape.zzYn3(this.zzwW());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZtA(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYn3(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWOc(compositeNode, n);
            return;
        }
        this.zzXlm(compositeNode, n);
    }

    private void zzWOc(CompositeNode compositeNode, int n) {
        zzYLw zzYLw2 = zzYLw.zzYPQ(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzYLw2.zzYn3(null, true, true, true, false, true);
            node = zzYLw2.getNode();
            if (zzYLw2.zzYrO() && (!node.isComposite() || node.zzWYZ() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzYwE().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzWOc(null, node);
            this.zzZMT = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXlm(CompositeNode compositeNode, int n) {
        zzYLw zzYLw2 = zzYLw.zzZqQ(compositeNode);
        while (zzYLw2.getNode() != compositeNode || !zzYLw2.zzYrO()) {
            int n2;
            Node node = zzYLw2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYwE().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzWOc(null, node);
                this.zzZMT = n;
                return;
            }
            while (zzYLw2.zzYn3(null, false, true, true, false, true) && zzYLw2.zzYrO() && zzYLw2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzVZ0() {
        int n = this.zzZMT;
        if (n == 0) {
            return;
        }
        this.zzZMT = 0;
        Run run = zzWAB.zzYn3((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzcI(n);
        }
    }

    private Run zzZwF(String string) {
        Run run = new Run(this.zzxH, string, this.zzwW());
        this.insertNode(run);
        return run;
    }

    final boolean zzEO() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZXm() {
        return this.zzZLC;
    }

    final void zzXfr(int n) {
        this.zzZLC = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz71();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz71();
        }
        return (Paragraph)this.zz71().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzaL zz3N() {
        zzZFs<zzaL> zzZFs2 = this.zzWVi;
        if (zzZFs2.size() > 0) {
            return (zzaL)this.zzWVi.peek();
        }
        return null;
    }

    private Cell zzYh8() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZzS();
    }

    private zzZFs<zzYNV> zzZ8N() {
        if (this.zzAw == null) {
            this.zzAw = new zzZFs();
        }
        return this.zzAw;
    }

    private zzZFs<zzZ3c> zzZ4q() {
        if (this.zzRc == null) {
            this.zzRc = new zzZFs();
        }
        return this.zzRc;
    }

    private zzZFs<zzYn3> zzWfo() {
        if (this.zzX87 == null) {
            this.zzX87 = new zzZFs();
        }
        return this.zzX87;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXZb.zzYr(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYlE(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYlE(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXZb.zzO6(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXkI()) {
            this.getCurrentParagraph().zzXhl().zzO6(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXZb.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXZb.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXkI()) {
            this.getCurrentParagraph().zzXhl().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzW7b().zzYr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzW7b().zzXoa(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzW7b().zzYiR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzW7b().zzO6(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzW7b().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzW7b().clear();
        zzLu.zzVTw().zzWOc(this.zzW7b());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZL5().zzYr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZL5().zzXoa(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZL5().zzYiR(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzWAB.zzYn3(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzYh8() != null ? this.zzYh8().getCellFormat() : this.getCellFormat();
            border.zzYn3(cellFormat);
        }
        this.zzZL5().zzO6(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZL5().clear();
    }

    private Node zz71() {
        Node node = this.zzlZ != null && this.zzlZ.getParentNode() == null ? this.zzW79 : this.zzlZ;
        if (node != null && node.zzWYZ() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzXXd(Node node) {
        this.zzlZ = node;
        if (this.zzlZ != null) {
            this.zzW79 = this.zzlZ.getParentNode();
        }
    }

    private zzLu zzW7b() {
        if (this.zz3N() != null && this.zz3N().zzX0t() == 1) {
            return this.zzYKx;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzW7b();
        }
        return this.zzYKx;
    }

    private zzZi7 zzZL5() {
        if (this.zz3N() != null && this.zz3N().zzX0t() != 3) {
            return this.zzXaM;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZzS().zzZL5();
        }
        return this.zzXaM;
    }

    static final class zzYn3 {
        private zzYNV zzXZb;
        private zzYNV zzmX;

        public zzYn3(zzYNV zzYNV2, zzYNV zzYNV3) {
            this.zzXZb = zzYNV2;
            this.zzmX = zzYNV3;
        }

        public final zzYNV zzYCz() {
            return this.zzXZb;
        }

        public final zzYNV zzX3V() {
            return this.zzmX;
        }
    }
}

