/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.zzLD;
import com.aspose.words.zzSr;
import com.aspose.words.zzWP7;
import com.aspose.words.zzWti;
import com.aspose.words.zzZKF;
import com.aspose.words.zzZVd;
import com.aspose.words.zzZoq;
import com.aspose.words.zzl5;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWti,
Iterable<T> {
    private Node zzXaL;
    private Node zzXGz;
    private Node zzZB9;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzWOc((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZw3() {
        return this.zzX3w() != null;
    }

    final boolean zzWUO() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzg2() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZKF) {
                return true;
            }
            CompositeNode compositeNode = zzWAB.zzYn3((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzg2()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXaL;
    }

    public Node getLastChild() {
        return this.zzXGz;
    }

    final Node zzX3w() {
        return zzWP7.zzHP(this.getFirstChild(), false);
    }

    final Node zzW51() {
        return zzWP7.zzM8(this.getLastChild(), false);
    }

    final CompositeNode zzJq() {
        return (CompositeNode)zzWP7.zzHP(this.getFirstChild(), true);
    }

    final CompositeNode zzYcX() {
        return (CompositeNode)zzWP7.zzM8(this.getLastChild(), true);
    }

    final Node zzXMv() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzWP7.zzZyp((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZgo() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzWP7.zzZyp((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYn3(boolean bl, zzZoq zzZoq2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYn3(bl, zzZoq2);
        ((CompositeNode)super.zzYn3(bl, zzZoq2)).zzXGz = null;
        compositeNode.zzXaL = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXCT(node.zzYn3(true, zzZoq2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYkS(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYkS(StringBuilder stringBuilder) {
        this.zzsK(stringBuilder);
        zzWAB.zzWOc(stringBuilder, this.zzYwE());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWOc(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWP7.zzYfm(nodeType);
            Node node2 = node = bl ? this.zzX3w() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzVWh() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzl5.zzXlm(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzl5.zzAY(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzLD(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYn3(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYn3(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzWOc(oldChild, false);
    }

    private Node zzWOc(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYn3(node, (Node)this, null, 1);
        if (documentBase.zzZFQ() && zzWP7.zzWOa(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYn3(nodeChangingArgs);
        }
        if (!bl && zzWP7.zzW9i(node)) {
            zzWP7.zzYf8(node, false);
        }
        Node node2 = this.zzWzr(node);
        if (nodeChangingArgs != null) {
            documentBase.zzWOc(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzSr.zzYK9(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXCT(Node node) {
        node.getParentNode();
        if (this.zzXGz == null) {
            node.zzYUk(null);
            node.zzWfm(null);
            this.zzXaL = node;
        } else {
            node.zzYUk(this.zzXGz);
            node.zzWfm(null);
            this.zzXGz.zzWfm(node);
        }
        this.zzXGz = node;
        node.zzZB6(this);
        return node;
    }

    final void zzYn3(Node node, Node node2, Node node3) {
        this.zzYn3(node, node2, node3, false);
    }

    final void zzYn3(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWD0(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzWOc(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXlm(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzWP7.zzZyp(node3.getNodeType())) continue;
            if (zzWP7.zzWfA(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYwE().length();
    }

    String zzYwE() {
        return "";
    }

    final String zzWVO() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzsK(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzsK(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYkS(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYn3(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzWOc(visitor));
    }

    abstract int zzYn3(DocumentVisitor var1) throws Exception;

    abstract int zzWOc(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzWD0(Node var1);

    final Node zzYn3(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXYN(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzWD0(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzZVd(documentBase);
            try {
                compositeNode.zzWOc(node, true);
            }
            finally {
                ((zzZVd)object).dispose();
            }
        }
        if ((object = documentBase.zzYn3(node, null, (Node)this, 0)) != null) {
            documentBase.zzYn3((NodeChangingArgs)object);
        }
        if (this.zzXGz == null) {
            node.zzYUk(null);
            node.zzWfm(null);
            this.zzXaL = node;
            this.zzXGz = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzWOc(node, node2);
            } else {
                this.zzXlm(node, this.zzXaL);
            }
        } else if (node2 != null) {
            this.zzXlm(node, node2);
        } else {
            this.zzWOc(node, this.zzXGz);
        }
        node.zzZB6(this);
        if (object != null) {
            documentBase.zzWOc((NodeChangingArgs)object);
        }
        if (documentBase.zzZFQ()) {
            zzWP7.zzYn3(node, compositeNode, node3);
        }
        return node;
    }

    private void zzWOc(Node node, Node node2) {
        Node node3 = node2.zzZwt();
        node.zzYUk(node2);
        node.zzWfm(node3);
        node2.zzWfm(node);
        if (node3 == null) {
            this.zzXGz = node;
            return;
        }
        node3.zzYUk(node);
    }

    private void zzXlm(Node node, Node node2) {
        Node node3 = node2.zzWB3();
        node.zzYUk(node3);
        node.zzWfm(node2);
        node2.zzYUk(node);
        if (node3 == null) {
            this.zzXaL = node;
            return;
        }
        node3.zzWfm(node);
    }

    private Node zzWzr(Node node) {
        if (node == this.zzXaL) {
            if (this.zzXaL == this.zzXGz) {
                this.zzXaL = null;
                this.zzXGz = null;
            } else {
                this.zzXaL = node.zzZwt();
                this.zzXaL.zzYUk(null);
            }
        } else {
            Node node2 = node.zzWB3();
            Node node3 = node.zzZwt();
            node2.zzWfm(node3);
            if (node3 == null) {
                this.zzXGz = node2;
            } else {
                node3.zzYUk(node2);
            }
        }
        node.zzWfm(null);
        node.zzYUk(null);
        node.zzZB6(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZB9 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZB9;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

