/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.internal.zzYWS;
import com.aspose.words.zzWUX;
import com.aspose.words.zzXGv;
import com.aspose.words.zzXaP;
import com.aspose.words.zzXmC;
import com.aspose.words.zzYT7;
import com.aspose.words.zzYnx;
import com.aspose.words.zzYyU;
import com.aspose.words.zzZQU;
import com.aspose.words.zzaO;
import com.aspose.words.zzo8;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzXmC zzWpR;

    ChartSeriesCollection(zzXmC dmlChart) {
        this.zzWpR = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpR.zzZkz().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpR.zzZkz().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWpR.zzZkz().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzWpR.zzZkz().clear();
        this.zzXYN(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYn3(seriesName, values);
        chartSeries.zzJl().zzAY(ChartSeriesCollection.zzsK(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYn3(seriesName, yValues);
        chartSeries.zzJl().zzAY(ChartSeriesCollection.zzAY(xValues));
        return chartSeries;
    }

    private ChartSeries zzYn3(String string, zzYWS[] zzYWSArray, double[] dArray) {
        if (zzYWSArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYWSArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYWSArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYn3(string, dArray);
        chartSeries.zzJl().zzAY(ChartSeriesCollection.zzYn3(zzYWSArray));
        if (!this.zzWpR.zzZ4d()) {
            this.zzXYN(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYn3(seriesName, zzYWS.zzYn3(dates), values);
    }

    private void zzXYN(boolean bl) {
        zzo8 zzo82 = zzWAB.zzYn3((Object)this.zzWpR, zzo8.class);
        if (zzo82 != null && zzo82.zzZUw().zzyo()) {
            zzo82.zzZUw().zzWbA().zzWFJ(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzWpR.zzZym() != 15) {
            this.zzWpR.zzWdc(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYn3(seriesName, yValues);
        chartSeries.zzZ5z().zzWCU().zzWFJ(3, this.zzWpR.zzZgx());
        chartSeries.zzJl().zzAY(ChartSeriesCollection.zzAY(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzXP1().zzAY(ChartSeriesCollection.zzAY(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYn3(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzWpR);
        chartSeries.setName(string);
        this.zzWD0(chartSeries);
        chartSeries.zzZFh(this.zzWpR.zzdr().zzsA() + 1);
        chartSeries.zzZd1(this.zzWpR.zzdr().zzWIt() + 1);
        chartSeries.zzWzQ().zzAY(ChartSeriesCollection.zzAY(dArray));
        this.zzWpR.zzVYL().zzZoH();
        this.zzWpR.zzYPa(chartSeries);
        return chartSeries;
    }

    private void zzWD0(ChartSeries chartSeries) {
        chartSeries.zzZ5z().zzWCU().zzWFJ(5, new zzWUX());
        switch (this.zzWpR.zzZym()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYn3(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYn3(chartSeries, 5);
                ChartSeriesCollection.zzM8(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYn3(chartSeries, 1);
                ChartSeriesCollection.zzM8(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzHP(chartSeries);
            }
        }
    }

    private static void zzHP(ChartSeries chartSeries) {
        zzWUX zzWUX2 = new zzWUX();
        zzWUX2.setOutline(new zzYnx());
        zzaO zzaO2 = new zzaO();
        zzaO2.zzZoz(1);
        zzWUX2.getOutline().setFill(new zzZQU(zzaO2));
        zzWUX2.getOutline().zzZmM(19050.0);
        chartSeries.zzZ5z().zzWCU().zzWFJ(5, zzWUX2);
    }

    private static void zzM8(ChartSeries chartSeries) {
        zzWUX zzWUX2 = new zzWUX();
        zzWUX2.setOutline(new zzYnx());
        zzWUX2.getOutline().setFill(new zzYyU());
        zzWUX2.getOutline().setEndCap(0);
        zzWUX2.getOutline().zzZmM(19050.0);
        chartSeries.zzZ5z().zzWCU().zzWFJ(5, zzWUX2);
    }

    private static void zzYn3(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzEZ());
        chartMarker.zzWsj().zzWFJ(0, n);
        chartSeries.zzZ5z().zzWCU().zzWFJ(4, chartMarker);
    }

    private static zzXGv zzAY(double[] dArray) {
        int n = 0;
        zzXGv zzXGv2 = new zzXGv(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzXGv2.zzWD0(new zzXaP(n, d, "General"));
            }
            ++n;
        }
        zzXGv2.zzW2J(dArray.length);
        return zzXGv2;
    }

    private static zzXGv zzYn3(zzYWS[] zzYWSArray) {
        int n = 0;
        zzXGv zzXGv2 = new zzXGv(2);
        zzYWS[] zzYWSArray2 = zzYWSArray;
        int n2 = zzYWSArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYWS zzYWS2 = zzYWSArray2[i];
            zzXGv2.zzWD0(new zzXaP(n++, zzYWS2.zzYFF(), "m/d/yyyy"));
        }
        zzXGv2.zzW2J(zzYWSArray.length);
        return zzXGv2;
    }

    private static zzXGv zzsK(String[] stringArray) {
        int n = 0;
        zzXGv zzXGv2 = new zzXGv(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzXGv2.zzWD0(new zzYT7(n++, string));
        }
        zzXGv2.zzW2J(stringArray.length);
        return zzXGv2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzWpR.zzZkz().size();
    }
}

