/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzWAB;
import com.aspose.words.zzHr;
import com.aspose.words.zzWP7;
import com.aspose.words.zzXiA;
import com.aspose.words.zzXsJ;
import com.aspose.words.zzYfe;
import com.aspose.words.zzZ76;
import com.aspose.words.zzZGs;
import com.aspose.words.zzZi7;
import com.aspose.words.zzZiK;
import com.aspose.words.zzZoq;

public class Cell
extends CompositeNode<Node>
implements zzZGs,
zzZiK {
    private zzZi7 zzXaM;
    private CellFormat zzwV;
    private ParagraphCollection zzXI3;
    private TableCollection zzYoa;

    public Cell(DocumentBase doc) {
        this(doc, new zzZi7());
    }

    Cell(DocumentBase doc, zzZi7 cellPr) {
        super(doc);
        this.zzXaM = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzY3q() {
        return (Cell)this.zzZbE();
    }

    public Row getParentRow() {
        return (Row)this.zzqz();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzWEK() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzXlm(this, true);
        }
        return -1;
    }

    final int zzYAU() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYAU();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzwV == null) {
            this.zzwV = new CellFormat(this);
        }
        return this.zzwV;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXI3 == null) {
            this.zzXI3 = new ParagraphCollection(this);
        }
        return this.zzXI3;
    }

    public TableCollection getTables() {
        if (this.zzYoa == null) {
            this.zzYoa = new TableCollection(this);
        }
        return this.zzYoa;
    }

    final zzZi7 zzZL5() {
        return this.zzXaM;
    }

    final void zzYn3(zzZi7 zzZi72) {
        this.zzXaM = zzZi72;
    }

    @Override
    final Node zzYn3(boolean bl, zzZoq zzZoq2) {
        zzZi7 zzZi72;
        Cell cell = (Cell)super.zzYn3(bl, zzZoq2);
        zzZi7 zzZi73 = this.zzXaM;
        cell.zzXaM = zzZi72 = (zzZi7)zzZi73.zzXCD();
        cell.zzwV = null;
        cell.zzXI3 = null;
        cell.zzYoa = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYn3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzWOc(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzYfe.zzWUa(this);
    }

    @Override
    final boolean zzWD0(Node node) {
        return zzWP7.zz3f(node);
    }

    final int zzXji() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzZbE();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXaM.zzYr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXaM.zzYr(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzXiA zzXiA2 = zzWAB.zzYn3(object, zzXiA.class);
        if (zzXiA2 != null && zzXiA2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYW6(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzZi7.zzWNe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXaM.zzO6(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXaM.clear();
    }

    private Object zzYW6(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzWAB.zzYn3((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYn3(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXsJ getInsertRevision() {
        Cell cell = this;
        return cell.zzXaM.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXsJ value) {
        zzZiK zzZiK2 = this;
        zzXsJ zzXsJ2 = value;
        zzZiK2 = zzZiK2.zzXaM;
        ((zzZ76)((Object)zzZiK2)).zzO6(14, zzXsJ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXsJ getDeleteRevision() {
        Cell cell = this;
        return cell.zzXaM.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXsJ value) {
        zzZiK zzZiK2 = this;
        zzXsJ zzXsJ2 = value;
        zzZiK2 = zzZiK2.zzXaM;
        ((zzZ76)((Object)zzZiK2)).zzO6(12, zzXsJ2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzHr getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXaM.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzHr value) {
        zzZiK zzZiK2 = this;
        zzHr zzHr2 = value;
        zzZiK2 = zzZiK2.zzXaM;
        ((zzZ76)((Object)zzZiK2)).zzO6(13, zzHr2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzHr getMoveToRevision() {
        Cell cell = this;
        return cell.zzXaM.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzHr value) {
        zzZiK zzZiK2 = this;
        zzHr zzHr2 = value;
        zzZiK2 = zzZiK2.zzXaM;
        ((zzZ76)((Object)zzZiK2)).zzO6(15, zzHr2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXaM.remove(13);
        cell = this;
        cell.zzXaM.remove(15);
    }

    final zzZi7 zzWND(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzZi7 zzZi72 = new zzZi7();
        this.zzYn3(3120, zzZi72);
        this.zzYn3(3140, zzZi72);
        this.zzYn3(3110, zzZi72);
        this.zzYn3(3130, zzZi72);
        this.zzYn3(3090, zzZi72);
        this.zzYn3(3100, zzZi72);
        this.zzYn3(3070, zzZi72);
        this.zzYn3(3080, zzZi72);
        if (bl && (tableStyle = zzWAB.zzYn3((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWOc(this, zzZi72);
        }
        this.zzXaM.zzWOc((zzZ76)zzZi72);
        return zzZi72;
    }

    private void zzYn3(int n, zzZi7 zzZi72) {
        zzZi72.zzO6(n, this.fetchInheritedCellAttr(n));
    }
}

