/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tex;

import com.aspose.tex.I371;
import com.aspose.tex.TeXInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class NondisposableInputStream
extends TeXInputStream {
    private I371 lif;
    private int ll = 0;

    public NondisposableInputStream() {
        super(new ByteArrayInputStream(new byte[0]));
        this.lif = new I371();
    }

    public NondisposableInputStream(InputStream inputStream) throws IOException {
        super(new ByteArrayInputStream(new byte[0]));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            NondisposableInputStream.lif(inputStream, byteArrayOutputStream);
            this.lif = new I371(byteArrayOutputStream.toByteArray());
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    private static void lif(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
    }

    NondisposableInputStream(I371 stream) {
        super(new ByteArrayInputStream(new byte[0]));
        this.lif = stream;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.lif.l0l();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        try {
            int n = this.read(b, 0, b.length);
            return n == 0 ? -1 : n;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("Argument 'off' is negative.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Argument 'len' is negative.");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("'len' > 'b.length' - 'off'.");
        }
        try {
            int n = this.lif.lif(b, off, len);
            return n == 0 ? -1 : n;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return (int)(this.lif.liF() - this.lif.lIf());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.ll = (int)this.lif.lIf();
    }

    @Override
    public void reset() throws IOException {
        try {
            this.lif.lif((long)this.ll);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long l = Math.min((long)this.available(), n);
        this.lif.lif(this.lif.lIf() + l);
        return l;
    }

    @Override
    public void close() throws IOException {
        try {
            this.lif.lif(0L);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    long lif() {
        return this.lif.liF();
    }
}

