/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.tex.internal.l851;

import com.aspose.tex.internal.l851.I2l;
import java.security.InvalidParameterException;
import java.security.cert.CertPathParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class I27
implements CertPathParameters {
    private final I2l lif;
    private final Set<X509Certificate> ll;
    private final int lI;

    private I27(I7 i7) {
        this.lif = i7.lif;
        this.ll = Collections.unmodifiableSet(i7.lI);
        this.lI = i7.ll;
    }

    public I2l lif() {
        return this.lif;
    }

    public Set ll() {
        return this.ll;
    }

    public int lI() {
        return this.lI;
    }

    public Object clone() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class I7 {
        private final I2l lif;
        private int ll = 5;
        private Set<X509Certificate> lI = new HashSet<X509Certificate>();

        public I7(PKIXBuilderParameters pKIXBuilderParameters) {
            this.lif = new I2l.I7(pKIXBuilderParameters).lif();
            this.ll = pKIXBuilderParameters.getMaxPathLength();
        }

        public I7(I2l i2l) {
            this.lif = i2l;
        }

        public I7 lif(Set<X509Certificate> set) {
            this.lI.addAll(set);
            return this;
        }

        public I7 lif(int n2) {
            if (n2 < -1) {
                throw new InvalidParameterException("The maximum path length parameter can not be less than -1.");
            }
            this.ll = n2;
            return this;
        }

        public I27 lif() {
            return new I27(this);
        }
    }
}

