/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.wu;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.FileNotFoundException;
import com.aspose.slides.exceptions.IOException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.ObjectDisposedException;
import com.aspose.slides.internal.b0.ic;
import com.aspose.slides.internal.wu.dj;
import com.aspose.slides.internal.wu.e1;
import com.aspose.slides.internal.wu.el;
import com.aspose.slides.ms.System.eu;
import com.aspose.slides.ms.System.qn;
import com.aspose.slides.ms.System.si;
import java.io.File;

public class t9
extends dj {
    private boolean l0 = false;
    private boolean ql;
    private boolean r2;
    private boolean ic;
    private ic yx;
    private final String ek;

    public t9(String string, int n) {
        this(string, n, n == 6 ? 2 : 3);
    }

    private t9(int n, String string, int n10, int n11) {
        String string2;
        if (n != -2 && n <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n > 0;
        this.ek = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (qn.ql(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n10 < 1 || n10 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n11 < 1 || n11 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n11 == 1) {
            this.r2 = false;
            this.ql = true;
            string2 = "r";
        } else if (n11 == 2) {
            this.r2 = true;
            this.ql = false;
            string2 = "rw";
        } else {
            this.r2 = true;
            this.ql = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n10 == 6) {
            if (n11 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n11 == 1) {
                throw new ArgumentException(qn.l0("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{si.getName(e1.class, n10), si.getName(el.class, n11)}));
            }
        }
        if ((n10 == 2 || n10 == 1 || n10 == 5) && n11 == 1) {
            throw new ArgumentException(qn.l0("Combining FileMode: {0} with FileAccess: {1} is invalid.", new Object[]{si.getName(e1.class, n10), si.getName(el.class, n11)}));
        }
        if (file.exists()) {
            if (n10 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n10 == 2 || n10 == 5) {
                file.delete();
            }
            this.yx = bl2 ? new ic(file, string2, n) : new ic(file, string2);
            if (n10 == 6) {
                this.yx.l0(this.yx.ic());
            }
        } else {
            if (n10 == 3 || n10 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.yx = new ic(file, string2, n);
            } else if (string2.equals("r") && n10 == 4) {
                string2 = "rw";
                this.yx = new ic(file, string2);
                this.yx.l0(true);
            } else {
                this.yx = new ic(file, string2);
            }
        }
        this.ic = true;
    }

    public t9(String string, int n, int n10) {
        this(-2, string, n, n10);
    }

    public t9(String string, int n, int n10, int n11) {
        this(string, n, n10);
    }

    public t9(String string, int n, int n10, int n11, int n12) {
        this(n12, string, n, n10);
    }

    @Override
    public boolean canRead() {
        return this.ql;
    }

    @Override
    public boolean canSeek() {
        return this.ic;
    }

    @Override
    public boolean canWrite() {
        return this.r2;
    }

    @Override
    public long getLength() {
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.yx.ic();
    }

    @Override
    public long getPosition() {
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.yx.r2();
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.yx.l0(position);
    }

    @Override
    public void flush() {
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.yx.yx();
    }

    @Override
    public long seek(long offset, int origin) {
        if (origin < 0 || origin > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (origin) {
            case 0: {
                this.yx.l0(offset);
                break;
            }
            case 1: {
                this.yx.l0(this.yx.r2() + offset);
                break;
            }
            case 2: {
                this.yx.l0(this.yx.ic() + offset);
            }
        }
        return this.yx.r2();
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (this.yx != null && !this.yx.ql()) {
                this.yx.l0();
            }
        }
        finally {
            this.ql = false;
            this.r2 = false;
            this.ic = false;
            super.dispose(disposing);
            this.l0 = true;
        }
    }

    @Override
    public void setLength(long length) {
        if (length < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (length == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.r2) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yx.r2(length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.ql) {
            int n = this.yx.ql(buffer, offset, count);
            return n == -1 ? 0 : n;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.ql) {
            return this.yx.ek();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (array.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.r2) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yx.write(array, offset, count);
    }

    @Override
    public void writeByte(byte value) {
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.r2) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.yx.write(value);
    }

    public String l0() {
        return this.ek;
    }

    @Override
    public eu beginRead(byte[] buffer, int offset, int count, com.aspose.slides.ms.System.el callback, Object state) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (buffer.length - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(buffer, offset, count, callback, state);
    }

    @Override
    public int endRead(eu asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(asyncResult);
    }

    @Override
    public eu beginWrite(byte[] array, int offset, int numBytes, com.aspose.slides.ms.System.el userCallback, Object stateObject) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (numBytes < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (array.length - offset < numBytes) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.l0) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(array, offset, numBytes, userCallback, stateObject);
    }

    @Override
    public void endWrite(eu asyncResult) {
        if (asyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(asyncResult);
    }
}

