/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.ra;
import com.aspose.slides.ms.System.u1;
import java.util.Arrays;

@u1
public class Stack
implements ICollection,
IEnumerable,
g0 {
    private Object[] l0;
    private int ql = -1;
    private int r2;
    private int ic;
    private int yx;

    private void l0(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.ic.l0(this.l0, 0, objectArray, 0, this.r2);
        this.ic = n;
        this.l0 = objectArray;
    }

    public Stack() {
        this.l0 = new Object[16];
        this.ic = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.ic = initialCapacity;
        this.l0 = new Object[this.ic];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.r2;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.yx;
        for (int i = 0; i < this.r2; ++i) {
            this.l0[i] = null;
        }
        this.r2 = 0;
        this.ql = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.ic.l0(this.l0));
        stack.ql = this.ql;
        stack.r2 = this.r2;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.r2 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.r2; ++i) {
                if (this.l0[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.r2; ++i) {
                if (!obj.equals(this.l0[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(ic array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ic() > 1 || array.yx() > 0 && index >= array.yx() || this.r2 > array.yx() - index) {
            throw new ArgumentException();
        }
        for (int i = this.ql; i != -1; --i) {
            array.r2(this.l0[i], this.r2 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.ql == -1) {
            throw new InvalidOperationException();
        }
        return this.l0[this.ql];
    }

    public Object pop() {
        if (this.ql == -1) {
            throw new InvalidOperationException();
        }
        ++this.yx;
        Object object = this.l0[this.ql];
        this.l0[this.ql] = null;
        --this.r2;
        --this.ql;
        if (this.r2 <= this.ic / 4 && this.r2 > 16) {
            this.l0(this.ic / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.yx;
        if (this.ic == this.r2) {
            this.l0(this.ic * 2);
        }
        ++this.r2;
        ++this.ql;
        this.l0[this.ql] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.r2) {
            a = Arrays.copyOf(this.l0, this.r2, a.getClass());
            ra.l0(a);
            return a;
        }
        System.arraycopy(this.l0, 0, a, 0, this.r2);
        if (a.length > this.r2) {
            a[this.r2] = null;
        }
        ra.l0(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    g0,
    Cloneable {
        private Stack l0;
        private int ql;
        private int r2;

        Enumerator(Stack s) {
            this.l0 = s;
            this.ql = s.yx;
            this.r2 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.l0();
        }

        @Override
        public Object next() {
            if (this.ql != this.l0.yx || this.r2 == -2 || this.r2 == -1 || this.r2 > this.l0.r2) {
                throw new InvalidOperationException();
            }
            return this.l0.l0[this.r2];
        }

        @Override
        public boolean hasNext() {
            if (this.ql != this.l0.yx) {
                throw new InvalidOperationException();
            }
            switch (this.r2) {
                case -2: {
                    this.r2 = this.l0.ql;
                    return this.r2 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.r2;
            return this.r2 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.ql != this.l0.yx) {
                throw new InvalidOperationException();
            }
            this.r2 = -2;
        }

        protected Object l0() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.l0 = this.l0;
            enumerator.ql = this.ql;
            enumerator.r2 = this.r2;
            return enumerator;
        }
    }

    @u1
    private static class SyncStack
    extends Stack {
        private final Stack l0;

        SyncStack(Stack s) {
            this.l0 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.l0;
            synchronized (stack) {
                return this.l0.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.l0;
            synchronized (stack) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.l0;
            synchronized (stack) {
                return Stack.sync((Stack)this.l0.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.l0;
            synchronized (stack) {
                return this.l0.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int index) {
            Stack stack = this.l0;
            synchronized (stack) {
                this.l0.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.l0;
            synchronized (stack) {
                return new Enumerator(this.l0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.l0;
            synchronized (stack) {
                return this.l0.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.l0;
            synchronized (stack) {
                return this.l0.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.l0;
            synchronized (stack) {
                this.l0.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.l0;
            synchronized (stack) {
                return this.l0.toArray(a);
            }
        }
    }
}

