/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qn;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.si;
import com.aspose.slides.ms.System.u1;
import java.util.Comparator;

@u1
public class SortedList
implements IDictionary,
g0 {
    private final Object l0 = new Object();
    private Slot[] ql;
    private Comparator r2;
    private int ic;
    private int yx;
    private int ek;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.ek = capacity == 0 ? 0 : 16;
        this.r2 = comparer;
        this.ql(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.r2 = comparer;
        this.ql(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.ql(d.size(), true);
        this.r2 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.ic;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.l0;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.l0(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.ql(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.l0(key, value, true);
    }

    public int getCapacity() {
        return this.ql.length;
    }

    public void setCapacity(int value) {
        int n = this.ql.length;
        if (this.ic > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.l0(this.ek);
            SortedList.l0(this.ql, 0, slotArray, 0, this.ic);
            this.ql = slotArray;
        } else if (value > this.ic) {
            Slot[] slotArray = SortedList.l0(value);
            SortedList.l0(this.ql, 0, slotArray, 0, this.ic);
            this.ql = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.l0(value);
            SortedList.l0(this.ql, 0, slotArray, 0, n);
            this.ql = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.l0(key, value, false);
    }

    @Override
    public void clear() {
        this.ek = 16;
        this.ql = SortedList.l0(this.ek);
        this.ic = 0;
        ++this.yx;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.ql(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(ic array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.ic() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.yx()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.yx() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.r2(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.r2);
        sortedList.yx = this.yx;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.ql;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.l0(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].l0 = null;
                slotArray[index].ql = null;
            }
            --this.ic;
            ++this.yx;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.ql(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.ic == 0) {
            return -1;
        }
        for (int i = 0; i < this.ic; ++i) {
            Slot slot = this.ql[i].Clone();
            if (!qu.l0(value, slot.ql)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.ql[index].ql;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.ql[index].ql = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.ql[index].l0;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.l0(this.ek, false);
        } else {
            this.l0(this.size(), true);
        }
    }

    private void l0(int n, boolean bl2) {
        Slot[] slotArray = this.ql;
        Slot[] slotArray2 = SortedList.l0(n);
        if (bl2) {
            SortedList.l0(slotArray, 0, slotArray2, 0, n);
        }
        this.ql = slotArray2;
    }

    private void l0(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.ql;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.l0(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.l0(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.l0(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.l0(slotArray, 0, slotArray2, 0, this.size());
            }
            this.ql = slotArray2;
        } else if (bl2) {
            SortedList.l0(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void l0(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.ql;
        int n = -1;
        try {
            n = this.ql(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = qn.l0("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].ql = object2;
            ++this.yx;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(qn.l0(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.l0(this.size() + 1, n);
        slotArray = this.ql;
        slotArray[n].l0 = object;
        slotArray[n].ql = object2;
        ++this.ic;
        ++this.yx;
    }

    private Object l0(Object object) {
        int n = this.ql(object);
        if (n >= 0) {
            return this.ql[n].ql;
        }
        return null;
    }

    private void ql(int n, boolean bl2) {
        if (!bl2 && n < this.ek) {
            n = this.ek;
        }
        this.ql = SortedList.l0(n);
        this.ic = 0;
        this.yx = 0;
    }

    private void l0(ic ic2, int n, int n10) {
        if (ic2 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > ic2.yx()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            ic2.r2(enumerator.next(), n++);
        }
    }

    private int ql(Object object) {
        Slot[] slotArray = this.ql;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.r2 == null ? Comparer.Default : this.r2;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].l0, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] l0(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean l0(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void l0(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.l0(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList l0;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.l0 = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.l0.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.l0.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                iCollection = this.l0.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                iCollection = this.l0.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.l0(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.l0(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int arrayIndex) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.l0(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.ql(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.l0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.l0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.trimToSize();
            }
        }
    }

    @u1
    private static class ListValues
    implements IList {
        private SortedList l0;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.l0 = host;
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            this.l0.l0(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.l0.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.l0.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.l0, 1);
        }
    }

    @u1
    private static class ListKeys
    implements IList {
        private SortedList l0;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.l0 = host;
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            this.l0.l0(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.l0.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.l0.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.l0.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.l0, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    g0 {
        private SortedList l0;
        private Object ql;
        private Object r2;
        private int ic;
        private int yx;
        private int ek;
        private int el;
        private boolean yw = false;
        private static String n6 = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.l0 = host;
            this.ic = host.yx;
            this.ek = host.size();
            this.el = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.l0.yx != this.ic || this.yw) {
                throw new IllegalStateException(n6);
            }
            this.yx = -1;
            this.ql = null;
            this.r2 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.l0.yx != this.ic || this.yw) {
                throw new InvalidOperationException(n6);
            }
            return ++this.yx < this.ek;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return new DictionaryEntry(this.ql, this.r2);
        }

        @Override
        public Object getKey() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return this.ql;
        }

        @Override
        public Object getValue() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return this.r2;
        }

        @Override
        public Object next() {
            if (this.l0.yx != this.ic || this.yw) {
                throw new InvalidOperationException(n6);
            }
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                if (this.yx >= this.ek) {
                    this.ql = null;
                    this.r2 = null;
                }
                throw new IllegalStateException(n6);
            }
            Slot[] slotArray = this.l0.ql;
            Slot slot = slotArray[this.yx].Clone();
            this.ql = slot.l0;
            this.r2 = slot.ql;
            switch (this.el) {
                case 0: {
                    return this.ql;
                }
                case 1: {
                    return this.r2;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(qn.l0(new String[]{si.getName(EnumeratorMode.class, this.el), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.l0, this.el);
            enumeratorJava.ic = this.ic;
            enumeratorJava.yx = this.yx;
            enumeratorJava.ek = this.ek;
            enumeratorJava.ql = this.ql;
            enumeratorJava.r2 = this.r2;
            enumeratorJava.yw = this.yw;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    g0 {
        private SortedList l0;
        private Object ql;
        private Object r2;
        private int ic;
        private int yx;
        private int ek;
        private int el;
        private boolean yw = false;
        private static String n6 = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.l0 = host;
            this.ic = host.yx;
            this.ek = host.size();
            this.el = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.l0.yx != this.ic || this.yw) {
                throw new IllegalStateException(n6);
            }
            this.yx = -1;
            this.ql = null;
            this.r2 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.l0.yx != this.ic || this.yw) {
                throw new InvalidOperationException(n6);
            }
            Slot[] slotArray = this.l0.ql;
            if (++this.yx < this.ek) {
                Slot slot = slotArray[this.yx].Clone();
                this.ql = slot.l0;
                this.r2 = slot.ql;
                return true;
            }
            this.ql = null;
            this.r2 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return new DictionaryEntry(this.ql, this.r2);
        }

        @Override
        public Object getKey() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return this.ql;
        }

        @Override
        public Object getValue() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            return this.r2;
        }

        @Override
        public Object next() {
            if (this.yw || this.yx >= this.ek || this.yx == -1) {
                throw new IllegalStateException(n6);
            }
            switch (this.el) {
                case 0: {
                    return this.ql;
                }
                case 1: {
                    return this.r2;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(qn.l0(new String[]{si.getName(EnumeratorMode.class, this.el), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.l0, this.el);
            enumerator.ic = this.ic;
            enumerator.yx = this.yx;
            enumerator.ek = this.ek;
            enumerator.ql = this.ql;
            enumerator.r2 = this.r2;
            enumerator.yw = this.yw;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends si {
        private EnumeratorMode() {
        }

        static {
            si.register(new si.yx(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @u1
    public static class Slot
    extends el<Slot> {
        Object l0;
        Object ql;

        @Override
        public void CloneTo(Slot that) {
            that.l0 = this.l0;
            that.ql = this.ql;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean l0(Slot slot) {
            return qu.l0(slot.l0, this.l0) && qu.l0(slot.ql, this.ql);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.l0((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.l0 != null ? this.l0.hashCode() : 0;
            n = 31 * n + (this.ql != null ? this.ql.hashCode() : 0);
            return n;
        }
    }
}

