/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.ObjectModel;

import com.aspose.slides.Collections.Generic.Dictionary;
import com.aspose.slides.Collections.Generic.EqualityComparer;
import com.aspose.slides.Collections.Generic.IGenericDictionary;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ObjectModel.Collection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.KeyNotFoundException;
import com.aspose.slides.ms.System.u1;

@u1
public abstract class KeyedCollection<TKey, TItem>
extends Collection<TItem> {
    private Dictionary<TKey, TItem> l0;
    private IGenericEqualityComparer<TKey> ql;
    private int r2;

    protected KeyedCollection() {
        this(null, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer) {
        this(comparer, 0);
    }

    protected KeyedCollection(IGenericEqualityComparer<TKey> comparer, int dictionaryCreationThreshold) {
        this.ql = comparer != null ? comparer : new EqualityComparer.DefaultComparer<TKey>();
        this.r2 = dictionaryCreationThreshold;
        if (dictionaryCreationThreshold == 0) {
            this.l0 = new Dictionary(this.ql);
        }
    }

    public boolean containsKey(TKey key) {
        if (this.l0 != null) {
            return this.l0.containsKey(key);
        }
        return this.l0(key) >= 0;
    }

    private int l0(TKey TKey) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TKey TKey2 = this.getKeyForItem(super.get_Item(i));
            if (!this.ql.equalsT(TKey, TKey2)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeByKey(TKey key) {
        Object object = null;
        if (this.l0 != null) {
            Object[] objectArray = new Object[]{object};
            boolean bl2 = this.l0.tryGetValue(key, objectArray);
            object = objectArray[0];
            if (bl2) {
                return super.removeItem(object);
            }
            return false;
        }
        int n = this.l0(key);
        if (n == -1) {
            return false;
        }
        this.removeAt(n);
        return true;
    }

    public IGenericEqualityComparer<TKey> getComparer() {
        return this.ql;
    }

    @Override
    public TItem get_Item(int index) {
        if (this.l0 != null && ((Dictionary.KeyCollection)this.l0.getKeys()).size() > 0) {
            IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)this.l0.getKeys()).iterator();
            if (iGenericEnumerator.hasNext() && iGenericEnumerator.next() instanceof Integer) {
                return this.get_Item((TKey)index);
            }
            return (TItem)super.get_Item(index);
        }
        return (TItem)super.get_Item(index);
    }

    public TItem get_Item(TKey key) {
        if (this.l0 != null) {
            return this.l0.get_Item(key);
        }
        int n = this.l0(key);
        if (n >= 0) {
            return (TItem)super.get_Item(n);
        }
        throw new KeyNotFoundException();
    }

    protected void changeItemKey(TItem item, TKey newKey) {
        if (!this.containsItem(item)) {
            throw new ArgumentException();
        }
        TKey TKey = this.getKeyForItem(item);
        if (this.ql.equalsT(TKey, newKey)) {
            return;
        }
        if (this.containsKey(newKey)) {
            throw new ArgumentException();
        }
        if (this.l0 != null) {
            if (!this.l0.removeItemByKey(TKey)) {
                throw new ArgumentException();
            }
            this.l0.addItem(newKey, item);
        }
    }

    @Override
    public void clear() {
        if (this.l0 != null) {
            this.l0.clear();
        }
        super.clear();
    }

    protected abstract TKey getKeyForItem(TItem var1);

    @Override
    public void insertItem(int index, TItem item) {
        int n;
        TKey TKey = this.getKeyForItem(item);
        if (TKey == null) {
            throw new ArgumentNullException("GetKeyForItem(item)");
        }
        if (this.l0 != null && this.l0.containsKey(TKey)) {
            throw new ArgumentException("An element with the same key already exists in the dictionary.");
        }
        if (this.l0 == null) {
            for (n = 0; n < this.size(); ++n) {
                if (!this.ql.equalsT(TKey, this.getKeyForItem(super.get_Item(n)))) continue;
                throw new ArgumentException("An element with the same key already exists in the dictionary.");
            }
        }
        super.insertItem(index, item);
        if (this.l0 != null) {
            this.l0.addItem(TKey, item);
        } else if (this.r2 != -1 && this.size() > this.r2) {
            this.l0 = new Dictionary(this.ql);
            for (n = 0; n < this.size(); ++n) {
                Object t = super.get_Item(n);
                this.l0.addItem(this.getKeyForItem(t), t);
            }
        }
    }

    @Override
    public void removeAt(int index) {
        if (this.l0 != null) {
            TKey TKey = this.getKeyForItem(super.get_Item(index));
            this.l0.removeItemByKey(TKey);
        }
        super.removeAt(index);
    }

    @Override
    public void setItem(int index, TItem item) {
        if (this.l0 != null) {
            this.l0.removeItemByKey(this.getKeyForItem(super.get_Item(index)));
            this.l0.addItem(this.getKeyForItem(item), item);
        }
        super.setItem(index, item);
    }

    protected IGenericDictionary<TKey, TItem> getDictionary() {
        return this.l0;
    }
}

