/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.in.el;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.ra;
import com.aspose.slides.ms.System.u1;
import java.util.Arrays;

@u1
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] l0;
    private int ql;
    private int r2;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.l0 = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.ql = collection.size();
            this.l0 = new Object[this.ql];
            collection.copyToTArray(this.l0, 0);
        }
    }

    public void clear() {
        if (this.l0 != null) {
            ic.l0(this.l0, 0, this.l0.length);
        }
        this.ql = 0;
        ++this.r2;
    }

    public boolean contains(T item) {
        return this.l0 != null && ic.l0(this.l0, item, 0, this.ql) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.ql - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.l0 != null) {
            ic.l0(this.l0, 0, array, arrayIndex, this.ql);
            ra.l0(array, arrayIndex, this.ql);
        }
    }

    public T peek() {
        if (this.ql == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.l0[this.ql - 1];
    }

    public T pop() {
        if (this.ql == 0) {
            throw new InvalidOperationException();
        }
        ++this.r2;
        Object object = this.l0[--this.ql];
        this.l0[this.ql] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.l0 == null || this.ql == this.l0.length) {
            if (this.l0 == null) {
                this.l0 = new Object[16];
            }
            this.l0 = Arrays.copyOf(this.l0, this.ql == 0 ? 16 : 2 * this.ql);
        }
        ++this.r2;
        this.l0[this.ql++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.ql) {
            this.copyTo(ic.l0(array), 0);
            return array;
        }
        ic ic2 = ic.l0(com.aspose.slides.internal.in.r2.l0(array.getClass().getComponentType()), this.ql);
        this.copyTo(ic2, 0);
        return (Object[])ic.l0(ic2);
    }

    public void trimExcess() {
        if (this.l0 != null && (double)this.ql < (double)this.l0.length * 0.9) {
            this.l0 = Arrays.copyOf(this.l0, this.ql);
        }
        ++this.r2;
    }

    @Override
    public int size() {
        return this.ql;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ic dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.l0 != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.ql) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.ql - idx > dest.yx()) {
                    throw new ArgumentException("idx");
                }
                ic.l0(ic.l0(this.l0), 0, dest, idx, this.ql);
                ic.ql(dest, idx, this.ql);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @u1
    public static class Enumerator<T>
    extends el<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> ql;
        private int r2;
        private int ic;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.ql = t;
            this.r2 = -2;
            this.ic = ((Stack)t).r2;
        }

        @Override
        public void dispose() {
            this.r2 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.ic != ((Stack)this.ql).r2) {
                throw new IllegalStateException();
            }
            if (this.r2 == -2) {
                this.r2 = ((Stack)this.ql).ql;
            }
            return this.r2 != -1 && --this.r2 != -1;
        }

        @Override
        public T next() {
            if (this.r2 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.ql).l0[this.r2];
        }

        @Override
        public void reset() {
            if (this.ic != ((Stack)this.ql).r2) {
                throw new IllegalStateException();
            }
            this.r2 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.ql = this.ql;
            that.r2 = this.r2;
            that.ic = this.ic;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean l0(Enumerator enumerator) {
            return qu.l0(enumerator.ql, this.ql) && enumerator.r2 == this.r2 && enumerator.ic == this.ic;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.l0((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.ql != null ? this.ql.hashCode() : 0;
            n = 31 * n + this.r2;
            n = 31 * n + this.ic;
            return n;
        }
    }
}

