/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.u1;

@u1
public final class BitArray
implements ICollection,
g0 {
    private int[] l0;
    private int ql;
    private int r2 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.ql = bits.ql;
        this.l0 = new int[(this.ql + 31) / 32];
        if (this.l0.length == 1) {
            this.l0[0] = bits.l0[0];
        } else {
            ic.l0(bits.l0, 0, this.l0, 0, this.l0.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.ql = values.length;
        this.l0 = new int[(this.ql + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.ql = bytes.length * 8;
        this.l0 = new int[(this.ql + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.l0(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.ql = n * 32;
        this.l0 = new int[n];
        ic.l0(values, 0, this.l0, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.ql = length;
        this.l0 = new int[(this.ql + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.l0.length; ++i) {
                this.l0[i] = -1;
            }
        }
    }

    private byte l0(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.l0[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void l0(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.l0[n12] = this.l0[n12] & ~(255 << n11);
        int n13 = n10;
        this.l0[n13] = this.l0[n13] | (by2 & 0xFF) << n11;
        ++this.r2;
    }

    private void ql(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.ql != this.ql) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.ql;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.ql;
    }

    public void setLength(int value) {
        if (this.ql == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.ql) {
            int n = (value + 31) / 32;
            int n10 = (this.ql + 31) / 32;
            if (n > this.l0.length) {
                int[] nArray = new int[n];
                ic.l0(this.l0, 0, nArray, 0, this.l0.length);
                this.l0 = nArray;
            } else {
                ic.l0(ic.l0((Object)this.l0), n10, n - n10);
            }
            int n11 = this.ql % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.l0[n12] = this.l0[n12] & (1 << n11) - 1;
            }
        }
        this.ql = value;
        ++this.r2;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(ic array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ic() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.yx() && this.ql > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = ic.l0(array);
        if (object instanceof Boolean[]) {
            if (array.yx() - index < this.ql) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.ql; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.yx() - index < this.ql) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.ql; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.ql + 7) / 8;
            if (array.yx() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.l0(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.ql + 7) / 8;
            if (array.yx() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.l0(i);
            }
        } else if (object instanceof Integer[]) {
            ic.l0(ic.l0((Object)this.l0), 0, array, index, (this.ql + 31) / 32);
        } else if (object instanceof int[]) {
            ic.l0(ic.l0((Object)this.l0), 0, array, index, (this.ql + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.ql + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.l0[i] = ~this.l0[i];
        }
        ++this.r2;
        return this;
    }

    public BitArray and(BitArray value) {
        this.ql(value);
        int n = (this.ql + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.l0[n10] = this.l0[n10] & value.l0[i];
        }
        ++this.r2;
        return this;
    }

    public BitArray or(BitArray value) {
        this.ql(value);
        int n = (this.ql + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.l0[n10] = this.l0[n10] | value.l0[i];
        }
        ++this.r2;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.ql(value);
        int n = (this.ql + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.l0[n10] = this.l0[n10] ^ value.l0[i];
        }
        ++this.r2;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.ql) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.l0[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.ql) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.l0[n] = this.l0[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.l0[n] = this.l0[n] & ~(1 << (index & 0x1F));
        }
        ++this.r2;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.l0.length; ++i) {
                this.l0[i] = -1;
            }
        } else {
            ic.l0(ic.l0((Object)this.l0), 0, this.l0.length);
        }
        ++this.r2;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @u1
    private static class BitArrayEnumerator
    implements IEnumerator,
    g0,
    Cloneable {
        private BitArray l0;
        private boolean ql;
        private int r2;
        private int ic;

        @Override
        public Object deepClone() {
            return this.l0();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.r2 = -1;
            this.l0 = ba2;
            this.ic = ba2.r2;
        }

        @Override
        public Object next() {
            if (this.r2 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.r2 >= this.l0.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.ql;
        }

        @Override
        public boolean hasNext() {
            this.ql();
            if (this.r2 < this.l0.size() - 1) {
                this.ql = this.l0.get_Item(++this.r2);
                return true;
            }
            this.r2 = this.l0.size();
            return false;
        }

        @Override
        public void reset() {
            this.ql();
            this.r2 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void ql() {
            if (this.ic != this.l0.r2) {
                throw new InvalidOperationException();
            }
        }

        protected Object l0() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.l0 = this.l0;
            bitArrayEnumerator.ql = this.ql;
            bitArrayEnumerator.r2 = this.r2;
            bitArrayEnumerator.ic = this.ic;
            return bitArrayEnumerator;
        }
    }
}

