/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.xmp.types.derived;

import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.bG.aW;
import com.aspose.psd.xmp.types.XmpTypeBase;

public class Rational
extends XmpTypeBase {
    private int a;
    private int b;

    public Rational(int numerator, int denominator) {
        if (numerator <= 0) {
            throw new ArgumentOutOfRangeException("numerator", "Numberator should be grater zero.");
        }
        if (denominator <= 0) {
            throw new ArgumentOutOfRangeException("denominator", "Denominator should be grater zero.");
        }
        this.a = numerator;
        this.b = denominator;
    }

    public int getNumerator() {
        return this.a;
    }

    public int getDenominator() {
        return this.b;
    }

    public void setDenominator(int value) {
        this.b = value;
    }

    public float getFloatValue() {
        return (float)this.a / (float)this.b;
    }

    @Override
    public String getXmpRepresentation() {
        return aW.a("{0}/{1}", new Object[]{this.a, this.b});
    }
}

