/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.system.Threading;

import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.Exceptions.InvalidOperationException;
import com.aspose.psd.internal.bG.aq;
import com.aspose.psd.internal.bG.ax;
import com.aspose.psd.internal.bG.ba;
import com.aspose.psd.internal.cg.f;
import com.aspose.psd.system.Threading.EventWaitHandle;
import com.aspose.psd.system.Threading.ThreadInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class WaitHandle
implements aq {
    protected final Object syncObj = new Object();
    protected boolean isReady = false;
    protected int eventResetMode = 0;
    private CountDownLatch a = new CountDownLatch(1);
    protected static final ax InvalidHandle = new ax(-1L);
    private ax b;
    public static final int WaitTimeout = 258;
    private boolean c = false;

    protected WaitHandle() {
    }

    CountDownLatch getCountDownLatch() {
        return this.a;
    }

    void setCountDownLatch(CountDownLatch latch) {
        this.a = latch;
    }

    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.c = true;
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn) {
        return WaitHandle.signalAndWait(toSignal, toWaitOn, -1, false);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, ba timeout, boolean exitContext) {
        long l2 = (long)timeout.i();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.signalAndWait(toSignal, toWaitOn, (int)l2, exitContext);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, int timeout, boolean exitContext) {
        if (toSignal == null) {
            throw new ArgumentNullException("toSignal");
        }
        if (toWaitOn == null) {
            throw new ArgumentNullException("toWaitOn");
        }
        if (-1 > timeout) {
            throw new ArgumentOutOfRangeException("millisecondsTimeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        ((EventWaitHandle)toSignal).set();
        return toWaitOn.waitOne(timeout, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles) {
        return WaitHandle.waitAll(waitHandles, -1, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, ba timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, ba timeout, boolean exitContext) {
        long l2 = (long)timeout.i();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.waitAll(waitHandles, (int)l2, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        boolean bl2;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandles.length; ++i2) {
            if (waitHandles[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(waitHandles.length);
        for (bl2 = false; bl2 < waitHandles.length; bl2 += 1) {
            if (waitHandles[bl2].getCountDownLatch().getCount() == 1L) {
                waitHandles[bl2].setCountDownLatch(countDownLatch);
                continue;
            }
            countDownLatch.countDown();
            waitHandles[bl2].setCountDownLatch(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        boolean bl3 = bl2 = countDownLatch.getCount() == 0L;
        if (bl2) {
            for (int i3 = 0; i3 < waitHandles.length; ++i3) {
                waitHandles[i3].a();
            }
        }
        return bl2;
    }

    @f(b=3, a=1)
    public static int waitAny(WaitHandle[] waitHandles) {
        return WaitHandle.waitAny(waitHandles, -1, true);
    }

    @f(b=3, a=1)
    public static int waitAny(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    @f(b=3, a=1)
    public static int waitAny(WaitHandle[] waitHandles, ba timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    @f(b=3, a=1)
    public static int waitAny(WaitHandle[] waitHandles, ba timeout, boolean exitContext) {
        long l2 = (long)timeout.i();
        return WaitHandle.waitAny(waitHandles, (int)l2, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @f(b=3, a=1)
    public static int waitAny(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        int n2;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i2 = 0; i2 < waitHandles.length; ++i2) {
            if (waitHandles[i2] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        for (n2 = 0; n2 < waitHandles.length; ++n2) {
            if (waitHandles[n2].getCountDownLatch().getCount() == 0L) {
                waitHandles[n2].a();
                return n2;
            }
            waitHandles[n2].setCountDownLatch(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        for (n2 = 0; n2 < waitHandles.length; ++n2) {
            Object object = waitHandles[n2].syncObj;
            synchronized (object) {
                if (waitHandles[n2].isReady) {
                    waitHandles[n2].a();
                    return n2;
                }
                continue;
            }
        }
        return 258;
    }

    public boolean waitOne() {
        return this.waitOne(-1, false);
    }

    public boolean waitOne(int timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(ba timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(ba timeout, boolean exitContext) {
        long l2 = (long)timeout.i();
        if (-1L > l2 || Integer.MAX_VALUE < l2) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return this.waitOne((int)l2, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(int timeout, boolean exitContext) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl2 = false;
            if (!this.isReady) {
                try {
                    if (timeout == -1) {
                        this.syncObj.wait();
                        this.a();
                        return true;
                    }
                    this.syncObj.wait(timeout == 0 ? 1L : (long)timeout);
                    bl2 = this.isReady;
                    this.a();
                    return bl2;
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException.getMessage());
                }
            }
            this.a();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventResetMode == 0 && this.isReady) {
                this.isReady = false;
                this.setCountDownLatch(new CountDownLatch(1));
            }
        }
    }
}

