/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.util;

import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512tDigest;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class Fingerprint {
    private static char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] b;

    public Fingerprint(byte[] byArray) {
        this.b = Fingerprint.calculateFingerprint(byArray);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.b);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 != this.b.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(a[this.b[i2] >>> 4 & 0xF]);
            stringBuffer.append(a[this.b[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)object).b, this.b);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public static byte[] calculateFingerprint(byte[] byArray) {
        SHA512tDigest sHA512tDigest = new SHA512tDigest(160);
        sHA512tDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA512tDigest.getDigestSize()];
        sHA512tDigest.doFinal(byArray2, 0);
        return byArray2;
    }
}

