/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHAKEDigest;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSSigner;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPublicKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest a;
    private XMSSSigner b;
    private SecureRandom c;
    private ASN1ObjectIdentifier d;

    protected XMSSSignatureSpi(String string) {
        super(string);
    }

    protected XMSSSignatureSpi(String string, Digest digest, XMSSSigner xMSSSigner) {
        super(string);
        this.a = digest;
        this.b = xMSSSigner;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCXMSSPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSS");
        }
        CipherParameters cipherParameters = ((BCXMSSPublicKey)publicKey).getKeyParams();
        this.d = null;
        this.a.reset();
        this.b.init(false, cipherParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.c = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters;
        if (privateKey instanceof BCXMSSPrivateKey) {
            cipherParameters = ((BCXMSSPrivateKey)privateKey).getKeyParams();
            this.d = ((BCXMSSPrivateKey)privateKey).getTreeDigestOID();
            if (this.c != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, this.c);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to XMSS");
        }
        this.a.reset();
        this.b.init(true, cipherParameters);
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.a.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.a.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a);
        try {
            byte[] byArray2 = this.b.generateSignature(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage());
            }
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.a);
        return this.b.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public PrivateKey getUpdatedPrivateKey() {
        if (this.d == null) {
            throw new IllegalStateException("signature object not in a signing state");
        }
        BCXMSSPrivateKey bCXMSSPrivateKey = new BCXMSSPrivateKey(this.d, (XMSSPrivateKeyParameters)this.b.getUpdatedPrivateKey());
        this.d = null;
        return bCXMSSPrivateKey;
    }

    public static class withSha256
    extends XMSSSignatureSpi {
        public withSha256() {
            super("SHA256withXMSS", new SHA256Digest(), new XMSSSigner());
        }
    }

    public static class withSha512
    extends XMSSSignatureSpi {
        public withSha512() {
            super("SHA512withXMSS", new SHA512Digest(), new XMSSSigner());
        }
    }

    public static class withShake128
    extends XMSSSignatureSpi {
        public withShake128() {
            super("SHAKE128withXMSSMT", new SHAKEDigest(128), new XMSSSigner());
        }
    }

    public static class withShake256
    extends XMSSSignatureSpi {
        public withShake256() {
            super("SHAKE256withXMSS", new SHAKEDigest(256), new XMSSSigner());
        }
    }
}

