/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.newhope;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Pack;
import java.io.IOException;

public class BCNHPrivateKey
implements NHPrivateKey {
    private static final long a = 1L;
    private final NHPrivateKeyParameters b;

    public BCNHPrivateKey(NHPrivateKeyParameters nHPrivateKeyParameters) {
        this.b = nHPrivateKeyParameters;
    }

    public BCNHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.b = new NHPrivateKeyParameters(BCNHPrivateKey.a(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets()));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey bCNHPrivateKey = (BCNHPrivateKey)object;
        return Arrays.areEqual(this.b.getSecData(), bCNHPrivateKey.b.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.b.getSecData());
    }

    @Override
    public final String getAlgorithm() {
        return "NH";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = this.b.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i2 = 0; i2 != sArray.length; ++i2) {
                Pack.shortToLittleEndian(sArray[i2], byArray, i2 * 2);
            }
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public short[] getSecretData() {
        return this.b.getSecData();
    }

    CipherParameters getKeyParams() {
        return this.b;
    }

    private static short[] a(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i2 = 0; i2 != sArray.length; ++i2) {
            sArray[i2] = Pack.littleEndianToShort(byArray, i2 * 2);
        }
        return sArray;
    }
}

