/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.gmss;

import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.GMSSPublicKey;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.pqc.asn1.ParSet;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.security.PublicKey;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long a = 1L;
    private byte[] b;
    private GMSSParameters c;
    private GMSSParameters d;

    public BCGMSSPublicKey(byte[] byArray, GMSSParameters gMSSParameters) {
        this.c = gMSSParameters;
        this.b = byArray;
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters gMSSPublicKeyParameters) {
        this(gMSSPublicKeyParameters.getPublicKey(), gMSSPublicKeyParameters.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.b;
    }

    public GMSSParameters getParameterSet() {
        return this.c;
    }

    public String toString() {
        String string = "GMSS public key : " + new String(Hex.encode(this.b)) + "\nHeight of Trees: \n";
        for (int i2 = 0; i2 < this.c.getHeightOfTrees().length; ++i2) {
            string = string + "Layer " + i2 + " : " + this.c.getHeightOfTrees()[i2] + " WinternitzParameter: " + this.c.getWinternitzParameter()[i2] + " K: " + this.c.getK()[i2] + "\n";
        }
        return string;
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, new ParSet(this.c.getNumOfLayers(), this.c.getHeightOfTrees(), this.c.getWinternitzParameter(), this.c.getK()).toASN1Primitive()), new GMSSPublicKey(this.b));
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

