/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss;

import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.aspose.psd.internal.bouncycastle.util.Integers;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.util.Vector;

public class Treehash {
    private int a;
    private Vector b;
    private Vector c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private int h;
    private boolean i;
    private boolean j;
    private boolean k;
    private Digest l;

    public Treehash(Digest digest, byte[][] byArray, int[] nArray) {
        int n2;
        this.l = digest;
        this.a = nArray[0];
        this.g = nArray[1];
        this.h = nArray[2];
        this.j = nArray[3] == 1;
        this.i = nArray[4] == 1;
        this.k = nArray[5] == 1;
        this.c = new Vector();
        for (n2 = 0; n2 < this.g; ++n2) {
            this.c.addElement(Integers.valueOf(nArray[6 + n2]));
        }
        this.d = byArray[0];
        this.e = byArray[1];
        this.f = byArray[2];
        this.b = new Vector();
        for (n2 = 0; n2 < this.g; ++n2) {
            this.b.addElement(byArray[3 + n2]);
        }
    }

    public Treehash(Vector vector, int n2, Digest digest) {
        this.b = vector;
        this.a = n2;
        this.d = null;
        this.i = false;
        this.j = false;
        this.k = false;
        this.l = digest;
        this.f = new byte[this.l.getDigestSize()];
        this.e = new byte[this.l.getDigestSize()];
    }

    public void initializeSeed(byte[] byArray) {
        System.arraycopy(byArray, 0, this.f, 0, this.l.getDigestSize());
        this.k = true;
    }

    public void initialize() {
        if (!this.k) {
            System.err.println("Seed " + this.a + " not initialized");
            return;
        }
        this.c = new Vector();
        this.g = 0;
        this.d = null;
        this.h = -1;
        this.i = true;
        System.arraycopy(this.f, 0, this.e, 0, this.l.getDigestSize());
    }

    public void update(GMSSRandom gMSSRandom, byte[] byArray) {
        if (this.j) {
            System.err.println("No more update possible for treehash instance!");
            return;
        }
        if (!this.i) {
            System.err.println("Treehash instance not initialized before update");
            return;
        }
        byte[] byArray2 = new byte[this.l.getDigestSize()];
        int n2 = -1;
        gMSSRandom.nextSeed(this.e);
        if (this.d == null) {
            this.d = byArray;
            this.h = 0;
        } else {
            byte[] byArray3;
            byArray2 = byArray;
            n2 = 0;
            while (this.g > 0 && n2 == (Integer)this.c.lastElement()) {
                byArray3 = new byte[this.l.getDigestSize() << 1];
                System.arraycopy(this.b.lastElement(), 0, byArray3, 0, this.l.getDigestSize());
                this.b.removeElementAt(this.b.size() - 1);
                this.c.removeElementAt(this.c.size() - 1);
                System.arraycopy(byArray2, 0, byArray3, this.l.getDigestSize(), this.l.getDigestSize());
                this.l.update(byArray3, 0, byArray3.length);
                byArray2 = new byte[this.l.getDigestSize()];
                this.l.doFinal(byArray2, 0);
                ++n2;
                --this.g;
            }
            this.b.addElement(byArray2);
            this.c.addElement(Integers.valueOf(n2));
            ++this.g;
            if ((Integer)this.c.lastElement() == this.h) {
                byArray3 = new byte[this.l.getDigestSize() << 1];
                System.arraycopy(this.d, 0, byArray3, 0, this.l.getDigestSize());
                System.arraycopy(this.b.lastElement(), 0, byArray3, this.l.getDigestSize(), this.l.getDigestSize());
                this.b.removeElementAt(this.b.size() - 1);
                this.c.removeElementAt(this.c.size() - 1);
                this.l.update(byArray3, 0, byArray3.length);
                this.d = new byte[this.l.getDigestSize()];
                this.l.doFinal(this.d, 0);
                ++this.h;
                this.g = 0;
            }
        }
        if (this.h == this.a) {
            this.j = true;
        }
    }

    public void destroy() {
        this.i = false;
        this.j = false;
        this.d = null;
        this.g = 0;
        this.h = -1;
    }

    public int getLowestNodeHeight() {
        if (this.d == null) {
            return this.a;
        }
        if (this.g == 0) {
            return this.h;
        }
        return Math.min(this.h, (Integer)this.c.lastElement());
    }

    public int getFirstNodeHeight() {
        if (this.d == null) {
            return this.a;
        }
        return this.h;
    }

    public boolean wasInitialized() {
        return this.i;
    }

    public boolean wasFinished() {
        return this.j;
    }

    public byte[] getFirstNode() {
        return this.d;
    }

    public byte[] getSeedActive() {
        return this.e;
    }

    public void setFirstNode(byte[] byArray) {
        if (!this.i) {
            this.initialize();
        }
        this.d = byArray;
        this.h = this.a;
        this.j = true;
    }

    public void updateNextSeed(GMSSRandom gMSSRandom) {
        gMSSRandom.nextSeed(this.f);
    }

    public Vector getTailStack() {
        return this.b;
    }

    public byte[][] getStatByte() {
        byte[][] byArray = new byte[3 + this.g][this.l.getDigestSize()];
        byArray[0] = this.d;
        byArray[1] = this.e;
        byArray[2] = this.f;
        for (int i2 = 0; i2 < this.g; ++i2) {
            byArray[3 + i2] = (byte[])this.b.elementAt(i2);
        }
        return byArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[6 + this.g];
        nArray[0] = this.a;
        nArray[1] = this.g;
        nArray[2] = this.h;
        nArray[3] = this.j ? 1 : 0;
        nArray[4] = this.i ? 1 : 0;
        nArray[5] = this.k ? 1 : 0;
        for (int i2 = 0; i2 < this.g; ++i2) {
            nArray[6 + i2] = (Integer)this.c.elementAt(i2);
        }
        return nArray;
    }

    public String toString() {
        int n2;
        String string = "Treehash    : ";
        for (n2 = 0; n2 < 6 + this.g; ++n2) {
            string = string + this.getStatInt()[n2] + " ";
        }
        for (n2 = 0; n2 < 3 + this.g; ++n2) {
            string = this.getStatByte()[n2] != null ? string + new String(Hex.encode(this.getStatByte()[n2])) + " " : string + "null ";
        }
        string = string + "  " + this.l.getDigestSize();
        return string;
    }
}

