/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss;

import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;

public class GMSSLeaf {
    private Digest a;
    private int b;
    private int c;
    private GMSSRandom d;
    private byte[] e;
    private byte[] f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private byte[] l;
    byte[] privateKeyOTS;

    public GMSSLeaf(Digest digest, byte[][] byArray, int[] nArray) {
        this.g = nArray[0];
        this.h = nArray[1];
        this.k = nArray[2];
        this.j = nArray[3];
        this.a = digest;
        this.d = new GMSSRandom(this.a);
        this.b = this.a.getDigestSize();
        int n2 = this.b << 3;
        int n3 = (int)Math.ceil((double)n2 / (double)this.j);
        int n4 = this.a((n3 << this.j) + 1);
        this.c = n3 + (int)Math.ceil((double)n4 / (double)this.j);
        this.i = 1 << this.j;
        this.privateKeyOTS = byArray[0];
        this.l = byArray[1];
        this.f = byArray[2];
        this.e = byArray[3];
    }

    GMSSLeaf(Digest digest, int n2, int n3) {
        this.j = n2;
        this.a = digest;
        this.d = new GMSSRandom(this.a);
        this.b = this.a.getDigestSize();
        int n4 = this.b << 3;
        int n5 = (int)Math.ceil((double)n4 / (double)n2);
        int n6 = this.a((n5 << n2) + 1);
        this.c = n5 + (int)Math.ceil((double)n6 / (double)n2);
        this.i = 1 << n2;
        this.k = (int)Math.ceil((double)(((1 << n2) - 1) * this.c + 1 + this.c) / (double)n3);
        this.l = new byte[this.b];
        this.e = new byte[this.b];
        this.privateKeyOTS = new byte[this.b];
        this.f = new byte[this.b * this.c];
    }

    public GMSSLeaf(Digest digest, int n2, int n3, byte[] byArray) {
        this.j = n2;
        this.a = digest;
        this.d = new GMSSRandom(this.a);
        this.b = this.a.getDigestSize();
        int n4 = this.b << 3;
        int n5 = (int)Math.ceil((double)n4 / (double)n2);
        int n6 = this.a((n5 << n2) + 1);
        this.c = n5 + (int)Math.ceil((double)n6 / (double)n2);
        this.i = 1 << n2;
        this.k = (int)Math.ceil((double)(((1 << n2) - 1) * this.c + 1 + this.c) / (double)n3);
        this.l = new byte[this.b];
        this.e = new byte[this.b];
        this.privateKeyOTS = new byte[this.b];
        this.f = new byte[this.b * this.c];
        this.initLeafCalc(byArray);
    }

    private GMSSLeaf(GMSSLeaf gMSSLeaf) {
        this.a = gMSSLeaf.a;
        this.b = gMSSLeaf.b;
        this.c = gMSSLeaf.c;
        this.d = gMSSLeaf.d;
        this.e = Arrays.clone(gMSSLeaf.e);
        this.f = Arrays.clone(gMSSLeaf.f);
        this.g = gMSSLeaf.g;
        this.h = gMSSLeaf.h;
        this.i = gMSSLeaf.i;
        this.j = gMSSLeaf.j;
        this.k = gMSSLeaf.k;
        this.l = Arrays.clone(gMSSLeaf.l);
        this.privateKeyOTS = Arrays.clone(gMSSLeaf.privateKeyOTS);
    }

    void initLeafCalc(byte[] byArray) {
        this.g = 0;
        this.h = 0;
        byte[] byArray2 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray2, 0, this.l.length);
        this.l = this.d.nextSeed(byArray2);
    }

    GMSSLeaf nextLeaf() {
        GMSSLeaf gMSSLeaf = new GMSSLeaf(this);
        gMSSLeaf.a();
        return gMSSLeaf;
    }

    private void a() {
        byte[] byArray = new byte[this.a.getDigestSize()];
        for (int i2 = 0; i2 < this.k + 10000; ++i2) {
            if (this.g == this.c && this.h == this.i - 1) {
                this.a.update(this.f, 0, this.f.length);
                this.e = new byte[this.a.getDigestSize()];
                this.a.doFinal(this.e, 0);
                return;
            }
            if (this.g == 0 || this.h == this.i - 1) {
                ++this.g;
                this.h = 0;
                this.privateKeyOTS = this.d.nextSeed(this.l);
                continue;
            }
            this.a.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
            this.privateKeyOTS = byArray;
            this.a.doFinal(this.privateKeyOTS, 0);
            ++this.h;
            if (this.h != this.i - 1) continue;
            System.arraycopy(this.privateKeyOTS, 0, this.f, this.b * (this.g - 1), this.b);
        }
        throw new IllegalStateException("unable to updateLeaf in steps: " + this.k + " " + this.g + " " + this.h);
    }

    public byte[] getLeaf() {
        return Arrays.clone(this.e);
    }

    private int a(int n2) {
        int n3 = 1;
        int n4 = 2;
        while (n4 < n2) {
            n4 <<= 1;
            ++n3;
        }
        return n3;
    }

    public byte[][] getStatByte() {
        byte[][] byArrayArray = new byte[][]{new byte[this.b], new byte[this.b], new byte[this.b * this.c], new byte[this.b]};
        byArrayArray[0] = this.privateKeyOTS;
        byArrayArray[1] = this.l;
        byArrayArray[2] = this.f;
        byArrayArray[3] = this.e;
        return byArrayArray;
    }

    public int[] getStatInt() {
        int[] nArray = new int[]{this.g, this.h, this.k, this.j};
        return nArray;
    }

    public String toString() {
        String string = "";
        for (int i2 = 0; i2 < 4; ++i2) {
            string = string + this.getStatInt()[i2] + " ";
        }
        string = string + " " + this.b + " " + this.c + " " + this.i + " ";
        byte[][] byArray = this.getStatByte();
        for (int i3 = 0; i3 < 4; ++i3) {
            string = byArray[i3] != null ? string + new String(Hex.encode(byArray[i3])) + " " : string + "null ";
        }
        return string;
    }
}

