/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.operator.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.cms.GenericHybridParameters;
import com.aspose.psd.internal.bouncycastle.asn1.cms.RsaKemParameters;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.crypto.util.DEROtherInfo;
import com.aspose.psd.internal.bouncycastle.jcajce.spec.KTSParameterSpec;
import com.aspose.psd.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.operator.AsymmetricKeyUnwrapper;
import com.aspose.psd.internal.bouncycastle.operator.GenericKey;
import com.aspose.psd.internal.bouncycastle.operator.OperatorException;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.JceGenericKey;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.h;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class JceKTSKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private h a = new h(new DefaultJcaJceHelper());
    private Map b = new HashMap();
    private PrivateKey c;
    private byte[] d;
    private byte[] e;

    public JceKTSKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey, byte[] byArray, byte[] byArray2) {
        super(algorithmIdentifier);
        this.c = privateKey;
        this.d = Arrays.clone(byArray);
        this.e = Arrays.clone(byArray2);
    }

    public JceKTSKeyUnwrapper setProvider(Provider provider) {
        this.a = new h(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyUnwrapper setProvider(String string) {
        this.a = new h(new NamedJcaJceHelper(string));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        Key key;
        GenericHybridParameters genericHybridParameters = GenericHybridParameters.getInstance(this.getAlgorithmIdentifier().getParameters());
        Cipher cipher = this.a.a(this.getAlgorithmIdentifier().getAlgorithm(), this.b);
        String string = this.a.a(genericHybridParameters.getDem().getAlgorithm());
        RsaKemParameters rsaKemParameters = RsaKemParameters.getInstance(genericHybridParameters.getKem().getParameters());
        int n2 = rsaKemParameters.getKeyLength().intValue() * 8;
        try {
            DEROtherInfo dEROtherInfo = new DEROtherInfo.Builder(genericHybridParameters.getDem(), this.d, this.e).build();
            KTSParameterSpec kTSParameterSpec = new KTSParameterSpec.Builder(string, n2, dEROtherInfo.getEncoded()).withKdfAlgorithm(rsaKemParameters.getKeyDerivationFunction()).build();
            cipher.init(4, (Key)this.c, kTSParameterSpec);
            key = cipher.unwrap(byArray, this.a.d(algorithmIdentifier.getAlgorithm()), 3);
        }
        catch (Exception exception) {
            throw new OperatorException("Unable to unwrap contents key: " + exception.getMessage(), exception);
        }
        return new JceGenericKey(algorithmIdentifier, key);
    }
}

