/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.B;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecT409FieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecT409R1Point;
import com.aspose.psd.internal.bouncycastle.math.raw.Nat448;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT409R1Curve
extends ECCurve.AbstractF2m {
    private static final int c = 6;
    protected SecT409R1Point infinity = new SecT409R1Point(this, null, null);

    public SecT409R1Curve() {
        super(409, 87, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("0021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545F")));
        this.order = new BigInteger(1, Hex.decode("010000000000000000000000000000000000000000000000000001E2AAD6A612F33307BE5FA47C3C9E052F838164CD37D9A21173"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT409R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT409FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT409R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT409R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 409;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        long[] lArray = new long[n3 * 7 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 7);
            n4 += 7;
        }
        return new B(this, n3, lArray);
    }
}

