/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jce.spec;

import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.psd.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.field.FiniteField;
import com.aspose.psd.internal.bouncycastle.math.field.Polynomial;
import com.aspose.psd.internal.bouncycastle.math.field.PolynomialExtensionField;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String a;

    private static EllipticCurve a(ECCurve eCCurve, byte[] byArray) {
        ECField eCField = ECNamedCurveSpec.a(eCCurve.getField());
        BigInteger bigInteger = eCCurve.getA().toBigInteger();
        BigInteger bigInteger2 = eCCurve.getB().toBigInteger();
        return new EllipticCurve(eCField, bigInteger, bigInteger2, byArray);
    }

    private static ECField a(FiniteField finiteField) {
        if (ECAlgorithms.isFpField(finiteField)) {
            return new ECFieldFp(finiteField.getCharacteristic());
        }
        Polynomial polynomial = ((PolynomialExtensionField)finiteField).getMinimalPolynomial();
        int[] nArray = polynomial.getExponentsPresent();
        int[] nArray2 = Arrays.reverse(Arrays.copyOfRange(nArray, 1, nArray.length - 1));
        return new ECFieldF2m(polynomial.getDegree(), nArray2);
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        super(ECNamedCurveSpec.a(eCCurve, null), EC5Util.convertPoint(eCPoint), bigInteger, 1);
        this.a = string;
    }

    public ECNamedCurveSpec(String string, EllipticCurve ellipticCurve, java.security.spec.ECPoint eCPoint, BigInteger bigInteger) {
        super(ellipticCurve, eCPoint, bigInteger, 1);
        this.a = string;
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        super(ECNamedCurveSpec.a(eCCurve, null), EC5Util.convertPoint(eCPoint), bigInteger, bigInteger2.intValue());
        this.a = string;
    }

    public ECNamedCurveSpec(String string, EllipticCurve ellipticCurve, java.security.spec.ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        super(ellipticCurve, eCPoint, bigInteger, bigInteger2.intValue());
        this.a = string;
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        super(ECNamedCurveSpec.a(eCCurve, byArray), EC5Util.convertPoint(eCPoint), bigInteger, bigInteger2.intValue());
        this.a = string;
    }

    public String getName() {
        return this.a;
    }
}

