/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric;

import com.aspose.psd.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.engines.BlowfishEngine;
import com.aspose.psd.internal.bouncycastle.crypto.macs.CMac;
import com.aspose.psd.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Blowfish {
    private Blowfish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Blowfish IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new BlowfishEngine()), 64);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new BlowfishEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlowfishEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Blowfish", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String a = Blowfish.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Mac.BLOWFISHCMAC", a + "$CMAC");
            configurableProvider.addAlgorithm("Cipher.BLOWFISH", a + "$ECB");
            configurableProvider.addAlgorithm("Cipher", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, a + "$CBC");
            configurableProvider.addAlgorithm("KeyGenerator.BLOWFISH", a + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
            configurableProvider.addAlgorithm("AlgorithmParameters.BLOWFISH", a + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters", MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "BLOWFISH");
        }
    }
}

