/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.keystore.bcfks;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import com.aspose.psd.internal.bouncycastle.asn1.bc.EncryptedPrivateKeyData;
import com.aspose.psd.internal.bouncycastle.asn1.bc.EncryptedSecretKeyData;
import com.aspose.psd.internal.bouncycastle.asn1.bc.ObjectData;
import com.aspose.psd.internal.bouncycastle.asn1.bc.ObjectDataSequence;
import com.aspose.psd.internal.bouncycastle.asn1.bc.ObjectStore;
import com.aspose.psd.internal.bouncycastle.asn1.bc.ObjectStoreData;
import com.aspose.psd.internal.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;
import com.aspose.psd.internal.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import com.aspose.psd.internal.bouncycastle.asn1.bc.SecretKeyData;
import com.aspose.psd.internal.bouncycastle.asn1.cms.CCMParameters;
import com.aspose.psd.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.misc.ScryptParams;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA3Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.psd.internal.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.generators.SCrypt;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.util.PBKDF2Config;
import com.aspose.psd.internal.bouncycastle.crypto.util.PBKDFConfig;
import com.aspose.psd.internal.bouncycastle.crypto.util.ScryptConfig;
import com.aspose.psd.internal.bouncycastle.jcajce.BCFKSStoreParameter;
import com.aspose.psd.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class BcFKSKeyStoreSpi
extends KeyStoreSpi {
    private static final Map<String, ASN1ObjectIdentifier> a = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> b = new HashMap<ASN1ObjectIdentifier, String>();
    private static final BigInteger c;
    private static final BigInteger d;
    private static final BigInteger e;
    private static final BigInteger f;
    private static final BigInteger g;
    private final BouncyCastleProvider h;
    private final Map<String, ObjectData> i = new HashMap<String, ObjectData>();
    private final Map<String, PrivateKey> j = new HashMap<String, PrivateKey>();
    private AlgorithmIdentifier k;
    private KeyDerivationFunc l;
    private Date m;
    private Date n;

    private static String a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = b.get(aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return aSN1ObjectIdentifier.getId();
    }

    BcFKSKeyStoreSpi(BouncyCastleProvider bouncyCastleProvider) {
        this.h = bouncyCastleProvider;
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            if (objectData.getType().equals(d) || objectData.getType().equals(f)) {
                PrivateKey privateKey = this.j.get(string);
                if (privateKey != null) {
                    return privateKey;
                }
                EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(encryptedPrivateKeyData.getEncryptedPrivateKeyInfo());
                try {
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(this.a("PRIVATE_KEY_ENCRYPTION", encryptedPrivateKeyInfo.getEncryptionAlgorithm(), cArray, encryptedPrivateKeyInfo.getEncryptedData()));
                    KeyFactory keyFactory = this.h != null ? KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.h) : KeyFactory.getInstance(BcFKSKeyStoreSpi.a(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()));
                    PrivateKey privateKey2 = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
                    this.j.put(string, privateKey2);
                    return privateKey2;
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover private key (" + string + "): " + exception.getMessage());
                }
            }
            if (objectData.getType().equals(e) || objectData.getType().equals(g)) {
                EncryptedSecretKeyData encryptedSecretKeyData = EncryptedSecretKeyData.getInstance(objectData.getData());
                try {
                    SecretKeyData secretKeyData = SecretKeyData.getInstance(this.a("SECRET_KEY_ENCRYPTION", encryptedSecretKeyData.getKeyEncryptionAlgorithm(), cArray, encryptedSecretKeyData.getEncryptedKeyData()));
                    SecretKeyFactory secretKeyFactory = this.h != null ? SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId(), this.h) : SecretKeyFactory.getInstance(secretKeyData.getKeyAlgorithm().getId());
                    return secretKeyFactory.generateSecret(new SecretKeySpec(secretKeyData.getKeyBytes(), secretKeyData.getKeyAlgorithm().getId()));
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): " + exception.getMessage());
                }
            }
            throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + string + "): type not recognized");
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        ObjectData objectData = this.i.get(string);
        if (objectData != null && (objectData.getType().equals(d) || objectData.getType().equals(f))) {
            EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
            com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
            Certificate[] certificateArray2 = new X509Certificate[certificateArray.length];
            for (int i2 = 0; i2 != certificateArray2.length; ++i2) {
                certificateArray2[i2] = this.a(certificateArray[i2]);
            }
            return certificateArray2;
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            if (objectData.getType().equals(d) || objectData.getType().equals(f)) {
                EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate[] certificateArray = encryptedPrivateKeyData.getCertificateChain();
                return this.a(certificateArray[0]);
            }
            if (objectData.getType().equals(c)) {
                return this.a(objectData.getData());
            }
        }
        return null;
    }

    private Certificate a(Object object) {
        if (this.h != null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.h);
                return certificateFactory.generateCertificate(new ByteArrayInputStream(com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate.getInstance(object).getEncoded()));
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream(com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate.getInstance(object).getEncoded()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String string) {
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            try {
                return objectData.getLastModifiedDate().getDate();
            }
            catch (ParseException parseException) {
                return new Date();
            }
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Date date;
        Date date2 = date = new Date();
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            date = this.a(objectData, date);
        }
        this.j.remove(string);
        if (key instanceof PrivateKey) {
            if (certificateArray == null) {
                throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
            }
            try {
                byte[] byArray = key.getEncoded();
                KeyDerivationFunc keyDerivationFunc = this.a(PKCSObjectIdentifiers.id_PBKDF2, 32);
                byte[] byArray2 = this.a(keyDerivationFunc, "PRIVATE_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{});
                Cipher cipher = this.h == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.h);
                cipher.init(1, new SecretKeySpec(byArray2, "AES"));
                byte[] byArray3 = cipher.doFinal(byArray);
                AlgorithmParameters algorithmParameters = cipher.getParameters();
                PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(algorithmParameters.getEncoded())));
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byArray3);
                EncryptedPrivateKeyData encryptedPrivateKeyData = this.a(encryptedPrivateKeyInfo, certificateArray);
                this.i.put(string, new ObjectData(d, string, date, date2, encryptedPrivateKeyData.getEncoded(), null));
            }
            catch (Exception exception) {
                throw new a("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
            }
        } else if (key instanceof SecretKey) {
            if (certificateArray != null) {
                throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
            }
            try {
                Object object;
                byte[] byArray;
                byte[] byArray4 = key.getEncoded();
                KeyDerivationFunc keyDerivationFunc = this.a(PKCSObjectIdentifiers.id_PBKDF2, 32);
                byte[] byArray5 = this.a(keyDerivationFunc, "SECRET_KEY_ENCRYPTION", cArray != null ? cArray : new char[]{});
                Cipher cipher = this.h == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.h);
                cipher.init(1, new SecretKeySpec(byArray5, "AES"));
                String string2 = Strings.toUpperCase(key.getAlgorithm());
                if (string2.indexOf("AES") > -1) {
                    byArray = cipher.doFinal(new SecretKeyData(NISTObjectIdentifiers.aes, byArray4).getEncoded());
                } else {
                    object = a.get(string2);
                    if (object != null) {
                        byArray = cipher.doFinal(new SecretKeyData((ASN1ObjectIdentifier)object, byArray4).getEncoded());
                    } else {
                        throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + string2 + ") for storage.");
                    }
                }
                object = cipher.getParameters();
                PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(((AlgorithmParameters)object).getEncoded())));
                EncryptedSecretKeyData encryptedSecretKeyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), byArray);
                this.i.put(string, new ObjectData(e, string, date, date2, encryptedSecretKeyData.getEncoded(), null));
            }
            catch (Exception exception) {
                throw new a("BCFKS KeyStore exception storing private key: " + exception.toString(), exception);
            }
        } else {
            throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
        }
        this.n = date2;
    }

    private SecureRandom a() {
        return new SecureRandom();
    }

    private EncryptedPrivateKeyData a(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) throws CertificateEncodingException {
        com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate[] certificateArray2 = new com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate[certificateArray.length];
        for (int i2 = 0; i2 != certificateArray.length; ++i2) {
            certificateArray2[i2] = com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate.getInstance(certificateArray[i2].getEncoded());
        }
        return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certificateArray2);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Date date;
        Date date2 = date = new Date();
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            date = this.a(objectData, date);
        }
        if (certificateArray != null) {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            try {
                encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(byArray);
            }
            catch (Exception exception) {
                throw new a("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", exception);
            }
            try {
                this.j.remove(string);
                this.i.put(string, new ObjectData(f, string, date, date2, this.a(encryptedPrivateKeyInfo, certificateArray).getEncoded(), null));
            }
            catch (Exception exception) {
                throw new a("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
            }
        }
        try {
            this.i.put(string, new ObjectData(g, string, date, date2, byArray, null));
        }
        catch (Exception exception) {
            throw new a("BCFKS KeyStore exception storing protected private key: " + exception.toString(), exception);
        }
        this.n = date2;
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Date date;
        ObjectData objectData = this.i.get(string);
        Date date2 = date = new Date();
        if (objectData != null) {
            if (!objectData.getType().equals(c)) {
                throw new KeyStoreException("BCFKS KeyStore already has a key entry with alias " + string);
            }
            date = this.a(objectData, date);
        }
        try {
            this.i.put(string, new ObjectData(c, string, date, date2, certificate.getEncoded(), null));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new a("BCFKS KeyStore unable to handle certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        this.n = date2;
    }

    private Date a(ObjectData objectData, Date date) {
        try {
            date = objectData.getCreationDate().getDate();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        ObjectData objectData = this.i.get(string);
        if (objectData == null) {
            return;
        }
        this.j.remove(string);
        this.i.remove(string);
        this.n = new Date();
    }

    @Override
    public Enumeration<String> engineAliases() {
        Iterator<String> iterator = new HashSet<String>(this.i.keySet()).iterator();
        return new com.aspose.psd.internal.bouncycastle.jcajce.provider.keystore.bcfks.a(this, iterator);
    }

    @Override
    public boolean engineContainsAlias(String string) {
        if (string == null) {
            throw new NullPointerException("alias value is null");
        }
        return this.i.containsKey(string);
    }

    @Override
    public int engineSize() {
        return this.i.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            BigInteger bigInteger = objectData.getType();
            return bigInteger.equals(d) || bigInteger.equals(e) || bigInteger.equals(f) || bigInteger.equals(g);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        ObjectData objectData = this.i.get(string);
        if (objectData != null) {
            return objectData.getType().equals(c);
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        byte[] byArray;
        if (certificate == null) {
            return null;
        }
        try {
            byArray = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        for (String string : this.i.keySet()) {
            ObjectData objectData = this.i.get(string);
            if (objectData.getType().equals(c)) {
                if (!Arrays.areEqual(objectData.getData(), byArray)) continue;
                return string;
            }
            if (!objectData.getType().equals(d) && !objectData.getType().equals(f)) continue;
            try {
                EncryptedPrivateKeyData encryptedPrivateKeyData = EncryptedPrivateKeyData.getInstance(objectData.getData());
                if (!Arrays.areEqual(encryptedPrivateKeyData.getCertificateChain()[0].toASN1Primitive().getEncoded(), byArray)) continue;
                return string;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private byte[] a(KeyDerivationFunc keyDerivationFunc, String string, char[] cArray) throws IOException {
        byte[] byArray = PBEParametersGenerator.PKCS12PasswordToBytes(cArray);
        byte[] byArray2 = PBEParametersGenerator.PKCS12PasswordToBytes(string.toCharArray());
        if (MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) {
            ScryptParams scryptParams = ScryptParams.getInstance(keyDerivationFunc.getParameters());
            return SCrypt.generate(Arrays.concatenate(byArray, byArray2), scryptParams.getSalt(), scryptParams.getCostParameter().intValue(), scryptParams.getBlockSize().intValue(), scryptParams.getBlockSize().intValue(), scryptParams.getKeyLength().intValue());
        }
        if (keyDerivationFunc.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
            if (pBKDF2Params.getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(new SHA512Digest());
                pKCS5S2ParametersGenerator.init(Arrays.concatenate(byArray, byArray2), pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
                int n2 = pBKDF2Params.getKeyLength().intValue();
                return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n2 * 8)).getKey();
            }
            if (pBKDF2Params.getPrf().getAlgorithm().equals(NISTObjectIdentifiers.id_hmacWithSHA3_512)) {
                PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(new SHA3Digest(512));
                pKCS5S2ParametersGenerator.init(Arrays.concatenate(byArray, byArray2), pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
                int n3 = pBKDF2Params.getKeyLength().intValue();
                return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n3 * 8)).getKey();
            }
            throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD PRF: " + pBKDF2Params.getPrf().getAlgorithm());
        }
        throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
    }

    private void a(byte[] byArray, PbkdMacIntegrityCheck pbkdMacIntegrityCheck, char[] cArray) throws NoSuchAlgorithmException, IOException {
        byte[] byArray2 = this.a(byArray, pbkdMacIntegrityCheck.getMacAlgorithm(), pbkdMacIntegrityCheck.getPbkdAlgorithm(), cArray);
        if (!Arrays.constantTimeAreEqual(byArray2, pbkdMacIntegrityCheck.getMac())) {
            throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed.");
        }
    }

    private byte[] a(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, KeyDerivationFunc keyDerivationFunc, char[] cArray) throws NoSuchAlgorithmException, IOException {
        String string = algorithmIdentifier.getAlgorithm().getId();
        Mac mac = this.h != null ? Mac.getInstance(string, this.h) : Mac.getInstance(string);
        try {
            mac.init(new SecretKeySpec(this.a(keyDerivationFunc, "INTEGRITY_CHECK", cArray != null ? cArray : new char[]{}), string));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Cannot set up MAC calculation: " + invalidKeyException.getMessage());
        }
        return mac.doFinal(byArray);
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws CertificateException, NoSuchAlgorithmException, IOException {
        char[] cArray;
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("'parameter' arg cannot be null");
        }
        if (!(loadStoreParameter instanceof BCFKSStoreParameter)) {
            throw new IllegalArgumentException("no support for 'parameter' of type " + loadStoreParameter.getClass().getName());
        }
        BCFKSStoreParameter bCFKSStoreParameter = (BCFKSStoreParameter)loadStoreParameter;
        KeyStore.ProtectionParameter protectionParameter = bCFKSStoreParameter.getProtectionParameter();
        if (protectionParameter == null) {
            cArray = null;
        } else if (protectionParameter instanceof KeyStore.PasswordProtection) {
            cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
        } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
            PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
            try {
                callbackHandler.handle(new Callback[]{passwordCallback});
                cArray = passwordCallback.getPassword();
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new IllegalArgumentException("PasswordCallback not recognised: " + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
            }
        } else {
            throw new IllegalArgumentException("no support for protection parameter of type " + protectionParameter.getClass().getName());
        }
        this.l = bCFKSStoreParameter.getStorePBKDFConfig().getAlgorithm().equals(MiscObjectIdentifiers.id_scrypt) ? this.a(bCFKSStoreParameter.getStorePBKDFConfig(), 64) : this.a(bCFKSStoreParameter.getStorePBKDFConfig(), 64);
        this.engineStore(bCFKSStoreParameter.getOutputStream(), cArray);
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        EncryptedObjectStoreData encryptedObjectStoreData;
        Object object;
        Object object2;
        ObjectData[] objectDataArray = this.i.values().toArray(new ObjectData[this.i.size()]);
        KeyDerivationFunc keyDerivationFunc = this.a(this.l, 32);
        byte[] byArray = this.a(keyDerivationFunc, "STORE_ENCRYPTION", cArray != null ? cArray : new char[]{});
        ObjectStoreData objectStoreData = new ObjectStoreData(this.k, this.m, this.n, new ObjectDataSequence(objectDataArray), null);
        try {
            object2 = this.h == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.h);
            ((Cipher)object2).init(1, new SecretKeySpec(byArray, "AES"));
            object = ((Cipher)object2).doFinal(objectStoreData.getEncoded());
            AlgorithmParameters algorithmParameters = ((Cipher)object2).getParameters();
            PBES2Parameters pBES2Parameters = new PBES2Parameters(keyDerivationFunc, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(algorithmParameters.getEncoded())));
            encryptedObjectStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pBES2Parameters), (byte[])object);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(invalidKeyException.toString());
        }
        if (MiscObjectIdentifiers.id_scrypt.equals(this.l.getAlgorithm())) {
            object2 = ScryptParams.getInstance(this.l.getParameters());
            this.l = this.a(this.l, ((ScryptParams)object2).getKeyLength().intValue());
        } else {
            object2 = PBKDF2Params.getInstance(this.l.getParameters());
            this.l = this.a(this.l, ((PBKDF2Params)object2).getKeyLength().intValue());
        }
        object2 = this.a(encryptedObjectStoreData.getEncoded(), this.k, this.l, cArray);
        object = new ObjectStore(encryptedObjectStoreData, new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(this.k, this.l, (byte[])object2)));
        outputStream.write(((ASN1Object)object).getEncoded());
        outputStream.flush();
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        ObjectStoreData objectStoreData;
        ASN1Object aSN1Object;
        Object object;
        ObjectStore objectStore;
        this.i.clear();
        this.j.clear();
        this.m = null;
        this.n = null;
        this.k = null;
        if (inputStream == null) {
            this.n = this.m = new Date();
            this.k = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
            this.l = this.a(PKCSObjectIdentifiers.id_PBKDF2, 64);
            return;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
        try {
            objectStore = ObjectStore.getInstance(aSN1InputStream.readObject());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        ObjectStoreIntegrityCheck objectStoreIntegrityCheck = objectStore.getIntegrityCheck();
        if (objectStoreIntegrityCheck.getType() != 0) {
            throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
        }
        ASN1Encodable aSN1Encodable = PbkdMacIntegrityCheck.getInstance(objectStoreIntegrityCheck.getIntegrityCheck());
        this.k = aSN1Encodable.getMacAlgorithm();
        this.l = aSN1Encodable.getPbkdAlgorithm();
        this.a(objectStore.getStoreData().toASN1Primitive().getEncoded(), (PbkdMacIntegrityCheck)aSN1Encodable, cArray);
        aSN1Encodable = objectStore.getStoreData();
        if (aSN1Encodable instanceof EncryptedObjectStoreData) {
            object = (EncryptedObjectStoreData)aSN1Encodable;
            aSN1Object = ((EncryptedObjectStoreData)object).getEncryptionAlgorithm();
            objectStoreData = ObjectStoreData.getInstance(this.a("STORE_ENCRYPTION", (AlgorithmIdentifier)aSN1Object, cArray, ((EncryptedObjectStoreData)object).getEncryptedContent().getOctets()));
        } else {
            objectStoreData = ObjectStoreData.getInstance(aSN1Encodable);
        }
        try {
            this.m = objectStoreData.getCreationDate().getDate();
            this.n = objectStoreData.getLastModifiedDate().getDate();
        }
        catch (ParseException parseException) {
            throw new IOException("BCFKS KeyStore unable to parse store data information.");
        }
        if (!objectStoreData.getIntegrityAlgorithm().equals(this.k)) {
            throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
        }
        object = objectStoreData.getObjectDataSequence().iterator();
        while (object.hasNext()) {
            aSN1Object = ObjectData.getInstance(object.next());
            this.i.put(((ObjectData)aSN1Object).getIdentifier(), (ObjectData)aSN1Object);
        }
    }

    private byte[] a(String string, AlgorithmIdentifier algorithmIdentifier, char[] cArray, byte[] byArray) throws IOException {
        if (!algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
            throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
        }
        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
        EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
        if (!encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
            throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
        }
        try {
            AlgorithmParameters algorithmParameters;
            Cipher cipher;
            CCMParameters cCMParameters = CCMParameters.getInstance(encryptionScheme.getParameters());
            if (this.h == null) {
                cipher = Cipher.getInstance("AES/CCM/NoPadding");
                algorithmParameters = AlgorithmParameters.getInstance("CCM");
            } else {
                cipher = Cipher.getInstance("AES/CCM/NoPadding", this.h);
                algorithmParameters = AlgorithmParameters.getInstance("CCM", this.h);
            }
            algorithmParameters.init(cCMParameters.getEncoded());
            byte[] byArray2 = this.a(pBES2Parameters.getKeyDerivationFunc(), string, cArray != null ? cArray : new char[]{});
            cipher.init(2, (Key)new SecretKeySpec(byArray2, "AES"), algorithmParameters);
            byte[] byArray3 = cipher.doFinal(byArray);
            return byArray3;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private KeyDerivationFunc a(PBKDFConfig pBKDFConfig, int n2) {
        if (MiscObjectIdentifiers.id_scrypt.equals(pBKDFConfig.getAlgorithm())) {
            ScryptConfig scryptConfig = (ScryptConfig)pBKDFConfig;
            byte[] byArray = new byte[scryptConfig.getSaltLength()];
            this.a().nextBytes(byArray);
            ScryptParams scryptParams = new ScryptParams(byArray, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter(), n2);
            return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, scryptParams);
        }
        PBKDF2Config pBKDF2Config = (PBKDF2Config)pBKDFConfig;
        byte[] byArray = new byte[pBKDF2Config.getSaltLength()];
        this.a().nextBytes(byArray);
        return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, pBKDF2Config.getIterationCount(), n2, pBKDF2Config.getPRF()));
    }

    private KeyDerivationFunc a(KeyDerivationFunc keyDerivationFunc, int n2) {
        if (MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) {
            ScryptParams scryptParams = ScryptParams.getInstance(keyDerivationFunc.getParameters());
            byte[] byArray = new byte[scryptParams.getSalt().length];
            this.a().nextBytes(byArray);
            ScryptParams scryptParams2 = new ScryptParams(byArray, scryptParams.getCostParameter(), scryptParams.getBlockSize(), scryptParams.getParallelizationParameter(), BigInteger.valueOf(n2));
            return new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, scryptParams2);
        }
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
        byte[] byArray = new byte[pBKDF2Params.getSalt().length];
        this.a().nextBytes(byArray);
        PBKDF2Params pBKDF2Params2 = new PBKDF2Params(byArray, pBKDF2Params.getIterationCount().intValue(), n2, pBKDF2Params.getPrf());
        return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, pBKDF2Params2);
    }

    private KeyDerivationFunc a(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) {
        byte[] byArray = new byte[64];
        this.a().nextBytes(byArray);
        if (PKCSObjectIdentifiers.id_PBKDF2.equals(aSN1ObjectIdentifier)) {
            return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, 51200, n2, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE)));
        }
        throw new IllegalStateException("unknown derivation algorithm: " + aSN1ObjectIdentifier);
    }

    static {
        a.put("DESEDE", OIWObjectIdentifiers.desEDE);
        a.put("TRIPLEDES", OIWObjectIdentifiers.desEDE);
        a.put("TDEA", OIWObjectIdentifiers.desEDE);
        a.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        a.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        a.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        a.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        a.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        b.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        b.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        b.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        b.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        b.put(X9ObjectIdentifiers.id_dsa, "DSA");
        c = BigInteger.valueOf(0L);
        d = BigInteger.valueOf(1L);
        e = BigInteger.valueOf(2L);
        f = BigInteger.valueOf(3L);
        g = BigInteger.valueOf(4L);
    }

    public static class Def
    extends BcFKSKeyStoreSpi {
        public Def() {
            super(null);
        }
    }

    private static class a
    extends KeyStoreException {
        private final Throwable a;

        a(String string, Throwable throwable) {
            super(string);
            this.a = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }

    public static class Std
    extends BcFKSKeyStoreSpi {
        public Std() {
            super(new BouncyCastleProvider());
        }
    }
}

