/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.digest;

import com.aspose.psd.internal.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.digests.DSTU7564Digest;
import com.aspose.psd.internal.bouncycastle.crypto.macs.DSTU7564Mac;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.digest.a;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class DSTU7564 {
    private DSTU7564() {
    }

    public static class Digest256
    extends DigestDSTU7564 {
        public Digest256() {
            super(256);
        }
    }

    public static class Digest384
    extends DigestDSTU7564 {
        public Digest384() {
            super(384);
        }
    }

    public static class Digest512
    extends DigestDSTU7564 {
        public Digest512() {
            super(512);
        }
    }

    public static class DigestDSTU7564
    extends BCMessageDigest
    implements Cloneable {
        public DigestDSTU7564(int n2) {
            super(new DSTU7564Digest(n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest bCMessageDigest = (BCMessageDigest)super.clone();
            bCMessageDigest.digest = new DSTU7564Digest((DSTU7564Digest)this.digest);
            return bCMessageDigest;
        }
    }

    public static class HashMac256
    extends BaseMac {
        public HashMac256() {
            super(new DSTU7564Mac(256));
        }
    }

    public static class HashMac384
    extends BaseMac {
        public HashMac384() {
            super(new DSTU7564Mac(384));
        }
    }

    public static class HashMac512
    extends BaseMac {
        public HashMac512() {
            super(new DSTU7564Mac(512));
        }
    }

    public static class KeyGenerator256
    extends BaseKeyGenerator {
        public KeyGenerator256() {
            super("HMACDSTU7564-256", 256, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator384
    extends BaseKeyGenerator {
        public KeyGenerator384() {
            super("HMACDSTU7564-384", 384, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator512
    extends BaseKeyGenerator {
        public KeyGenerator512() {
            super("HMACDSTU7564-512", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends a {
        private static final String a = DSTU7564.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.DSTU7564-256", a + "$Digest256");
            configurableProvider.addAlgorithm("MessageDigest.DSTU7564-384", a + "$Digest384");
            configurableProvider.addAlgorithm("MessageDigest.DSTU7564-512", a + "$Digest512");
            configurableProvider.addAlgorithm("MessageDigest", UAObjectIdentifiers.dstu7564digest_256, a + "$Digest256");
            configurableProvider.addAlgorithm("MessageDigest", UAObjectIdentifiers.dstu7564digest_384, a + "$Digest384");
            configurableProvider.addAlgorithm("MessageDigest", UAObjectIdentifiers.dstu7564digest_512, a + "$Digest512");
            this.addHMACAlgorithm(configurableProvider, "DSTU7564-256", a + "$HashMac256", a + "$KeyGenerator256");
            this.addHMACAlgorithm(configurableProvider, "DSTU7564-384", a + "$HashMac384", a + "$KeyGenerator384");
            this.addHMACAlgorithm(configurableProvider, "DSTU7564-512", a + "$HashMac512", a + "$KeyGenerator512");
            this.addHMACAlias(configurableProvider, "DSTU7564-256", UAObjectIdentifiers.dstu7564mac_256);
            this.addHMACAlias(configurableProvider, "DSTU7564-384", UAObjectIdentifiers.dstu7564mac_384);
            this.addHMACAlias(configurableProvider, "DSTU7564-512", UAObjectIdentifiers.dstu7564mac_512);
        }
    }
}

