/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec;

import com.aspose.psd.internal.bouncycastle.asn1.x9.X9IntegerConverter;
import com.aspose.psd.internal.bouncycastle.crypto.BasicAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.ECDHCUnifiedAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDHUPrivateParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDHUPublicParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.MQVPrivateParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.MQVPublicParameters;
import com.aspose.psd.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.c;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.psd.internal.bouncycastle.jcajce.spec.DHUParameterSpec;
import com.aspose.psd.internal.bouncycastle.jcajce.spec.MQVParameterSpec;
import com.aspose.psd.internal.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.ECPrivateKey;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.ECPublicKey;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.MQVPrivateKey;
import com.aspose.psd.internal.bouncycastle.jce.interfaces.MQVPublicKey;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter a = new X9IntegerConverter();
    private String b;
    private ECDomainParameters c;
    private Object d;
    private MQVParameterSpec e;
    private DHUParameterSpec f;
    private byte[] g;

    protected KeyAgreementSpi(String string, BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.b = string;
        this.d = basicAgreement;
    }

    protected KeyAgreementSpi(String string, ECDHCUnifiedAgreement eCDHCUnifiedAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.b = string;
        this.d = eCDHCUnifiedAgreement;
    }

    protected byte[] bigIntToBytes(BigInteger bigInteger) {
        return a.integerToBytes(bigInteger, a.getByteLength(this.c.getCurve()));
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        CipherParameters cipherParameters;
        Object object;
        if (this.c == null) {
            throw new IllegalStateException(this.b + " not initialised.");
        }
        if (!bl2) {
            throw new IllegalStateException(this.b + " can only be between two parties.");
        }
        if (this.d instanceof ECMQVBasicAgreement) {
            if (!(key instanceof MQVPublicKey)) {
                object = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a((PublicKey)key);
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(this.e.getOtherPartyEphemeralKey());
                cipherParameters = new MQVPublicParameters((ECPublicKeyParameters)object, eCPublicKeyParameters);
            } else {
                object = (MQVPublicKey)key;
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(object.getStaticKey());
                ECPublicKeyParameters eCPublicKeyParameters2 = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(object.getEphemeralKey());
                cipherParameters = new MQVPublicParameters(eCPublicKeyParameters, eCPublicKeyParameters2);
            }
        } else if (this.d instanceof ECDHCUnifiedAgreement) {
            object = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a((PublicKey)key);
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(this.f.getOtherPartyEphemeralKey());
            cipherParameters = new ECDHUPublicParameters((ECPublicKeyParameters)object, eCPublicKeyParameters);
        } else {
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException(this.b + " key agreement requires " + KeyAgreementSpi.a(ECPublicKey.class) + " for doPhase");
            }
            cipherParameters = com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a((PublicKey)key);
        }
        try {
            this.g = this.d instanceof BasicAgreement ? this.bigIntToBytes(((BasicAgreement)this.d).calculateAgreement(cipherParameters)) : ((ECDHCUnifiedAgreement)this.d).calculateAgreement(cipherParameters);
        }
        catch (Exception exception) {
            throw new c(this, "calculation failed: " + exception.getMessage(), exception);
        }
        return null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec == null || algorithmParameterSpec instanceof MQVParameterSpec || algorithmParameterSpec instanceof UserKeyingMaterialSpec || algorithmParameterSpec instanceof DHUParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.a(key, algorithmParameterSpec);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.a(key, null);
    }

    private void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        if (this.d instanceof ECMQVBasicAgreement) {
            ECPublicKeyParameters eCPublicKeyParameters;
            ECPrivateKeyParameters eCPrivateKeyParameters;
            ECPrivateKeyParameters eCPrivateKeyParameters2;
            Object object;
            this.e = null;
            if (!(key instanceof MQVPrivateKey) && !(algorithmParameterSpec instanceof MQVParameterSpec)) {
                throw new InvalidKeyException(this.b + " key agreement requires " + KeyAgreementSpi.a(MQVParameterSpec.class) + " for initialisation");
            }
            if (key instanceof MQVPrivateKey) {
                object = (MQVPrivateKey)key;
                eCPrivateKeyParameters2 = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(object.getStaticPrivateKey());
                eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(object.getEphemeralPrivateKey());
                eCPublicKeyParameters = null;
                if (object.getEphemeralPublicKey() != null) {
                    eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(object.getEphemeralPublicKey());
                }
            } else {
                object = (MQVParameterSpec)algorithmParameterSpec;
                eCPrivateKeyParameters2 = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
                eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(((MQVParameterSpec)object).getEphemeralPrivateKey());
                eCPublicKeyParameters = null;
                if (((MQVParameterSpec)object).getEphemeralPublicKey() != null) {
                    eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(((MQVParameterSpec)object).getEphemeralPublicKey());
                }
                this.e = object;
                this.ukmParameters = ((MQVParameterSpec)object).getUserKeyingMaterial();
            }
            object = new MQVPrivateParameters(eCPrivateKeyParameters2, eCPrivateKeyParameters, eCPublicKeyParameters);
            this.c = eCPrivateKeyParameters2.getParameters();
            ((ECMQVBasicAgreement)this.d).init((CipherParameters)object);
        } else if (algorithmParameterSpec instanceof DHUParameterSpec) {
            if (!(this.d instanceof ECDHCUnifiedAgreement)) {
                throw new InvalidKeyException(this.b + " key agreement cannot be used with " + KeyAgreementSpi.a(DHUParameterSpec.class));
            }
            DHUParameterSpec dHUParameterSpec = (DHUParameterSpec)algorithmParameterSpec;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
            ECPrivateKeyParameters eCPrivateKeyParameters3 = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(dHUParameterSpec.getEphemeralPrivateKey());
            ECPublicKeyParameters eCPublicKeyParameters = null;
            if (dHUParameterSpec.getEphemeralPublicKey() != null) {
                eCPublicKeyParameters = (ECPublicKeyParameters)com.aspose.psd.internal.bouncycastle.jcajce.provider.asymmetric.ec.a.a(dHUParameterSpec.getEphemeralPublicKey());
            }
            this.f = dHUParameterSpec;
            this.ukmParameters = dHUParameterSpec.getUserKeyingMaterial();
            ECDHUPrivateParameters eCDHUPrivateParameters = new ECDHUPrivateParameters(eCPrivateKeyParameters, eCPrivateKeyParameters3, eCPublicKeyParameters);
            this.c = eCPrivateKeyParameters.getParameters();
            ((ECDHCUnifiedAgreement)this.d).init(eCDHUPrivateParameters);
        } else {
            if (!(key instanceof PrivateKey)) {
                throw new InvalidKeyException(this.b + " key agreement requires " + KeyAgreementSpi.a(ECPrivateKey.class) + " for initialisation");
            }
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
            this.c = eCPrivateKeyParameters.getParameters();
            this.ukmParameters = algorithmParameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial() : null;
            ((BasicAgreement)this.d).init(eCPrivateKeyParameters);
        }
    }

    private static String a(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Override
    protected byte[] calcSecret() {
        return Arrays.clone(this.g);
    }

    public static class CDHwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA1KDFAndSharedInfo() {
            super("ECCDHwithSHA1KDF", new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class CDHwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA224KDFAndSharedInfo() {
            super("ECCDHwithSHA224KDF", new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class CDHwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA256KDFAndSharedInfo() {
            super("ECCDHwithSHA256KDF", new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class CDHwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA384KDFAndSharedInfo() {
            super("ECCDHwithSHA384KDF", new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class CDHwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public CDHwithSHA512KDFAndSharedInfo() {
            super("ECCDHwithSHA512KDF", new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DH
    extends KeyAgreementSpi {
        public DH() {
            super("ECDH", new ECDHBasicAgreement(), null);
        }
    }

    public static class DHC
    extends KeyAgreementSpi {
        public DHC() {
            super("ECDHC", new ECDHCBasicAgreement(), null);
        }
    }

    public static class DHUC
    extends KeyAgreementSpi {
        public DHUC() {
            super("ECCDHU", new ECDHCUnifiedAgreement(), null);
        }
    }

    public static class DHUwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA1CKDF() {
            super("ECCDHUwithSHA1CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHUwithSHA224CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA224CKDF() {
            super("ECCDHUwithSHA224CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHUwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA256CKDF() {
            super("ECCDHUwithSHA256CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHUwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA384CKDF() {
            super("ECCDHUwithSHA384CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHUwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHUwithSHA512CKDF() {
            super("ECCDHUwithSHA512CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHwithSHA1CKDF
    extends KeyAgreementSpi {
        public DHwithSHA1CKDF() {
            super("ECDHwithSHA1CKDF", new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA1KDF
    extends KeyAgreementSpi {
        public DHwithSHA1KDF() {
            super("ECDHwithSHA1KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA1KDFAndSharedInfo() {
            super("ECDHwithSHA1KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA224KDFAndSharedInfo() {
            super("ECDHwithSHA224KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHwithSHA256CKDF
    extends KeyAgreementSpi {
        public DHwithSHA256CKDF() {
            super("ECDHwithSHA256CKDF", new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA256KDFAndSharedInfo() {
            super("ECDHwithSHA256KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHwithSHA384CKDF
    extends KeyAgreementSpi {
        public DHwithSHA384CKDF() {
            super("ECDHwithSHA384CKDF", new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA384KDFAndSharedInfo() {
            super("ECDHwithSHA384KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHwithSHA512CKDF
    extends KeyAgreementSpi {
        public DHwithSHA512CKDF() {
            super("ECDHwithSHA512CKDF", new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA512KDFAndSharedInfo() {
            super("ECDHwithSHA512KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class MQV
    extends KeyAgreementSpi {
        public MQV() {
            super("ECMQV", new ECMQVBasicAgreement(), null);
        }
    }

    public static class MQVwithSHA1CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA1CKDF() {
            super("ECMQVwithSHA1CKDF", new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class MQVwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA1KDFAndSharedInfo() {
            super("ECMQVwithSHA1KDF", new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class MQVwithSHA224CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA224CKDF() {
            super("ECMQVwithSHA224CKDF", new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class MQVwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA224KDFAndSharedInfo() {
            super("ECMQVwithSHA224KDF", new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class MQVwithSHA256CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA256CKDF() {
            super("ECMQVwithSHA256CKDF", new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class MQVwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA256KDFAndSharedInfo() {
            super("ECMQVwithSHA256KDF", new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class MQVwithSHA384CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA384CKDF() {
            super("ECMQVwithSHA384CKDF", new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class MQVwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA384KDFAndSharedInfo() {
            super("ECMQVwithSHA384KDF", new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class MQVwithSHA512CKDF
    extends KeyAgreementSpi {
        public MQVwithSHA512CKDF() {
            super("ECDHUwithSHA512CKDF", new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class MQVwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public MQVwithSHA512KDFAndSharedInfo() {
            super("ECMQVwithSHA512KDF", new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }
}

