/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.tls.Certificate;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CertificateRequest;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CertificateStatus;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CipherSuite;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DigitallySigned;
import com.aspose.psd.internal.bouncycastle.crypto.tls.NewSessionTicket;
import com.aspose.psd.internal.bouncycastle.crypto.tls.ProtocolVersion;
import com.aspose.psd.internal.bouncycastle.crypto.tls.SecurityParameters;
import com.aspose.psd.internal.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsContext;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsCredentials;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsKeyExchange;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsPeer;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsProtocol;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsServer;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsSigner;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.psd.internal.bouncycastle.crypto.tls.a;
import com.aspose.psd.internal.bouncycastle.crypto.tls.s;
import com.aspose.psd.internal.bouncycastle.crypto.util.PublicKeyFactory;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    s tlsServerContext = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected short clientCertificateType = (short)-1;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        super(inputStream, outputStream, secureRandom);
    }

    public TlsServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 0;
        this.tlsServerContext = new s(this.secureRandom, this.securityParameters);
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(tlsServer.shouldUseGMTUnixTime(), this.tlsServerContext.getNonceRandomGenerator());
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.a(this.tlsServerContext);
        this.recordStream.a(false);
        this.blockForHandshake();
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    @Override
    a getContextAdmin() {
        return this.tlsServerContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void handleHandshakeMessage(short var1_1, ByteArrayInputStream var2_2) throws IOException {
        block0 : switch (var1_1) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        this.receiveClientHelloMessage(var2_2);
                        this.connection_state = 1;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.recordStream.g();
                        var3_3 = this.tlsServer.getServerSupplementalData();
                        if (var3_3 != null) {
                            this.sendSupplementalDataMessage(var3_3);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = this.tlsServer.getCredentials();
                        var4_4 = null;
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            var4_4 = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage(var4_4);
                        }
                        this.connection_state = (short)4;
                        if (var4_4 == null || var4_4.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (var5_5 = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage((CertificateStatus)var5_5);
                        }
                        this.connection_state = (short)5;
                        var5_5 = this.keyExchange.generateServerKeyExchange();
                        if (var5_5 != null) {
                            this.sendServerKeyExchangeMessage((byte[])var5_5);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                if (TlsUtils.isTLSv12(this.getContext()) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.keyExchange.validateCertificateRequest(this.certificateRequest);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.recordStream.h(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        this.recordStream.h().sealHashAlgorithms();
                        break block0;
                    }
                    case 16: {
                        this.refuseRenegotiation();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(var2_2));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(var2_2);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest != null) ** GOTO lbl77
                        this.keyExchange.skipClientCredentials();
                        ** GOTO lbl84
lbl77:
                        // 1 sources

                        if (TlsUtils.isTLSv12(this.getContext())) {
                            throw new TlsFatalAlert(10);
                        }
                        if (TlsUtils.isSSL(this.getContext())) {
                            if (this.peerCertificate == null) {
                                throw new TlsFatalAlert(10);
                            }
                        } else {
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
lbl84:
                    // 4 sources

                    case 10: {
                        this.receiveClientKeyExchangeMessage(var2_2);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(var2_2);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(var2_2);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleAlertWarningMessage(short s2) throws IOException {
        super.handleAlertWarningMessage(s2);
        switch (s2) {
            case 41: {
                if (TlsUtils.isSSL(this.getContext()) && this.certificateRequest != null) {
                    switch (this.connection_state) {
                        case 8: {
                            this.tlsServer.processClientSupplementalData(null);
                        }
                        case 9: {
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                            this.connection_state = (short)10;
                            return;
                        }
                    }
                }
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void notifyClientCertificate(Certificate certificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.peerCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.peerCertificate = certificate;
        if (certificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.clientCertificateType = TlsUtils.getClientCertificateType(certificate, this.serverCredentials.getCertificate());
            this.keyExchange.processClientCertificate(certificate);
        }
        this.tlsServer.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(certificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        DigitallySigned digitallySigned = DigitallySigned.parse(this.getContext(), byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        try {
            byte[] byArray;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
            if (TlsUtils.isTLSv12(this.getContext())) {
                TlsUtils.verifySupportedSignatureAlgorithm(this.certificateRequest.getSupportedSignatureAlgorithms(), signatureAndHashAlgorithm);
                byArray = this.prepareFinishHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            } else {
                byArray = this.securityParameters.getSessionHash();
            }
            com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate certificate = this.peerCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(this.clientCertificateType);
            tlsSigner.init(this.getContext());
            if (!tlsSigner.verifyRawSignature(signatureAndHashAlgorithm, digitallySigned.getSignature(), asymmetricKeyParameter, byArray)) {
                throw new TlsFatalAlert(51);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.recordStream.b(protocolVersion);
        if (protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray3.length > 32) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        this.clientExtensions = TlsServerProtocol.readExtensions(byteArrayInputStream);
        this.securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        this.getContextAdmin().a(protocolVersion);
        this.tlsServer.notifyClientVersion(protocolVersion);
        this.tlsServer.notifyFallback(Arrays.contains(this.offeredCipherSuites, 22016));
        this.securityParameters.clientRandom = byArray2;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (Arrays.contains(this.offeredCipherSuites, 255)) {
            this.secure_renegotiation = true;
        }
        if ((byArray = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsServerProtocol.assertEmpty(byteArrayInputStream);
        if (TlsUtils.isSSL(this.getContext())) {
            TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        }
        this.prepareFinishHash = this.recordStream.j();
        this.securityParameters.sessionHash = TlsServerProtocol.getCurrentPRFHash(this.getContext(), this.prepareFinishHash, null);
        if (!TlsUtils.isSSL(this.getContext())) {
            TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        }
        this.recordStream.a(this.getPeer().getCompression(), this.getPeer().getCipher());
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(13);
        certificateRequest.encode(a2);
        a2.a();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(22);
        certificateStatus.encode(a2);
        a2.a();
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.a a2 = new TlsProtocol.a(4);
        newSessionTicket.encode(a2);
        a2.a();
    }

    protected void sendServerHelloMessage() throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(2);
        ProtocolVersion protocolVersion = this.tlsServer.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.recordStream.a(protocolVersion);
        this.recordStream.b(protocolVersion);
        this.recordStream.a(true);
        this.getContextAdmin().b(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, a2);
        a2.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, a2);
        int n2 = this.tlsServer.getSelectedCipherSuite();
        if (!Arrays.contains(this.offeredCipherSuites, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.cipherSuite = n2;
        short s2 = this.tlsServer.getSelectedCompressionMethod();
        if (!Arrays.contains(this.offeredCompressionMethods, s2)) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.compressionAlgorithm = s2;
        TlsUtils.writeUint16(n2, a2);
        TlsUtils.writeUint8(s2, (OutputStream)a2);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean bl2;
            byte[] byArray = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl3 = bl2 = null == byArray;
            if (bl2) {
                this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.securityParameters.extendedMasterSecret) {
            this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        }
        if (this.serverExtensions != null) {
            this.securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            this.securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            this.securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsServerProtocol.writeExtensions(a2, this.serverExtensions);
        }
        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        a2.a();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] byArray = new byte[4];
        TlsUtils.writeUint8((short)14, byArray, 0);
        TlsUtils.writeUint24(0, byArray, 1);
        this.writeHandshakeMessage(byArray, 0, byArray.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] byArray) throws IOException {
        TlsProtocol.a a2 = new TlsProtocol.a(12, byArray.length);
        a2.write(byArray);
        a2.a();
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.clientCertificateType >= 0 && TlsUtils.hasSigningCapability(this.clientCertificateType);
    }
}

