/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.crypto.tls.Certificate;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsProtocol;
import com.aspose.psd.internal.bouncycastle.crypto.tls.n;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class SessionParameters {
    private int a;
    private short b;
    private byte[] c;
    private Certificate d;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g;

    private SessionParameters(int n2, short s2, byte[] byArray, Certificate certificate, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.a = n2;
        this.b = s2;
        this.c = Arrays.clone(byArray);
        this.d = certificate;
        this.e = Arrays.clone(byArray2);
        this.f = Arrays.clone(byArray3);
        this.g = byArray4;
    }

    public void clear() {
        if (this.c != null) {
            Arrays.fill(this.c, (byte)0);
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
    }

    public int getCipherSuite() {
        return this.a;
    }

    public short getCompressionAlgorithm() {
        return this.b;
    }

    public byte[] getMasterSecret() {
        return this.c;
    }

    public Certificate getPeerCertificate() {
        return this.d;
    }

    public byte[] getPskIdentity() {
        return this.e;
    }

    public byte[] getPSKIdentity() {
        return this.e;
    }

    public byte[] getSRPIdentity() {
        return this.f;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.g == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.g);
        return TlsProtocol.readExtensions(byteArrayInputStream);
    }

    /* synthetic */ SessionParameters(int n2, short s2, byte[] byArray, Certificate certificate, byte[] byArray2, byte[] byArray3, byte[] byArray4, n n3) {
        this(n2, s2, byArray, certificate, byArray2, byArray3, byArray4);
    }

    public static final class Builder {
        private int a = -1;
        private short b = (short)-1;
        private byte[] c = null;
        private Certificate d = null;
        private byte[] e = null;
        private byte[] f = null;
        private byte[] g = null;

        public SessionParameters build() {
            this.a(this.a >= 0, "cipherSuite");
            this.a(this.b >= 0, "compressionAlgorithm");
            this.a(this.c != null, "masterSecret");
            return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g, null);
        }

        public Builder setCipherSuite(int n2) {
            this.a = n2;
            return this;
        }

        public Builder setCompressionAlgorithm(short s2) {
            this.b = s2;
            return this;
        }

        public Builder setMasterSecret(byte[] byArray) {
            this.c = byArray;
            return this;
        }

        public Builder setPeerCertificate(Certificate certificate) {
            this.d = certificate;
            return this;
        }

        public Builder setPskIdentity(byte[] byArray) {
            this.e = byArray;
            return this;
        }

        public Builder setPSKIdentity(byte[] byArray) {
            this.e = byArray;
            return this;
        }

        public Builder setSRPIdentity(byte[] byArray) {
            this.f = byArray;
            return this;
        }

        public Builder setServerExtensions(Hashtable hashtable) throws IOException {
            if (hashtable == null) {
                this.g = null;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(byteArrayOutputStream, hashtable);
                this.g = byteArrayOutputStream.toByteArray();
            }
            return this;
        }

        private void a(boolean bl2, String string) {
            if (!bl2) {
                throw new IllegalStateException("Required session parameter '" + string + "' not configured");
            }
        }
    }
}

