/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.crypto.tls.AbstractTlsClient;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsAuthentication;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsCipherFactory;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsKeyExchange;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsPSKIdentity;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity tlsPSKIdentity) {
        this(new DefaultTlsCipherFactory(), tlsPSKIdentity);
    }

    public PSKTlsClient(TlsCipherFactory tlsCipherFactory, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCipherFactory);
        this.pskIdentity = tlsPSKIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n2) {
        return new TlsPSKKeyExchange(n2, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

