/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.crypto.tls.HeartbeatMode;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatExtension {
    protected short mode;

    public HeartbeatExtension(short s2) {
        if (!HeartbeatMode.isValid(s2)) {
            throw new IllegalArgumentException("'mode' is not a valid HeartbeatMode value");
        }
        this.mode = s2;
    }

    public short getMode() {
        return this.mode;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.mode, outputStream);
    }

    public static HeartbeatExtension parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        if (!HeartbeatMode.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        return new HeartbeatExtension(s2);
    }
}

