/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.tls;

import com.aspose.psd.internal.bouncycastle.crypto.tls.Certificate;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CertificateRequest;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CertificateStatus;
import com.aspose.psd.internal.bouncycastle.crypto.tls.CipherSuite;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DTLSProtocol;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DTLSTransport;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DatagramTransport;
import com.aspose.psd.internal.bouncycastle.crypto.tls.DigitallySigned;
import com.aspose.psd.internal.bouncycastle.crypto.tls.NewSessionTicket;
import com.aspose.psd.internal.bouncycastle.crypto.tls.ProtocolVersion;
import com.aspose.psd.internal.bouncycastle.crypto.tls.SecurityParameters;
import com.aspose.psd.internal.bouncycastle.crypto.tls.SessionParameters;
import com.aspose.psd.internal.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsAuthentication;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsClient;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsCredentials;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsKeyExchange;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsProtocol;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsSession;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.aspose.psd.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.psd.internal.bouncycastle.crypto.tls.f;
import com.aspose.psd.internal.bouncycastle.crypto.tls.g;
import com.aspose.psd.internal.bouncycastle.crypto.tls.p;
import com.aspose.psd.internal.bouncycastle.crypto.tls.t;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        Object object;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.client = tlsClient;
        clientHandshakeState.clientContext = new p(this.secureRandom, securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(tlsClient.shouldUseGMTUnixTime(), clientHandshakeState.clientContext.getNonceRandomGenerator());
        tlsClient.init(clientHandshakeState.clientContext);
        f f2 = new f(datagramTransport, clientHandshakeState.clientContext, tlsClient, 22);
        TlsSession tlsSession = clientHandshakeState.client.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (object = tlsSession.exportSessionParameters()) != null) {
            clientHandshakeState.tlsSession = tlsSession;
            clientHandshakeState.sessionParameters = object;
        }
        try {
            object = this.clientHandshake(clientHandshakeState, f2);
            return object;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, f2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, f2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, f2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState clientHandshakeState, f f2, short s2) {
        f2.a(s2);
        this.invalidateSession(clientHandshakeState);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState clientHandshakeState, f f2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        g g2 = new g(clientHandshakeState.clientContext, f2);
        byte[] byArray = this.generateClientHello(clientHandshakeState, clientHandshakeState.client);
        f2.b(ProtocolVersion.DTLSv10);
        g2.a((short)1, byArray);
        g.a a2 = g2.d();
        while (a2.b() == 3) {
            object6 = f2.b();
            if (!((ProtocolVersion)object6).isEqualOrEarlierVersionOf((ProtocolVersion)(object5 = clientHandshakeState.clientContext.getClientVersion()))) {
                throw new TlsFatalAlert(47);
            }
            f2.a((ProtocolVersion)null);
            object4 = this.processHelloVerifyRequest(clientHandshakeState, a2.c());
            object3 = DTLSClientProtocol.patchClientHelloWithCookie(byArray, object4);
            g2.f();
            g2.a((short)1, (byte[])object3);
            a2 = g2.d();
        }
        if (a2.b() != 2) {
            throw new TlsFatalAlert(10);
        }
        object6 = f2.b();
        this.reportServerVersion(clientHandshakeState, (ProtocolVersion)object6);
        f2.b((ProtocolVersion)object6);
        this.processServerHello(clientHandshakeState, a2.c());
        g2.a();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(f2, securityParameters.maxFragmentLength);
        if (clientHandshakeState.resumedSession) {
            securityParameters.masterSecret = Arrays.clone(clientHandshakeState.sessionParameters.getMasterSecret());
            f2.a(clientHandshakeState.client.getCipher());
            object6 = TlsUtils.calculateVerifyData(clientHandshakeState.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(clientHandshakeState.clientContext, g2.b(), null));
            this.processFinished(g2.a((short)20), (byte[])object6);
            object5 = TlsUtils.calculateVerifyData(clientHandshakeState.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(clientHandshakeState.clientContext, g2.b(), null));
            g2.a((short)20, (byte[])object5);
            g2.e();
            clientHandshakeState.clientContext.a(clientHandshakeState.tlsSession);
            clientHandshakeState.client.notifyHandshakeComplete();
            return new DTLSTransport(f2);
        }
        this.invalidateSession(clientHandshakeState);
        if (clientHandshakeState.selectedSessionID.length > 0) {
            clientHandshakeState.tlsSession = new t(clientHandshakeState.selectedSessionID, null);
        }
        if ((a2 = g2.d()).b() == 23) {
            this.processServerSupplementalData(clientHandshakeState, a2.c());
            a2 = g2.d();
        } else {
            clientHandshakeState.client.processServerSupplementalData(null);
        }
        clientHandshakeState.keyExchange = clientHandshakeState.client.getKeyExchange();
        clientHandshakeState.keyExchange.init(clientHandshakeState.clientContext);
        object6 = null;
        if (a2.b() == 11) {
            object6 = this.processServerCertificate(clientHandshakeState, a2.c());
            a2 = g2.d();
        } else {
            clientHandshakeState.keyExchange.skipServerCredentials();
        }
        if (object6 == null || ((Certificate)object6).isEmpty()) {
            clientHandshakeState.allowCertificateStatus = false;
        }
        if (a2.b() == 22) {
            this.processCertificateStatus(clientHandshakeState, a2.c());
            a2 = g2.d();
        }
        if (a2.b() == 12) {
            this.processServerKeyExchange(clientHandshakeState, a2.c());
            a2 = g2.d();
        } else {
            clientHandshakeState.keyExchange.skipServerKeyExchange();
        }
        if (a2.b() == 13) {
            this.processCertificateRequest(clientHandshakeState, a2.c());
            TlsUtils.trackHashAlgorithms(g2.b(), clientHandshakeState.certificateRequest.getSupportedSignatureAlgorithms());
            a2 = g2.d();
        }
        if (a2.b() == 14) {
            if (a2.c().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        g2.b().sealHashAlgorithms();
        object5 = clientHandshakeState.client.getClientSupplementalData();
        if (object5 != null) {
            object4 = DTLSClientProtocol.generateSupplementalData((Vector)object5);
            g2.a((short)23, (byte[])object4);
        }
        if (clientHandshakeState.certificateRequest != null) {
            clientHandshakeState.clientCredentials = clientHandshakeState.authentication.getClientCredentials(clientHandshakeState.certificateRequest);
            object4 = null;
            if (clientHandshakeState.clientCredentials != null) {
                object4 = clientHandshakeState.clientCredentials.getCertificate();
            }
            if (object4 == null) {
                object4 = Certificate.EMPTY_CHAIN;
            }
            object3 = DTLSClientProtocol.generateCertificate((Certificate)object4);
            g2.a((short)11, (byte[])object3);
        }
        if (clientHandshakeState.clientCredentials != null) {
            clientHandshakeState.keyExchange.processClientCredentials(clientHandshakeState.clientCredentials);
        } else {
            clientHandshakeState.keyExchange.skipClientCredentials();
        }
        object4 = this.generateClientKeyExchange(clientHandshakeState);
        g2.a((short)16, (byte[])object4);
        object3 = g2.c();
        securityParameters.sessionHash = TlsProtocol.getCurrentPRFHash(clientHandshakeState.clientContext, (TlsHandshakeHash)object3, null);
        TlsProtocol.establishMasterSecret(clientHandshakeState.clientContext, clientHandshakeState.keyExchange);
        f2.a(clientHandshakeState.client.getCipher());
        if (clientHandshakeState.clientCredentials != null && clientHandshakeState.clientCredentials instanceof TlsSignerCredentials) {
            object2 = (TlsSignerCredentials)clientHandshakeState.clientCredentials;
            object = TlsUtils.getSignatureAndHashAlgorithm(clientHandshakeState.clientContext, (TlsSignerCredentials)object2);
            byte[] byArray2 = object == null ? securityParameters.getSessionHash() : object3.getFinalHash(((SignatureAndHashAlgorithm)object).getHash());
            byte[] byArray3 = object2.generateCertificateSignature(byArray2);
            DigitallySigned digitallySigned = new DigitallySigned((SignatureAndHashAlgorithm)object, byArray3);
            byte[] byArray4 = this.generateCertificateVerify(clientHandshakeState, digitallySigned);
            g2.a((short)15, byArray4);
        }
        object2 = TlsUtils.calculateVerifyData(clientHandshakeState.clientContext, "client finished", TlsProtocol.getCurrentPRFHash(clientHandshakeState.clientContext, g2.b(), null));
        g2.a((short)20, (byte[])object2);
        if (clientHandshakeState.expectSessionTicket) {
            a2 = g2.d();
            if (a2.b() == 4) {
                this.processNewSessionTicket(clientHandshakeState, a2.c());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        object = TlsUtils.calculateVerifyData(clientHandshakeState.clientContext, "server finished", TlsProtocol.getCurrentPRFHash(clientHandshakeState.clientContext, g2.b(), null));
        this.processFinished(g2.a((short)20), (byte[])object);
        g2.e();
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setMasterSecret(securityParameters.getMasterSecret()).setPeerCertificate((Certificate)object6).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(clientHandshakeState.serverExtensions).build();
            clientHandshakeState.tlsSession = TlsUtils.importSession(clientHandshakeState.tlsSession.getSessionID(), clientHandshakeState.sessionParameters);
            clientHandshakeState.clientContext.a(clientHandshakeState.tlsSession);
        }
        clientHandshakeState.client.notifyHandshakeComplete();
        return new DTLSTransport(f2);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState clientHandshakeState, DigitallySigned digitallySigned) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        digitallySigned.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState clientHandshakeState, TlsClient tlsClient) throws IOException {
        boolean bl2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = tlsClient.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        p p2 = clientHandshakeState.clientContext;
        p2.a(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        SecurityParameters securityParameters = p2.getSecurityParameters();
        byteArrayOutputStream.write(securityParameters.getClientRandom());
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (clientHandshakeState.tlsSession != null && ((byArray = clientHandshakeState.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        boolean bl3 = tlsClient.isFallback();
        clientHandshakeState.offeredCipherSuites = tlsClient.getCipherSuites();
        clientHandshakeState.clientExtensions = tlsClient.getClientExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl4 = null == byArray2;
        boolean bl5 = bl2 = !Arrays.contains(clientHandshakeState.offeredCipherSuites, 255);
        if (bl4 && bl2) {
            clientHandshakeState.offeredCipherSuites = Arrays.append(clientHandshakeState.offeredCipherSuites, 255);
        }
        if (bl3 && !Arrays.contains(clientHandshakeState.offeredCipherSuites, 22016)) {
            clientHandshakeState.offeredCipherSuites = Arrays.append(clientHandshakeState.offeredCipherSuites, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(clientHandshakeState.offeredCipherSuites, byteArrayOutputStream);
        clientHandshakeState.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(clientHandshakeState.offeredCompressionMethods, byteArrayOutputStream);
        if (clientHandshakeState.clientExtensions != null) {
            TlsProtocol.writeExtensions(byteArrayOutputStream, clientHandshakeState.clientExtensions);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState clientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHandshakeState.keyExchange.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.sessionParameters != null) {
            clientHandshakeState.sessionParameters.clear();
            clientHandshakeState.sessionParameters = null;
        }
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.tlsSession.invalidate();
            clientHandshakeState.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (clientHandshakeState.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateRequest = CertificateRequest.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.keyExchange.validateCertificateRequest(clientHandshakeState.certificateRequest);
    }

    protected void processCertificateStatus(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (!clientHandshakeState.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateStatus = CertificateStatus.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(clientHandshakeState.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) && byArray2.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    protected void processNewSessionTicket(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.keyExchange.processServerCertificate(certificate);
        clientHandshakeState.authentication = clientHandshakeState.client.getAuthentication();
        clientHandshakeState.authentication.notifyServerCertificate(certificate);
        return certificate;
    }

    protected void processServerHello(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        Serializable serializable;
        Object object;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.reportServerVersion(clientHandshakeState, protocolVersion);
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        clientHandshakeState.selectedSessionID = TlsUtils.readOpaque8(byteArrayInputStream);
        if (clientHandshakeState.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySessionID(clientHandshakeState.selectedSessionID);
        clientHandshakeState.resumedSession = clientHandshakeState.selectedSessionID.length > 0 && clientHandshakeState.tlsSession != null && Arrays.areEqual(clientHandshakeState.selectedSessionID, clientHandshakeState.tlsSession.getSessionID());
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (!Arrays.contains(clientHandshakeState.offeredCipherSuites, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, clientHandshakeState.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(n2, (short)47);
        clientHandshakeState.client.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (!Arrays.contains(clientHandshakeState.offeredCompressionMethods, s2)) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySelectedCompressionMethod(s2);
        clientHandshakeState.serverExtensions = TlsProtocol.readExtensions(byteArrayInputStream);
        if (clientHandshakeState.serverExtensions != null) {
            object = clientHandshakeState.serverExtensions.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!clientHandshakeState.resumedSession) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData(clientHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            clientHandshakeState.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        clientHandshakeState.client.notifySecureRenegotiation(clientHandshakeState.secure_renegotiation);
        object = clientHandshakeState.clientExtensions;
        serializable = clientHandshakeState.serverExtensions;
        if (clientHandshakeState.resumedSession) {
            if (n2 != clientHandshakeState.sessionParameters.getCipherSuite() || s2 != clientHandshakeState.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = clientHandshakeState.sessionParameters.readServerExtensions();
        }
        securityParameters.cipherSuite = n2;
        securityParameters.compressionAlgorithm = s2;
        if (serializable != null) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl2 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl2;
            securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            securityParameters.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(clientHandshakeState.resumedSession, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            clientHandshakeState.allowCertificateStatus = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl3 = clientHandshakeState.expectSessionTicket = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            clientHandshakeState.client.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(clientHandshakeState.clientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.keyExchange.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        clientHandshakeState.client.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState clientHandshakeState, ProtocolVersion protocolVersion) throws IOException {
        p p2 = clientHandshakeState.clientContext;
        ProtocolVersion protocolVersion2 = p2.getServerVersion();
        if (null == protocolVersion2) {
            p2.b(protocolVersion);
            clientHandshakeState.client.notifyServerVersion(protocolVersion);
        } else if (!protocolVersion2.equals(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8(byArray, n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        TlsUtils.checkUint8(byArray2.length);
        TlsUtils.writeUint8(byArray2.length, byArray3, n3);
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        System.arraycopy(byArray, n4, byArray3, n4 + byArray2.length, byArray.length - n4);
        return byArray3;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        p clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        short[] offeredCompressionMethods = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        byte[] selectedSessionID = null;
        boolean resumedSession = false;
        boolean secure_renegotiation = false;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;

        protected ClientHandshakeState() {
        }
    }
}

