/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.modes;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.util.Vector;

public class OCBBlockCipher
implements AEADBlockCipher {
    private static final int a = 16;
    private BlockCipher b;
    private BlockCipher c;
    private boolean d;
    private int e;
    private byte[] f;
    private Vector g;
    private byte[] h;
    private byte[] i;
    private byte[] j = null;
    private byte[] k = new byte[24];
    private byte[] l = new byte[16];
    private byte[] m;
    private byte[] n;
    private int o;
    private int p;
    private long q;
    private long r;
    private byte[] s;
    private byte[] t;
    private byte[] u = new byte[16];
    private byte[] v;
    private byte[] w;

    public OCBBlockCipher(BlockCipher blockCipher, BlockCipher blockCipher2) {
        if (blockCipher == null) {
            throw new IllegalArgumentException("'hashCipher' cannot be null");
        }
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("'hashCipher' must have a block size of 16");
        }
        if (blockCipher2 == null) {
            throw new IllegalArgumentException("'mainCipher' cannot be null");
        }
        if (blockCipher2.getBlockSize() != 16) {
            throw new IllegalArgumentException("'mainCipher' must have a block size of 16");
        }
        if (!blockCipher.getAlgorithmName().equals(blockCipher2.getAlgorithmName())) {
            throw new IllegalArgumentException("'hashCipher' and 'mainCipher' must be the same algorithm");
        }
        this.b = blockCipher;
        this.c = blockCipher2;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.c;
    }

    @Override
    public String getAlgorithmName() {
        return this.c.getAlgorithmName() + "/OCB";
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        int n2;
        byte[] byArray;
        CipherParameters cipherParameters2;
        boolean bl3 = this.d;
        this.d = bl2;
        this.w = null;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)cipherParameters2).getNonce();
            this.f = ((AEADParameters)cipherParameters2).getAssociatedText();
            n2 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n2 < 64 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.e = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)cipherParameters2).getIV();
            this.f = null;
            this.e = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to OCB");
        }
        this.m = new byte[16];
        this.n = new byte[bl2 ? 16 : 16 + this.e];
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (byArray.length > 15) {
            throw new IllegalArgumentException("IV must be no more than 15 bytes");
        }
        if (keyParameter != null) {
            this.b.init(true, keyParameter);
            this.c.init(bl2, keyParameter);
            this.j = null;
        } else if (bl3 != bl2) {
            throw new IllegalArgumentException("cannot change encrypting state without providing key.");
        }
        this.h = new byte[16];
        this.b.processBlock(this.h, 0, this.h, 0);
        this.i = OCBBlockCipher.OCB_double(this.h);
        this.g = new Vector();
        this.g.addElement(OCBBlockCipher.OCB_double(this.i));
        int n3 = this.processNonce(byArray);
        n2 = n3 % 8;
        int n4 = n3 / 8;
        if (n2 == 0) {
            System.arraycopy(this.k, n4, this.l, 0, 16);
        } else {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n5 = this.k[n4] & 0xFF;
                int n6 = this.k[++n4] & 0xFF;
                this.l[i2] = (byte)(n5 << n2 | n6 >>> 8 - n2);
            }
        }
        this.o = 0;
        this.p = 0;
        this.q = 0L;
        this.r = 0L;
        this.s = new byte[16];
        this.t = new byte[16];
        System.arraycopy(this.l, 0, this.u, 0, 16);
        this.v = new byte[16];
        if (this.f != null) {
            this.processAADBytes(this.f, 0, this.f.length);
        }
    }

    protected int processNonce(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        byArray2[0] = (byte)(this.e << 4);
        int n2 = 15 - byArray.length;
        byArray2[n2] = (byte)(byArray2[n2] | 1);
        int n3 = byArray2[15] & 0x3F;
        byArray2[15] = (byte)(byArray2[15] & 0xC0);
        if (this.j == null || !Arrays.areEqual(byArray2, this.j)) {
            byte[] byArray3 = new byte[16];
            this.j = byArray2;
            this.b.processBlock(this.j, 0, byArray3, 0);
            System.arraycopy(byArray3, 0, this.k, 0, 16);
            for (int i2 = 0; i2 < 8; ++i2) {
                this.k[16 + i2] = (byte)(byArray3[i2] ^ byArray3[i2 + 1]);
            }
        }
        return n3;
    }

    @Override
    public byte[] getMac() {
        if (this.w == null) {
            return new byte[this.e];
        }
        return Arrays.clone(this.w);
    }

    @Override
    public int getOutputSize(int n2) {
        int n3 = n2 + this.p;
        if (this.d) {
            return n3 + this.e;
        }
        return n3 < this.e ? 0 : n3 - this.e;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.p;
        if (!this.d) {
            if (n3 < this.e) {
                return 0;
            }
            n3 -= this.e;
        }
        return n3 - n3 % 16;
    }

    @Override
    public void processAADByte(byte by2) {
        this.m[this.o] = by2;
        if (++this.o == this.m.length) {
            this.processHashBlock();
        }
    }

    @Override
    public void processAADBytes(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.m[this.o] = byArray[n2 + i2];
            if (++this.o != this.m.length) continue;
            this.processHashBlock();
        }
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException {
        this.n[this.p] = by2;
        if (++this.p == this.n.length) {
            this.processMainBlock(byArray, n2);
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (byArray.length < n2 + n3) {
            throw new DataLengthException("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.n[this.p] = byArray[n2 + i2];
            if (++this.p != this.n.length) continue;
            this.processMainBlock(byArray2, n4 + n5);
            n5 += 16;
        }
        return n5;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray2 = null;
        if (!this.d) {
            if (this.p < this.e) {
                throw new InvalidCipherTextException("data too short");
            }
            this.p -= this.e;
            byArray2 = new byte[this.e];
            System.arraycopy(this.n, this.p, byArray2, 0, this.e);
        }
        if (this.o > 0) {
            OCBBlockCipher.OCB_extend(this.m, this.o);
            this.updateHASH(this.h);
        }
        if (this.p > 0) {
            if (this.d) {
                OCBBlockCipher.OCB_extend(this.n, this.p);
                OCBBlockCipher.xor(this.v, this.n);
            }
            OCBBlockCipher.xor(this.u, this.h);
            byte[] byArray3 = new byte[16];
            this.b.processBlock(this.u, 0, byArray3, 0);
            OCBBlockCipher.xor(this.n, byArray3);
            if (byArray.length < n2 + this.p) {
                throw new OutputLengthException("Output buffer too short");
            }
            System.arraycopy(this.n, 0, byArray, n2, this.p);
            if (!this.d) {
                OCBBlockCipher.OCB_extend(this.n, this.p);
                OCBBlockCipher.xor(this.v, this.n);
            }
        }
        OCBBlockCipher.xor(this.v, this.u);
        OCBBlockCipher.xor(this.v, this.i);
        this.b.processBlock(this.v, 0, this.v, 0);
        OCBBlockCipher.xor(this.v, this.t);
        this.w = new byte[this.e];
        System.arraycopy(this.v, 0, this.w, 0, this.e);
        int n3 = this.p;
        if (this.d) {
            if (byArray.length < n2 + n3 + this.e) {
                throw new OutputLengthException("Output buffer too short");
            }
            System.arraycopy(this.w, 0, byArray, n2 + n3, this.e);
            n3 += this.e;
        } else if (!Arrays.constantTimeAreEqual(this.w, byArray2)) {
            throw new InvalidCipherTextException("mac check in OCB failed");
        }
        this.reset(false);
        return n3;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    protected void clear(byte[] byArray) {
        if (byArray != null) {
            Arrays.fill(byArray, (byte)0);
        }
    }

    protected byte[] getLSub(int n2) {
        while (n2 >= this.g.size()) {
            this.g.addElement(OCBBlockCipher.OCB_double((byte[])this.g.lastElement()));
        }
        return (byte[])this.g.elementAt(n2);
    }

    protected void processHashBlock() {
        this.updateHASH(this.getLSub(OCBBlockCipher.OCB_ntz(++this.q)));
        this.o = 0;
    }

    protected void processMainBlock(byte[] byArray, int n2) {
        if (byArray.length < n2 + 16) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.d) {
            OCBBlockCipher.xor(this.v, this.n);
            this.p = 0;
        }
        OCBBlockCipher.xor(this.u, this.getLSub(OCBBlockCipher.OCB_ntz(++this.r)));
        OCBBlockCipher.xor(this.n, this.u);
        this.c.processBlock(this.n, 0, this.n, 0);
        OCBBlockCipher.xor(this.n, this.u);
        System.arraycopy(this.n, 0, byArray, n2, 16);
        if (!this.d) {
            OCBBlockCipher.xor(this.v, this.n);
            System.arraycopy(this.n, 16, this.n, 0, this.e);
            this.p = this.e;
        }
    }

    protected void reset(boolean bl2) {
        this.b.reset();
        this.c.reset();
        this.clear(this.m);
        this.clear(this.n);
        this.o = 0;
        this.p = 0;
        this.q = 0L;
        this.r = 0L;
        this.clear(this.s);
        this.clear(this.t);
        System.arraycopy(this.l, 0, this.u, 0, 16);
        this.clear(this.v);
        if (bl2) {
            this.w = null;
        }
        if (this.f != null) {
            this.processAADBytes(this.f, 0, this.f.length);
        }
    }

    protected void updateHASH(byte[] byArray) {
        OCBBlockCipher.xor(this.s, byArray);
        OCBBlockCipher.xor(this.m, this.s);
        this.b.processBlock(this.m, 0, this.m, 0);
        OCBBlockCipher.xor(this.t, this.m);
    }

    protected static byte[] OCB_double(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n2 = OCBBlockCipher.shiftLeft(byArray, byArray2);
        byArray2[15] = (byte)(byArray2[15] ^ 135 >>> (1 - n2 << 3));
        return byArray2;
    }

    protected static void OCB_extend(byte[] byArray, int n2) {
        byArray[n2] = -128;
        while (++n2 < 16) {
            byArray[n2] = 0;
        }
    }

    protected static int OCB_ntz(long l2) {
        if (l2 == 0L) {
            return 64;
        }
        int n2 = 0;
        while ((l2 & 1L) == 0L) {
            ++n2;
            l2 >>>= 1;
        }
        return n2;
    }

    protected static int shiftLeft(byte[] byArray, byte[] byArray2) {
        int n2 = 16;
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = byArray[n2] & 0xFF;
            byArray2[n2] = (byte)(n4 << 1 | n3);
            n3 = n4 >>> 7 & 1;
        }
        return n3;
    }

    protected static void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 15; i2 >= 0; --i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }
}

