/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.engines;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.Wrapper;
import com.aspose.psd.internal.bouncycastle.crypto.engines.GOST28147Engine;
import com.aspose.psd.internal.bouncycastle.crypto.macs.GOST28147Mac;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithSBox;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithUKM;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine a = new GOST28147Engine();
    private GOST28147Mac b = new GOST28147Mac();

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            cipherParameters = ((ParametersWithRandom)cipherParameters2).getParameters();
        }
        cipherParameters2 = (ParametersWithUKM)cipherParameters;
        this.a.init(bl2, ((ParametersWithUKM)cipherParameters2).getParameters());
        KeyParameter keyParameter = ((ParametersWithUKM)cipherParameters2).getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)cipherParameters2).getParameters()).getParameters() : (KeyParameter)((ParametersWithUKM)cipherParameters2).getParameters();
        this.b.init(new ParametersWithIV(keyParameter, ((ParametersWithUKM)cipherParameters2).getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        this.b.update(byArray, n2, n3);
        byte[] byArray2 = new byte[n3 + this.b.getMacSize()];
        this.a.processBlock(byArray, n2, byArray2, 0);
        this.a.processBlock(byArray, n2 + 8, byArray2, 8);
        this.a.processBlock(byArray, n2 + 16, byArray2, 16);
        this.a.processBlock(byArray, n2 + 24, byArray2, 24);
        this.b.doFinal(byArray2, n3);
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n3 - this.b.getMacSize()];
        this.a.processBlock(byArray, n2, byArray2, 0);
        this.a.processBlock(byArray, n2 + 8, byArray2, 8);
        this.a.processBlock(byArray, n2 + 16, byArray2, 16);
        this.a.processBlock(byArray, n2 + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.b.getMacSize()];
        this.b.update(byArray2, 0, byArray2.length);
        this.b.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.b.getMacSize()];
        System.arraycopy(byArray, n2 + n3 - 4, byArray4, 0, this.b.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

