/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.engines;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.Wrapper;
import com.aspose.psd.internal.bouncycastle.crypto.engines.DSTU7624Engine;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.util.ArrayList;

public class DSTU7624WrapEngine
implements Wrapper {
    private static final int a = 4;
    private boolean b;
    private DSTU7624Engine c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private byte[] g;
    private ArrayList<byte[]> h;

    public DSTU7624WrapEngine(int n2) {
        this.c = new DSTU7624Engine(n2);
        this.d = new byte[this.c.getBlockSize() / 2];
        this.f = new byte[this.c.getBlockSize()];
        this.g = new byte[this.c.getBlockSize()];
        this.h = new ArrayList();
        this.e = new byte[4];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.b = bl2;
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameters passed to DSTU7624WrapEngine");
        }
        this.c.init(bl2, cipherParameters);
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624WrapEngine";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        int n4;
        if (!this.b) {
            throw new IllegalStateException("not set for wrapping");
        }
        if (n3 % this.c.getBlockSize() != 0) {
            throw new DataLengthException("wrap data must be a multiple of " + this.c.getBlockSize() + " bytes");
        }
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        int n5 = 2 * (1 + n3 / this.c.getBlockSize());
        int n6 = (n5 - 1) * 6;
        byte[] byArray2 = new byte[n3 + this.c.getBlockSize()];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        System.arraycopy(byArray2, 0, this.d, 0, this.c.getBlockSize() / 2);
        this.h.clear();
        int n7 = byArray2.length - this.c.getBlockSize() / 2;
        int n8 = this.c.getBlockSize() / 2;
        while (n7 != 0) {
            byte[] byArray3 = new byte[this.c.getBlockSize() / 2];
            System.arraycopy(byArray2, n8, byArray3, 0, this.c.getBlockSize() / 2);
            this.h.add(byArray3);
            n7 -= this.c.getBlockSize() / 2;
            n8 += this.c.getBlockSize() / 2;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n9;
            System.arraycopy(this.d, 0, byArray2, 0, this.c.getBlockSize() / 2);
            System.arraycopy(this.h.get(0), 0, byArray2, this.c.getBlockSize() / 2, this.c.getBlockSize() / 2);
            this.c.processBlock(byArray2, 0, byArray2, 0);
            this.a(n4 + 1, this.e, 0);
            for (n9 = 0; n9 < 4; ++n9) {
                int n10 = n9 + this.c.getBlockSize() / 2;
                byArray2[n10] = (byte)(byArray2[n10] ^ this.e[n9]);
            }
            System.arraycopy(byArray2, this.c.getBlockSize() / 2, this.d, 0, this.c.getBlockSize() / 2);
            for (n9 = 2; n9 < n5; ++n9) {
                System.arraycopy(this.h.get(n9 - 1), 0, this.h.get(n9 - 2), 0, this.c.getBlockSize() / 2);
            }
            System.arraycopy(byArray2, 0, this.h.get(n5 - 2), 0, this.c.getBlockSize() / 2);
        }
        System.arraycopy(this.d, 0, byArray2, 0, this.c.getBlockSize() / 2);
        n8 = this.c.getBlockSize() / 2;
        for (n4 = 0; n4 < n5 - 1; ++n4) {
            System.arraycopy(this.h.get(n4), 0, byArray2, n8, this.c.getBlockSize() / 2);
            n8 += this.c.getBlockSize() / 2;
        }
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (this.b) {
            throw new IllegalStateException("not set for unwrapping");
        }
        if (n3 % this.c.getBlockSize() != 0) {
            throw new DataLengthException("unwrap data must be a multiple of " + this.c.getBlockSize() + " bytes");
        }
        int n5 = 2 * n3 / this.c.getBlockSize();
        int n6 = (n5 - 1) * 6;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        byte[] byArray3 = new byte[this.c.getBlockSize() / 2];
        System.arraycopy(byArray2, 0, byArray3, 0, this.c.getBlockSize() / 2);
        this.h.clear();
        int n7 = byArray2.length - this.c.getBlockSize() / 2;
        int n8 = this.c.getBlockSize() / 2;
        while (n7 != 0) {
            byte[] byArray4 = new byte[this.c.getBlockSize() / 2];
            System.arraycopy(byArray2, n8, byArray4, 0, this.c.getBlockSize() / 2);
            this.h.add(byArray4);
            n7 -= this.c.getBlockSize() / 2;
            n8 += this.c.getBlockSize() / 2;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n9;
            System.arraycopy(this.h.get(n5 - 2), 0, byArray2, 0, this.c.getBlockSize() / 2);
            System.arraycopy(byArray3, 0, byArray2, this.c.getBlockSize() / 2, this.c.getBlockSize() / 2);
            this.a(n6 - n4, this.e, 0);
            for (n9 = 0; n9 < 4; ++n9) {
                int n10 = n9 + this.c.getBlockSize() / 2;
                byArray2[n10] = (byte)(byArray2[n10] ^ this.e[n9]);
            }
            this.c.processBlock(byArray2, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray3, 0, this.c.getBlockSize() / 2);
            for (n9 = 2; n9 < n5; ++n9) {
                System.arraycopy(this.h.get(n5 - n9 - 1), 0, this.h.get(n5 - n9), 0, this.c.getBlockSize() / 2);
            }
            System.arraycopy(byArray2, this.c.getBlockSize() / 2, this.h.get(0), 0, this.c.getBlockSize() / 2);
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.c.getBlockSize() / 2);
        n8 = this.c.getBlockSize() / 2;
        for (n4 = 0; n4 < n5 - 1; ++n4) {
            System.arraycopy(this.h.get(n4), 0, byArray2, n8, this.c.getBlockSize() / 2);
            n8 += this.c.getBlockSize() / 2;
        }
        System.arraycopy(byArray2, byArray2.length - this.c.getBlockSize(), this.f, 0, this.c.getBlockSize());
        byte[] byArray5 = new byte[byArray2.length - this.c.getBlockSize()];
        if (!Arrays.areEqual(this.f, this.g)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length - this.c.getBlockSize());
        return byArray5;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >> 24);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3] = (byte)n2;
    }
}

