/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.engines;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.Wrapper;
import com.aspose.psd.internal.bouncycastle.crypto.engines.DESedeEngine;
import com.aspose.psd.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DESedeWrapEngine
implements Wrapper {
    private CBCBlockCipher a;
    private KeyParameter b;
    private ParametersWithIV c;
    private byte[] d;
    private boolean e;
    private static final byte[] f = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest sha1 = DigestFactory.createSHA1();
    byte[] digest = new byte[20];

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        SecureRandom secureRandom;
        this.e = bl2;
        this.a = new CBCBlockCipher(new DESedeEngine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = parametersWithRandom.getParameters();
            secureRandom = parametersWithRandom.getRandom();
        } else {
            secureRandom = new SecureRandom();
        }
        if (cipherParameters instanceof KeyParameter) {
            this.b = (KeyParameter)cipherParameters;
            if (this.e) {
                this.d = new byte[8];
                secureRandom.nextBytes(this.d);
                this.c = new ParametersWithIV(this.b, this.d);
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.c = (ParametersWithIV)cipherParameters;
            this.d = this.c.getIV();
            this.b = (KeyParameter)this.c.getParameters();
            if (this.e) {
                if (this.d == null || this.d.length != 8) {
                    throw new IllegalArgumentException("IV is not 8 octets");
                }
            } else {
                throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.e) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        byte[] byArray3 = this.a(byArray2);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        int n4 = this.a.getBlockSize();
        if (byArray4.length % n4 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.a.init(true, this.c);
        byte[] byArray5 = new byte[byArray4.length];
        for (int i2 = 0; i2 != byArray4.length; i2 += n4) {
            this.a.processBlock(byArray4, i2, byArray5, i2);
        }
        byte[] byArray6 = new byte[this.d.length + byArray5.length];
        System.arraycopy(this.d, 0, byArray6, 0, this.d.length);
        System.arraycopy(byArray5, 0, byArray6, this.d.length, byArray5.length);
        byte[] byArray7 = DESedeWrapEngine.b(byArray6);
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, f);
        this.a.init(true, parametersWithIV);
        for (int i3 = 0; i3 != byArray7.length; i3 += n4) {
            this.a.processBlock(byArray7, i3, byArray7, i3);
        }
        return byArray7;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.e) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (byArray == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        int n4 = this.a.getBlockSize();
        if (n3 % n4 != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + n4);
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, f);
        this.a.init(false, parametersWithIV);
        byte[] byArray2 = new byte[n3];
        for (int i2 = 0; i2 != n3; i2 += n4) {
            this.a.processBlock(byArray, n2 + i2, byArray2, i2);
        }
        byte[] byArray3 = DESedeWrapEngine.b(byArray2);
        this.d = new byte[8];
        byte[] byArray4 = new byte[byArray3.length - 8];
        System.arraycopy(byArray3, 0, this.d, 0, 8);
        System.arraycopy(byArray3, 8, byArray4, 0, byArray3.length - 8);
        this.c = new ParametersWithIV(this.b, this.d);
        this.a.init(false, this.c);
        byte[] byArray5 = new byte[byArray4.length];
        for (int i3 = 0; i3 != byArray5.length; i3 += n4) {
            this.a.processBlock(byArray4, i3, byArray5, i3);
        }
        byte[] byArray6 = new byte[byArray5.length - 8];
        byte[] byArray7 = new byte[8];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length - 8);
        System.arraycopy(byArray5, byArray5.length - 8, byArray7, 0, 8);
        if (!this.a(byArray6, byArray7)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        return byArray6;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.sha1.update(byArray, 0, byArray.length);
        this.sha1.doFinal(this.digest, 0);
        System.arraycopy(this.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.a(byArray), byArray2);
    }

    private static byte[] b(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - (i2 + 1)];
        }
        return byArray2;
    }
}

