/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.digests;

import com.aspose.psd.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] a = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};
    private static final int c = 10;
    private static final int d = 64;
    private int e = 32;
    private int f = 0;
    private byte[] g = null;
    private byte[] h = null;
    private byte[] i = null;
    private byte[] j = null;
    private int k = 0;
    private int[] l = new int[16];
    private int[] m = null;
    private int n = 0;
    private int o = 0;
    private int p = 0;

    public Blake2sDigest() {
        this(256);
    }

    public Blake2sDigest(Blake2sDigest blake2sDigest) {
        this.k = blake2sDigest.k;
        this.j = Arrays.clone(blake2sDigest.j);
        this.f = blake2sDigest.f;
        this.i = Arrays.clone(blake2sDigest.i);
        this.e = blake2sDigest.e;
        this.m = Arrays.clone(blake2sDigest.m);
        this.h = Arrays.clone(blake2sDigest.h);
    }

    public Blake2sDigest(int n2) {
        if (n2 != 128 && n2 != 160 && n2 != 224 && n2 != 256) {
            throw new IllegalArgumentException("BLAKE2s digest restricted to one of [128, 160, 224, 256]");
        }
        this.j = new byte[64];
        this.f = 0;
        this.e = n2 / 8;
        this.a();
    }

    public Blake2sDigest(byte[] byArray) {
        this.j = new byte[64];
        if (byArray != null) {
            if (byArray.length > 32) {
                throw new IllegalArgumentException("Keys > 32 are not supported");
            }
            this.i = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.i, 0, byArray.length);
            this.f = byArray.length;
            System.arraycopy(byArray, 0, this.j, 0, byArray.length);
            this.k = 64;
        }
        this.e = 32;
        this.a();
    }

    public Blake2sDigest(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        this.j = new byte[64];
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.e = n2;
        if (byArray2 != null) {
            if (byArray2.length != 8) {
                throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
            }
            this.g = new byte[8];
            System.arraycopy(byArray2, 0, this.g, 0, byArray2.length);
        }
        if (byArray3 != null) {
            if (byArray3.length != 8) {
                throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
            }
            this.h = new byte[8];
            System.arraycopy(byArray3, 0, this.h, 0, byArray3.length);
        }
        if (byArray != null) {
            if (byArray.length > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.i = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.i, 0, byArray.length);
            this.f = byArray.length;
            System.arraycopy(byArray, 0, this.j, 0, byArray.length);
            this.k = 64;
        }
        this.a();
    }

    private void a() {
        if (this.m == null) {
            this.m = new int[8];
            this.m[0] = a[0] ^ (this.e | this.f << 8 | 0x1010000);
            this.m[1] = a[1];
            this.m[2] = a[2];
            this.m[3] = a[3];
            this.m[4] = a[4];
            this.m[5] = a[5];
            if (this.g != null) {
                this.m[4] = this.m[4] ^ this.b(this.g, 0);
                this.m[5] = this.m[5] ^ this.b(this.g, 4);
            }
            this.m[6] = a[6];
            this.m[7] = a[7];
            if (this.h != null) {
                this.m[6] = this.m[6] ^ this.b(this.h, 0);
                this.m[7] = this.m[7] ^ this.b(this.h, 4);
            }
        }
    }

    private void b() {
        System.arraycopy(this.m, 0, this.l, 0, this.m.length);
        System.arraycopy(a, 0, this.l, this.m.length, 4);
        this.l[12] = this.n ^ a[4];
        this.l[13] = this.o ^ a[5];
        this.l[14] = this.p ^ a[6];
        this.l[15] = a[7];
    }

    @Override
    public void update(byte by2) {
        int n2 = 64 - this.k;
        if (n2 == 0) {
            this.n += 64;
            if (this.n == 0) {
                ++this.o;
            }
            this.a(this.j, 0);
            Arrays.fill(this.j, (byte)0);
            this.j[0] = by2;
            this.k = 1;
        } else {
            this.j[this.k] = by2;
            ++this.k;
        }
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null || n3 == 0) {
            return;
        }
        int n5 = 0;
        if (this.k != 0) {
            n5 = 64 - this.k;
            if (n5 < n3) {
                System.arraycopy(byArray, n2, this.j, this.k, n5);
                this.n += 64;
                if (this.n == 0) {
                    ++this.o;
                }
                this.a(this.j, 0);
                this.k = 0;
                Arrays.fill(this.j, (byte)0);
            } else {
                System.arraycopy(byArray, n2, this.j, this.k, n3);
                this.k += n3;
                return;
            }
        }
        int n6 = n2 + n3 - 64;
        for (n4 = n2 + n5; n4 < n6; n4 += 64) {
            this.n += 64;
            if (this.n == 0) {
                ++this.o;
            }
            this.a(byArray, n4);
        }
        System.arraycopy(byArray, n4, this.j, 0, n2 + n3 - n4);
        this.k += n2 + n3 - n4;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.p = -1;
        this.n += this.k;
        if (this.n < 0 && this.k > -this.n) {
            ++this.o;
        }
        this.a(this.j, 0);
        Arrays.fill(this.j, (byte)0);
        Arrays.fill(this.l, 0);
        for (int i2 = 0; i2 < this.m.length && i2 * 4 < this.e; ++i2) {
            byte[] byArray2 = this.a(this.m[i2]);
            if (i2 * 4 < this.e - 4) {
                System.arraycopy(byArray2, 0, byArray, n2 + i2 * 4, 4);
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n2 + i2 * 4, this.e - i2 * 4);
        }
        Arrays.fill(this.m, 0);
        this.reset();
        return this.e;
    }

    @Override
    public void reset() {
        this.k = 0;
        this.p = 0;
        this.n = 0;
        this.o = 0;
        this.m = null;
        Arrays.fill(this.j, (byte)0);
        if (this.i != null) {
            System.arraycopy(this.i, 0, this.j, 0, this.i.length);
            this.k = 64;
        }
        this.a();
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.b();
        int[] nArray = new int[16];
        for (n3 = 0; n3 < 16; ++n3) {
            nArray[n3] = this.b(byArray, n2 + n3 * 4);
        }
        for (n3 = 0; n3 < 10; ++n3) {
            this.a(nArray[b[n3][0]], nArray[b[n3][1]], 0, 4, 8, 12);
            this.a(nArray[b[n3][2]], nArray[b[n3][3]], 1, 5, 9, 13);
            this.a(nArray[b[n3][4]], nArray[b[n3][5]], 2, 6, 10, 14);
            this.a(nArray[b[n3][6]], nArray[b[n3][7]], 3, 7, 11, 15);
            this.a(nArray[b[n3][8]], nArray[b[n3][9]], 0, 5, 10, 15);
            this.a(nArray[b[n3][10]], nArray[b[n3][11]], 1, 6, 11, 12);
            this.a(nArray[b[n3][12]], nArray[b[n3][13]], 2, 7, 8, 13);
            this.a(nArray[b[n3][14]], nArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.m.length; ++n3) {
            this.m[n3] = this.m[n3] ^ this.l[n3] ^ this.l[n3 + 8];
        }
    }

    private void a(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.l[n4] = this.l[n4] + this.l[n5] + n2;
        this.l[n7] = this.a(this.l[n7] ^ this.l[n4], 16);
        this.l[n6] = this.l[n6] + this.l[n7];
        this.l[n5] = this.a(this.l[n5] ^ this.l[n6], 12);
        this.l[n4] = this.l[n4] + this.l[n5] + n3;
        this.l[n7] = this.a(this.l[n7] ^ this.l[n4], 8);
        this.l[n6] = this.l[n6] + this.l[n7];
        this.l[n5] = this.a(this.l[n5] ^ this.l[n6], 7);
    }

    private int a(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    private byte[] a(int n2) {
        return new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
    }

    private int b(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    @Override
    public int getDigestSize() {
        return this.e;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        if (this.i != null) {
            Arrays.fill(this.i, (byte)0);
            Arrays.fill(this.j, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
        }
    }
}

