/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.digests;

import com.aspose.psd.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] a = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}};
    private static int c = 12;
    private static final int d = 128;
    private int e = 64;
    private int f = 0;
    private byte[] g = null;
    private byte[] h = null;
    private byte[] i = null;
    private byte[] j = null;
    private int k = 0;
    private long[] l = new long[16];
    private long[] m = null;
    private long n = 0L;
    private long o = 0L;
    private long p = 0L;

    public Blake2bDigest() {
        this(512);
    }

    public Blake2bDigest(Blake2bDigest blake2bDigest) {
        this.k = blake2bDigest.k;
        this.j = Arrays.clone(blake2bDigest.j);
        this.f = blake2bDigest.f;
        this.i = Arrays.clone(blake2bDigest.i);
        this.e = blake2bDigest.e;
        this.m = Arrays.clone(blake2bDigest.m);
        this.h = Arrays.clone(blake2bDigest.h);
        this.g = Arrays.clone(blake2bDigest.g);
        this.n = blake2bDigest.n;
        this.o = blake2bDigest.o;
        this.p = blake2bDigest.p;
    }

    public Blake2bDigest(int n2) {
        if (n2 != 160 && n2 != 256 && n2 != 384 && n2 != 512) {
            throw new IllegalArgumentException("Blake2b digest restricted to one of [160, 256, 384, 512]");
        }
        this.j = new byte[128];
        this.f = 0;
        this.e = n2 / 8;
        this.a();
    }

    public Blake2bDigest(byte[] byArray) {
        this.j = new byte[128];
        if (byArray != null) {
            this.i = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.i, 0, byArray.length);
            if (byArray.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.f = byArray.length;
            System.arraycopy(byArray, 0, this.j, 0, byArray.length);
            this.k = 128;
        }
        this.e = 64;
        this.a();
    }

    public Blake2bDigest(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        this.j = new byte[128];
        if (n2 < 1 || n2 > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.e = n2;
        if (byArray2 != null) {
            if (byArray2.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.g = new byte[16];
            System.arraycopy(byArray2, 0, this.g, 0, byArray2.length);
        }
        if (byArray3 != null) {
            if (byArray3.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.h = new byte[16];
            System.arraycopy(byArray3, 0, this.h, 0, byArray3.length);
        }
        if (byArray != null) {
            this.i = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.i, 0, byArray.length);
            if (byArray.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.f = byArray.length;
            System.arraycopy(byArray, 0, this.j, 0, byArray.length);
            this.k = 128;
        }
        this.a();
    }

    private void a() {
        if (this.m == null) {
            this.m = new long[8];
            this.m[0] = a[0] ^ (long)(this.e | this.f << 8 | 0x1010000);
            this.m[1] = a[1];
            this.m[2] = a[2];
            this.m[3] = a[3];
            this.m[4] = a[4];
            this.m[5] = a[5];
            if (this.g != null) {
                this.m[4] = this.m[4] ^ this.b(this.g, 0);
                this.m[5] = this.m[5] ^ this.b(this.g, 8);
            }
            this.m[6] = a[6];
            this.m[7] = a[7];
            if (this.h != null) {
                this.m[6] = this.m[6] ^ this.b(this.h, 0);
                this.m[7] = this.m[7] ^ this.b(this.h, 8);
            }
        }
    }

    private void b() {
        System.arraycopy(this.m, 0, this.l, 0, this.m.length);
        System.arraycopy(a, 0, this.l, this.m.length, 4);
        this.l[12] = this.n ^ a[4];
        this.l[13] = this.o ^ a[5];
        this.l[14] = this.p ^ a[6];
        this.l[15] = a[7];
    }

    @Override
    public void update(byte by2) {
        int n2 = 0;
        n2 = 128 - this.k;
        if (n2 == 0) {
            this.n += 128L;
            if (this.n == 0L) {
                ++this.o;
            }
        } else {
            this.j[this.k] = by2;
            ++this.k;
            return;
        }
        this.a(this.j, 0);
        Arrays.fill(this.j, (byte)0);
        this.j[0] = by2;
        this.k = 1;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null || n3 == 0) {
            return;
        }
        int n5 = 0;
        if (this.k != 0) {
            n5 = 128 - this.k;
            if (n5 < n3) {
                System.arraycopy(byArray, n2, this.j, this.k, n5);
                this.n += 128L;
                if (this.n == 0L) {
                    ++this.o;
                }
                this.a(this.j, 0);
                this.k = 0;
                Arrays.fill(this.j, (byte)0);
            } else {
                System.arraycopy(byArray, n2, this.j, this.k, n3);
                this.k += n3;
                return;
            }
        }
        int n6 = n2 + n3 - 128;
        for (n4 = n2 + n5; n4 < n6; n4 += 128) {
            this.n += 128L;
            if (this.n == 0L) {
                ++this.o;
            }
            this.a(byArray, n4);
        }
        System.arraycopy(byArray, n4, this.j, 0, n2 + n3 - n4);
        this.k += n2 + n3 - n4;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.p = -1L;
        this.n += (long)this.k;
        if (this.k > 0 && this.n == 0L) {
            ++this.o;
        }
        this.a(this.j, 0);
        Arrays.fill(this.j, (byte)0);
        Arrays.fill(this.l, 0L);
        for (int i2 = 0; i2 < this.m.length && i2 * 8 < this.e; ++i2) {
            byte[] byArray2 = this.a(this.m[i2]);
            if (i2 * 8 < this.e - 8) {
                System.arraycopy(byArray2, 0, byArray, n2 + i2 * 8, 8);
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n2 + i2 * 8, this.e - i2 * 8);
        }
        Arrays.fill(this.m, 0L);
        this.reset();
        return this.e;
    }

    @Override
    public void reset() {
        this.k = 0;
        this.p = 0L;
        this.n = 0L;
        this.o = 0L;
        this.m = null;
        Arrays.fill(this.j, (byte)0);
        if (this.i != null) {
            System.arraycopy(this.i, 0, this.j, 0, this.i.length);
            this.k = 128;
        }
        this.a();
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.b();
        long[] lArray = new long[16];
        for (n3 = 0; n3 < 16; ++n3) {
            lArray[n3] = this.b(byArray, n2 + n3 * 8);
        }
        for (n3 = 0; n3 < c; ++n3) {
            this.a(lArray[b[n3][0]], lArray[b[n3][1]], 0, 4, 8, 12);
            this.a(lArray[b[n3][2]], lArray[b[n3][3]], 1, 5, 9, 13);
            this.a(lArray[b[n3][4]], lArray[b[n3][5]], 2, 6, 10, 14);
            this.a(lArray[b[n3][6]], lArray[b[n3][7]], 3, 7, 11, 15);
            this.a(lArray[b[n3][8]], lArray[b[n3][9]], 0, 5, 10, 15);
            this.a(lArray[b[n3][10]], lArray[b[n3][11]], 1, 6, 11, 12);
            this.a(lArray[b[n3][12]], lArray[b[n3][13]], 2, 7, 8, 13);
            this.a(lArray[b[n3][14]], lArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.m.length; ++n3) {
            this.m[n3] = this.m[n3] ^ this.l[n3] ^ this.l[n3 + 8];
        }
    }

    private void a(long l2, long l3, int n2, int n3, int n4, int n5) {
        this.l[n2] = this.l[n2] + this.l[n3] + l2;
        this.l[n5] = this.a(this.l[n5] ^ this.l[n2], 32);
        this.l[n4] = this.l[n4] + this.l[n5];
        this.l[n3] = this.a(this.l[n3] ^ this.l[n4], 24);
        this.l[n2] = this.l[n2] + this.l[n3] + l3;
        this.l[n5] = this.a(this.l[n5] ^ this.l[n2], 16);
        this.l[n4] = this.l[n4] + this.l[n5];
        this.l[n3] = this.a(this.l[n3] ^ this.l[n4], 63);
    }

    private long a(long l2, int n2) {
        return l2 >>> n2 | l2 << 64 - n2;
    }

    private final byte[] a(long l2) {
        return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24), (byte)(l2 >> 32), (byte)(l2 >> 40), (byte)(l2 >> 48), (byte)(l2 >> 56)};
    }

    private final long b(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    @Override
    public String getAlgorithmName() {
        return "Blake2b";
    }

    @Override
    public int getDigestSize() {
        return this.e;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (this.i != null) {
            Arrays.fill(this.i, (byte)0);
            Arrays.fill(this.j, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
        }
    }
}

