/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms.bc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.PasswordRecipient;
import com.aspose.psd.internal.bouncycastle.cms.bc.e;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.Wrapper;
import com.aspose.psd.internal.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;

public abstract class BcPasswordRecipient
implements PasswordRecipient {
    private final char[] a;
    private int b = 1;

    BcPasswordRecipient(char[] cArray) {
        this.a = cArray;
    }

    public BcPasswordRecipient setPasswordConversionScheme(int n2) {
        this.b = n2;
        return this;
    }

    protected KeyParameter extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        Wrapper wrapper = e.c(algorithmIdentifier.getAlgorithm());
        wrapper.init(false, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        try {
            return new KeyParameter(wrapper.unwrap(byArray2, 0, byArray2.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new CMSException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    @Override
    public byte[] calculateDerivedKey(int n2, AlgorithmIdentifier algorithmIdentifier, int n3) throws CMSException {
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(algorithmIdentifier.getParameters());
        byte[] byArray = n2 == 0 ? PBEParametersGenerator.PKCS5PasswordToBytes(this.a) : PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.a);
        try {
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(e.a(pBKDF2Params.getPrf()));
            pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
            return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n3)).getKey();
        }
        catch (Exception exception) {
            throw new CMSException("exception creating derived key: " + exception.getMessage(), exception);
        }
    }

    @Override
    public int getPasswordConversionScheme() {
        return this.b;
    }

    @Override
    public char[] getPassword() {
        return this.a;
    }
}

