/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSet;
import com.aspose.psd.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.CMSAttributeTableGenerator;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import com.aspose.psd.internal.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.aspose.psd.internal.bouncycastle.operator.ContentSigner;
import com.aspose.psd.internal.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.aspose.psd.internal.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SignerInfoGenerator {
    private final SignerIdentifier a;
    private final CMSAttributeTableGenerator b;
    private final CMSAttributeTableGenerator c;
    private final ContentSigner d;
    private final DigestCalculator e;
    private final DigestAlgorithmIdentifierFinder f = new DefaultDigestAlgorithmIdentifierFinder();
    private final CMSSignatureEncryptionAlgorithmFinder g;
    private byte[] h = null;
    private X509CertificateHolder i;

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner contentSigner, DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder) throws OperatorCreationException {
        this(signerIdentifier, contentSigner, digestCalculatorProvider, cMSSignatureEncryptionAlgorithmFinder, false);
    }

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner contentSigner, DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder, boolean bl2) throws OperatorCreationException {
        this.a = signerIdentifier;
        this.d = contentSigner;
        this.e = digestCalculatorProvider != null ? digestCalculatorProvider.get(this.f.find(contentSigner.getAlgorithmIdentifier())) : null;
        if (bl2) {
            this.b = null;
            this.c = null;
        } else {
            this.b = new DefaultSignedAttributeTableGenerator();
            this.c = null;
        }
        this.g = cMSSignatureEncryptionAlgorithmFinder;
    }

    public SignerInfoGenerator(SignerInfoGenerator signerInfoGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) {
        this.a = signerInfoGenerator.a;
        this.d = signerInfoGenerator.d;
        this.e = signerInfoGenerator.e;
        this.g = signerInfoGenerator.g;
        this.b = cMSAttributeTableGenerator;
        this.c = cMSAttributeTableGenerator2;
    }

    SignerInfoGenerator(SignerIdentifier signerIdentifier, ContentSigner contentSigner, DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws OperatorCreationException {
        this.a = signerIdentifier;
        this.d = contentSigner;
        this.e = digestCalculatorProvider != null ? digestCalculatorProvider.get(this.f.find(contentSigner.getAlgorithmIdentifier())) : null;
        this.b = cMSAttributeTableGenerator;
        this.c = cMSAttributeTableGenerator2;
        this.g = cMSSignatureEncryptionAlgorithmFinder;
    }

    public SignerIdentifier getSID() {
        return this.a;
    }

    public int getGeneratedVersion() {
        return this.a.isTagged() ? 3 : 1;
    }

    public boolean hasAssociatedCertificate() {
        return this.i != null;
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.i;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        if (this.e != null) {
            return this.e.getAlgorithmIdentifier();
        }
        return this.f.find(this.d.getAlgorithmIdentifier());
    }

    public OutputStream getCalculatingOutputStream() {
        if (this.e != null) {
            if (this.b == null) {
                return new TeeOutputStream(this.e.getOutputStream(), this.d.getOutputStream());
            }
            return this.e.getOutputStream();
        }
        return this.d.getOutputStream();
    }

    public SignerInfo generate(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        try {
            Object object;
            Object object2;
            Object object3;
            ASN1Set aSN1Set = null;
            AlgorithmIdentifier algorithmIdentifier = this.g.findEncryptionAlgorithm(this.d.getAlgorithmIdentifier());
            AlgorithmIdentifier algorithmIdentifier2 = null;
            if (this.b != null) {
                algorithmIdentifier2 = this.e.getAlgorithmIdentifier();
                this.h = this.e.getDigest();
                object3 = this.a(aSN1ObjectIdentifier, this.e.getAlgorithmIdentifier(), algorithmIdentifier, this.h);
                object2 = this.b.getAttributes(Collections.unmodifiableMap(object3));
                aSN1Set = this.a((AttributeTable)object2);
                object = this.d.getOutputStream();
                ((OutputStream)object).write(aSN1Set.getEncoded("DER"));
                ((OutputStream)object).close();
            } else if (this.e != null) {
                algorithmIdentifier2 = this.e.getAlgorithmIdentifier();
                this.h = this.e.getDigest();
            } else {
                algorithmIdentifier2 = this.f.find(this.d.getAlgorithmIdentifier());
                this.h = null;
            }
            object3 = this.d.getSignature();
            object2 = null;
            if (this.c != null) {
                object = this.a(aSN1ObjectIdentifier, algorithmIdentifier2, algorithmIdentifier, this.h);
                object.put("encryptedDigest", Arrays.clone(object3));
                AttributeTable attributeTable = this.c.getAttributes(Collections.unmodifiableMap(object));
                object2 = this.a(attributeTable);
            }
            return new SignerInfo(this.a, algorithmIdentifier2, aSN1Set, algorithmIdentifier, (ASN1OctetString)new DEROctetString((byte[])object3), (ASN1Set)object2);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error.", iOException);
        }
    }

    void setAssociatedCertificate(X509CertificateHolder x509CertificateHolder) {
        this.i = x509CertificateHolder;
    }

    private ASN1Set a(AttributeTable attributeTable) {
        if (attributeTable != null) {
            return new DERSet(attributeTable.toASN1EncodableVector());
        }
        return null;
    }

    private Map a(ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aSN1ObjectIdentifier != null) {
            hashMap.put("contentType", aSN1ObjectIdentifier);
        }
        hashMap.put("digestAlgID", algorithmIdentifier);
        hashMap.put("signatureAlgID", algorithmIdentifier2);
        hashMap.put("digest", Arrays.clone(byArray));
        return hashMap;
    }

    public byte[] getCalculatedDigest() {
        if (this.h != null) {
            return Arrays.clone(this.h);
        }
        return null;
    }

    public CMSAttributeTableGenerator getSignedAttributeTableGenerator() {
        return this.b;
    }

    public CMSAttributeTableGenerator getUnsignedAttributeTableGenerator() {
        return this.c;
    }
}

