/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.cmp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.CMPCertificate;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PBMParameter;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIBody;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIHeader;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIMessage;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.cmp.CMPException;
import com.aspose.psd.internal.bouncycastle.cert.cmp.GeneralPKIMessage;
import com.aspose.psd.internal.bouncycastle.cert.crmf.PKMACBuilder;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.operator.MacCalculator;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class ProtectedPKIMessage {
    private PKIMessage a;

    public ProtectedPKIMessage(GeneralPKIMessage generalPKIMessage) {
        if (!generalPKIMessage.hasProtection()) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.a = generalPKIMessage.toASN1Structure();
    }

    ProtectedPKIMessage(PKIMessage pKIMessage) {
        if (pKIMessage.getHeader().getProtectionAlg() == null) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.a = pKIMessage;
    }

    public PKIHeader getHeader() {
        return this.a.getHeader();
    }

    public PKIBody getBody() {
        return this.a.getBody();
    }

    public PKIMessage toASN1Structure() {
        return this.a;
    }

    public boolean hasPasswordBasedMacProtection() {
        return this.a.getHeader().getProtectionAlg().getAlgorithm().equals(CMPObjectIdentifiers.passwordBasedMac);
    }

    public X509CertificateHolder[] getCertificates() {
        CMPCertificate[] cMPCertificateArray = this.a.getExtraCerts();
        if (cMPCertificateArray == null) {
            return new X509CertificateHolder[0];
        }
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[cMPCertificateArray.length];
        for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
            x509CertificateHolderArray[i2] = new X509CertificateHolder(cMPCertificateArray[i2].getX509v3PKCert());
        }
        return x509CertificateHolderArray;
    }

    public boolean verify(ContentVerifierProvider contentVerifierProvider) throws CMPException {
        try {
            ContentVerifier contentVerifier = contentVerifierProvider.get(this.a.getHeader().getProtectionAlg());
            return this.a(this.a.getProtection().getBytes(), contentVerifier);
        }
        catch (Exception exception) {
            throw new CMPException("unable to verify signature: " + exception.getMessage(), exception);
        }
    }

    public boolean verify(PKMACBuilder pKMACBuilder, char[] cArray) throws CMPException {
        if (!CMPObjectIdentifiers.passwordBasedMac.equals(this.a.getHeader().getProtectionAlg().getAlgorithm())) {
            throw new CMPException("protection algorithm not mac based");
        }
        try {
            pKMACBuilder.setParameters(PBMParameter.getInstance(this.a.getHeader().getProtectionAlg().getParameters()));
            MacCalculator macCalculator = pKMACBuilder.build(cArray);
            OutputStream outputStream = macCalculator.getOutputStream();
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(this.a.getHeader());
            aSN1EncodableVector.add(this.a.getBody());
            outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
            outputStream.close();
            return Arrays.areEqual(macCalculator.getMac(), this.a.getProtection().getBytes());
        }
        catch (Exception exception) {
            throw new CMPException("unable to verify MAC: " + exception.getMessage(), exception);
        }
    }

    private boolean a(byte[] byArray, ContentVerifier contentVerifier) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a.getHeader());
        aSN1EncodableVector.add(this.a.getBody());
        OutputStream outputStream = contentVerifier.getOutputStream();
        outputStream.write(new DERSequence(aSN1EncodableVector).getEncoded("DER"));
        outputStream.close();
        return contentVerifier.verify(byArray);
    }
}

