/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509.qualified;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import java.util.Enumeration;

public class BiometricData
extends ASN1Object {
    private TypeOfBiometricData a;
    private AlgorithmIdentifier b;
    private ASN1OctetString c;
    private DERIA5String d;

    public static BiometricData getInstance(Object object) {
        if (object instanceof BiometricData) {
            return (BiometricData)object;
        }
        if (object != null) {
            return new BiometricData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private BiometricData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = TypeOfBiometricData.getInstance(enumeration.nextElement());
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.c = ASN1OctetString.getInstance(enumeration.nextElement());
        if (enumeration.hasMoreElements()) {
            this.d = DERIA5String.getInstance(enumeration.nextElement());
        }
    }

    public BiometricData(TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, DERIA5String dERIA5String) {
        this.a = typeOfBiometricData;
        this.b = algorithmIdentifier;
        this.c = aSN1OctetString;
        this.d = dERIA5String;
    }

    public BiometricData(TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        this.a = typeOfBiometricData;
        this.b = algorithmIdentifier;
        this.c = aSN1OctetString;
        this.d = null;
    }

    public TypeOfBiometricData getTypeOfBiometricData() {
        return this.a;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.b;
    }

    public ASN1OctetString getBiometricDataHash() {
        return this.c;
    }

    public DERIA5String getSourceDataUri() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

