/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1String;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSet;
import com.aspose.psd.internal.bouncycastle.asn1.DERUniversalString;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509NameEntryConverter;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509NameTokenizer;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Name
extends ASN1Object {
    public static final ASN1ObjectIdentifier C = new ASN1ObjectIdentifier("2.5.4.6");
    public static final ASN1ObjectIdentifier O = new ASN1ObjectIdentifier("2.5.4.10");
    public static final ASN1ObjectIdentifier OU = new ASN1ObjectIdentifier("2.5.4.11");
    public static final ASN1ObjectIdentifier T = new ASN1ObjectIdentifier("2.5.4.12");
    public static final ASN1ObjectIdentifier CN = new ASN1ObjectIdentifier("2.5.4.3");
    public static final ASN1ObjectIdentifier SN = new ASN1ObjectIdentifier("2.5.4.5");
    public static final ASN1ObjectIdentifier STREET = new ASN1ObjectIdentifier("2.5.4.9");
    public static final ASN1ObjectIdentifier SERIALNUMBER = SN;
    public static final ASN1ObjectIdentifier L = new ASN1ObjectIdentifier("2.5.4.7");
    public static final ASN1ObjectIdentifier ST = new ASN1ObjectIdentifier("2.5.4.8");
    public static final ASN1ObjectIdentifier SURNAME = new ASN1ObjectIdentifier("2.5.4.4");
    public static final ASN1ObjectIdentifier GIVENNAME = new ASN1ObjectIdentifier("2.5.4.42");
    public static final ASN1ObjectIdentifier INITIALS = new ASN1ObjectIdentifier("2.5.4.43");
    public static final ASN1ObjectIdentifier GENERATION = new ASN1ObjectIdentifier("2.5.4.44");
    public static final ASN1ObjectIdentifier UNIQUE_IDENTIFIER = new ASN1ObjectIdentifier("2.5.4.45");
    public static final ASN1ObjectIdentifier BUSINESS_CATEGORY = new ASN1ObjectIdentifier("2.5.4.15");
    public static final ASN1ObjectIdentifier POSTAL_CODE = new ASN1ObjectIdentifier("2.5.4.17");
    public static final ASN1ObjectIdentifier DN_QUALIFIER = new ASN1ObjectIdentifier("2.5.4.46");
    public static final ASN1ObjectIdentifier PSEUDONYM = new ASN1ObjectIdentifier("2.5.4.65");
    public static final ASN1ObjectIdentifier DATE_OF_BIRTH = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1");
    public static final ASN1ObjectIdentifier PLACE_OF_BIRTH = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.2");
    public static final ASN1ObjectIdentifier GENDER = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.3");
    public static final ASN1ObjectIdentifier COUNTRY_OF_CITIZENSHIP = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.4");
    public static final ASN1ObjectIdentifier COUNTRY_OF_RESIDENCE = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.5");
    public static final ASN1ObjectIdentifier NAME_AT_BIRTH = new ASN1ObjectIdentifier("1.3.36.8.3.14");
    public static final ASN1ObjectIdentifier POSTAL_ADDRESS = new ASN1ObjectIdentifier("2.5.4.16");
    public static final ASN1ObjectIdentifier DMD_NAME = new ASN1ObjectIdentifier("2.5.4.54");
    public static final ASN1ObjectIdentifier TELEPHONE_NUMBER = X509ObjectIdentifiers.id_at_telephoneNumber;
    public static final ASN1ObjectIdentifier NAME = X509ObjectIdentifiers.id_at_name;
    public static final ASN1ObjectIdentifier EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
    public static final ASN1ObjectIdentifier UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
    public static final ASN1ObjectIdentifier UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
    public static final ASN1ObjectIdentifier E = EmailAddress;
    public static final ASN1ObjectIdentifier DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static final ASN1ObjectIdentifier UID = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
    public static boolean DefaultReverse = false;
    public static final Hashtable DefaultSymbols = new Hashtable();
    public static final Hashtable RFC2253Symbols = new Hashtable();
    public static final Hashtable RFC1779Symbols = new Hashtable();
    public static final Hashtable DefaultLookUp = new Hashtable();
    public static final Hashtable OIDLookUp = DefaultSymbols;
    public static final Hashtable SymbolLookUp = DefaultLookUp;
    private static final Boolean a = new Boolean(true);
    private static final Boolean b = new Boolean(false);
    private X509NameEntryConverter c = null;
    private Vector d = new Vector();
    private Vector e = new Vector();
    private Vector f = new Vector();
    private ASN1Sequence g;
    private boolean h;
    private int i;

    public static X509Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return X509Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static X509Name getInstance(Object object) {
        if (object == null || object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof X500Name) {
            return new X509Name(ASN1Sequence.getInstance(((X500Name)object).toASN1Primitive()));
        }
        if (object != null) {
            return new X509Name(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    protected X509Name() {
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        this.g = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Set aSN1Set = ASN1Set.getInstance(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive());
            for (int i2 = 0; i2 < aSN1Set.size(); ++i2) {
                ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Set.getObjectAt(i2).toASN1Primitive());
                if (aSN1Sequence2.size() != 2) {
                    throw new IllegalArgumentException("badly sized pair");
                }
                this.d.addElement(ASN1ObjectIdentifier.getInstance(aSN1Sequence2.getObjectAt(0)));
                ASN1Encodable aSN1Encodable = aSN1Sequence2.getObjectAt(1);
                if (aSN1Encodable instanceof ASN1String && !(aSN1Encodable instanceof DERUniversalString)) {
                    String string = ((ASN1String)((Object)aSN1Encodable)).getString();
                    if (string.length() > 0 && string.charAt(0) == '#') {
                        this.e.addElement("\\" + string);
                    } else {
                        this.e.addElement(string);
                    }
                } else {
                    try {
                        this.e.addElement("#" + this.a(Hex.encode(aSN1Encodable.toASN1Primitive().getEncoded("DER"))));
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("cannot encode value");
                    }
                }
                this.f.addElement(i2 != 0 ? a : b);
            }
        }
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        this(vector, hashtable, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector vector, Hashtable hashtable, X509NameEntryConverter x509NameEntryConverter) {
        int n2;
        this.c = x509NameEntryConverter;
        if (vector != null) {
            for (n2 = 0; n2 != vector.size(); ++n2) {
                this.d.addElement(vector.elementAt(n2));
                this.f.addElement(b);
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.d.addElement(enumeration.nextElement());
                this.f.addElement(b);
            }
        }
        for (n2 = 0; n2 != this.d.size(); ++n2) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)this.d.elementAt(n2);
            if (hashtable.get(aSN1ObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + aSN1ObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.e.addElement(hashtable.get(aSN1ObjectIdentifier));
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        this(vector, vector2, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector vector, Vector vector2, X509NameEntryConverter x509NameEntryConverter) {
        this.c = x509NameEntryConverter;
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.d.addElement(vector.elementAt(i2));
            this.e.addElement(vector2.elementAt(i2));
            this.f.addElement(b);
        }
    }

    public X509Name(String string) {
        this(DefaultReverse, DefaultLookUp, string);
    }

    public X509Name(String string, X509NameEntryConverter x509NameEntryConverter) {
        this(DefaultReverse, DefaultLookUp, string, x509NameEntryConverter);
    }

    public X509Name(boolean bl2, String string) {
        this(bl2, DefaultLookUp, string);
    }

    public X509Name(boolean bl2, String string, X509NameEntryConverter x509NameEntryConverter) {
        this(bl2, DefaultLookUp, string, x509NameEntryConverter);
    }

    public X509Name(boolean bl2, Hashtable hashtable, String string) {
        this(bl2, hashtable, string, new X509DefaultEntryConverter());
    }

    private ASN1ObjectIdentifier a(String string, Hashtable hashtable) {
        if (Strings.toUpperCase(string = string.trim()).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(string.substring(4));
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(string);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)hashtable.get(Strings.toLowerCase(string));
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown object id - " + string + " - passed to distinguished name");
        }
        return aSN1ObjectIdentifier;
    }

    private String a(String string) {
        if (string.length() == 0 || string.indexOf(92) < 0 && string.indexOf(34) < 0) {
            return string.trim();
        }
        char[] cArray = string.toCharArray();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        if (cArray[0] == '\\' && cArray[1] == '#') {
            n2 = 2;
            stringBuffer.append("\\#");
        }
        boolean bl4 = false;
        int n3 = 0;
        for (int i2 = n2; i2 != cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 != ' ') {
                bl4 = true;
            }
            if (c2 == '\"') {
                if (!bl2) {
                    bl3 = !bl3;
                } else {
                    stringBuffer.append(c2);
                }
                bl2 = false;
                continue;
            }
            if (c2 == '\\' && !bl2 && !bl3) {
                bl2 = true;
                n3 = stringBuffer.length();
                continue;
            }
            if (c2 == ' ' && !bl2 && !bl4) continue;
            stringBuffer.append(c2);
            bl2 = false;
        }
        if (stringBuffer.length() > 0) {
            while (stringBuffer.charAt(stringBuffer.length() - 1) == ' ' && n3 != stringBuffer.length() - 1) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    public X509Name(boolean bl2, Hashtable hashtable, String string, X509NameEntryConverter x509NameEntryConverter) {
        Object object;
        Object object2;
        this.c = x509NameEntryConverter;
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            object2 = x509NameTokenizer.nextToken();
            if (((String)object2).indexOf(43) > 0) {
                object = new X509NameTokenizer((String)object2, '+');
                this.a(hashtable, ((X509NameTokenizer)object).nextToken(), b);
                while (((X509NameTokenizer)object).hasMoreTokens()) {
                    this.a(hashtable, ((X509NameTokenizer)object).nextToken(), a);
                }
                continue;
            }
            this.a(hashtable, (String)object2, b);
        }
        if (bl2) {
            object2 = new Vector();
            object = new Vector();
            Vector vector = new Vector();
            int n2 = 1;
            for (int i2 = 0; i2 < this.d.size(); ++i2) {
                if (((Boolean)this.f.elementAt(i2)).booleanValue()) {
                    ((Vector)object2).insertElementAt(this.d.elementAt(i2), n2);
                    ((Vector)object).insertElementAt(this.e.elementAt(i2), n2);
                    vector.insertElementAt(this.f.elementAt(i2), n2);
                    ++n2;
                    continue;
                }
                ((Vector)object2).insertElementAt(this.d.elementAt(i2), 0);
                ((Vector)object).insertElementAt(this.e.elementAt(i2), 0);
                vector.insertElementAt(this.f.elementAt(i2), 0);
                n2 = 1;
            }
            this.d = object2;
            this.e = object;
            this.f = vector;
        }
    }

    private void a(Hashtable hashtable, String string, Boolean bl2) {
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string, '=');
        String string2 = x509NameTokenizer.nextToken();
        if (!x509NameTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("badly formatted directory string");
        }
        String string3 = x509NameTokenizer.nextToken();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.a(string2, hashtable);
        this.d.addElement(aSN1ObjectIdentifier);
        this.e.addElement(this.a(string3));
        this.f.addElement(bl2);
    }

    public Vector getOIDs() {
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.d.size(); ++i2) {
            vector.addElement(this.d.elementAt(i2));
        }
        return vector;
    }

    public Vector getValues() {
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.e.size(); ++i2) {
            vector.addElement(this.e.elementAt(i2));
        }
        return vector;
    }

    public Vector getValues(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 != this.e.size(); ++i2) {
            if (!this.d.elementAt(i2).equals(aSN1ObjectIdentifier)) continue;
            String string = (String)this.e.elementAt(i2);
            if (string.length() > 2 && string.charAt(0) == '\\' && string.charAt(1) == '#') {
                vector.addElement(string.substring(1));
                continue;
            }
            vector.addElement(string);
        }
        return vector;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.g == null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = null;
            for (int i2 = 0; i2 != this.d.size(); ++i2) {
                ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)this.d.elementAt(i2);
                aSN1EncodableVector3.add(aSN1ObjectIdentifier2);
                String string = (String)this.e.elementAt(i2);
                aSN1EncodableVector3.add(this.c.getConvertedValue(aSN1ObjectIdentifier2, string));
                if (aSN1ObjectIdentifier == null || ((Boolean)this.f.elementAt(i2)).booleanValue()) {
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                } else {
                    aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
                    aSN1EncodableVector2 = new ASN1EncodableVector();
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                }
                aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
            }
            aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
            this.g = new DERSequence(aSN1EncodableVector);
        }
        return this.g;
    }

    public boolean equals(Object object, boolean bl2) {
        X509Name x509Name;
        if (!bl2) {
            return this.equals(object);
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            x509Name = X509Name.getInstance(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int n2 = this.d.size();
        if (n2 != x509Name.d.size()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)this.d.elementAt(i2);
            if (aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x509Name.d.elementAt(i2))) {
                String string;
                String string2 = (String)this.e.elementAt(i2);
                if (this.a(string2, string = (String)x509Name.e.elementAt(i2))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.h) {
            return this.i;
        }
        this.h = true;
        for (int i2 = 0; i2 != this.d.size(); ++i2) {
            String string = (String)this.e.elementAt(i2);
            string = this.b(string);
            string = this.d(string);
            this.i ^= this.d.elementAt(i2).hashCode();
            this.i ^= string.hashCode();
        }
        return this.i;
    }

    @Override
    public boolean equals(Object object) {
        int n2;
        int n3;
        int n4;
        X509Name x509Name;
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            x509Name = X509Name.getInstance(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int n5 = this.d.size();
        if (n5 != x509Name.d.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n5];
        if (this.d.elementAt(0).equals(x509Name.d.elementAt(0))) {
            n4 = 0;
            n3 = n5;
            n2 = 1;
        } else {
            n4 = n5 - 1;
            n3 = -1;
            n2 = -1;
        }
        for (int i2 = n4; i2 != n3; i2 += n2) {
            boolean bl2 = false;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)this.d.elementAt(i2);
            String string = (String)this.e.elementAt(i2);
            for (int i3 = 0; i3 < n5; ++i3) {
                String string2;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                if (blArray[i3] || !aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)x509Name.d.elementAt(i3)) || !this.a(string, string2 = (String)x509Name.e.elementAt(i3))) continue;
                blArray[i3] = true;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private boolean a(String string, String string2) {
        String string3;
        String string4 = this.b(string);
        return string4.equals(string3 = this.b(string2)) || (string4 = this.d(string4)).equals(string3 = this.d(string3));
    }

    private String b(String string) {
        ASN1Primitive aSN1Primitive;
        String string2 = Strings.toLowerCase(string.trim());
        if (string2.length() > 0 && string2.charAt(0) == '#' && (aSN1Primitive = this.c(string2)) instanceof ASN1String) {
            string2 = Strings.toLowerCase(((ASN1String)((Object)aSN1Primitive)).getString().trim());
        }
        return string2;
    }

    private ASN1Primitive c(String string) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(string.substring(1)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unknown encoding in name: " + iOException);
        }
    }

    private String d(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() != 0) {
            char c2 = string.charAt(0);
            stringBuffer.append(c2);
            for (int i2 = 1; i2 < string.length(); ++i2) {
                char c3 = string.charAt(i2);
                if (c2 != ' ' || c3 != ' ') {
                    stringBuffer.append(c3);
                }
                c2 = c3;
            }
        }
        return stringBuffer.toString();
    }

    private void a(StringBuffer stringBuffer, Hashtable hashtable, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        String string2 = (String)hashtable.get(aSN1ObjectIdentifier);
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(aSN1ObjectIdentifier.getId());
        }
        stringBuffer.append('=');
        int n2 = stringBuffer.length();
        stringBuffer.append(string);
        int n3 = stringBuffer.length();
        if (string.length() >= 2 && string.charAt(0) == '\\' && string.charAt(1) == '#') {
            n2 += 2;
        }
        while (n2 < n3 && stringBuffer.charAt(n2) == ' ') {
            stringBuffer.insert(n2, "\\");
            n2 += 2;
            ++n3;
        }
        while (--n3 > n2 && stringBuffer.charAt(n3) == ' ') {
            stringBuffer.insert(n3, '\\');
        }
        block5: while (n2 <= n3) {
            switch (stringBuffer.charAt(n2)) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    stringBuffer.insert(n2, "\\");
                    n2 += 2;
                    ++n3;
                    continue block5;
                }
            }
            ++n2;
        }
    }

    public String toString(boolean bl2, Hashtable hashtable) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<StringBuffer> vector = new Vector<StringBuffer>();
        boolean bl3 = true;
        StringBuffer stringBuffer2 = null;
        for (n2 = 0; n2 < this.d.size(); ++n2) {
            if (((Boolean)this.f.elementAt(n2)).booleanValue()) {
                stringBuffer2.append('+');
                this.a(stringBuffer2, hashtable, (ASN1ObjectIdentifier)this.d.elementAt(n2), (String)this.e.elementAt(n2));
                continue;
            }
            stringBuffer2 = new StringBuffer();
            this.a(stringBuffer2, hashtable, (ASN1ObjectIdentifier)this.d.elementAt(n2), (String)this.e.elementAt(n2));
            vector.addElement(stringBuffer2);
        }
        if (bl2) {
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(vector.elementAt(n2).toString());
            }
        } else {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(vector.elementAt(n2).toString());
            }
        }
        return stringBuffer.toString();
    }

    private String a(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            cArray[i2] = (char)(byArray[i2] & 0xFF);
        }
        return new String(cArray);
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    static {
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SERIALNUMBER");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(STREET, "STREET");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        DefaultSymbols.put(UnstructuredAddress, "unstructuredAddress");
        DefaultSymbols.put(UnstructuredName, "unstructuredName");
        DefaultSymbols.put(UNIQUE_IDENTIFIER, "UniqueIdentifier");
        DefaultSymbols.put(DN_QUALIFIER, "DN");
        DefaultSymbols.put(PSEUDONYM, "Pseudonym");
        DefaultSymbols.put(POSTAL_ADDRESS, "PostalAddress");
        DefaultSymbols.put(NAME_AT_BIRTH, "NameAtBirth");
        DefaultSymbols.put(COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship");
        DefaultSymbols.put(COUNTRY_OF_RESIDENCE, "CountryOfResidence");
        DefaultSymbols.put(GENDER, "Gender");
        DefaultSymbols.put(PLACE_OF_BIRTH, "PlaceOfBirth");
        DefaultSymbols.put(DATE_OF_BIRTH, "DateOfBirth");
        DefaultSymbols.put(POSTAL_CODE, "PostalCode");
        DefaultSymbols.put(BUSINESS_CATEGORY, "BusinessCategory");
        DefaultSymbols.put(TELEPHONE_NUMBER, "TelephoneNumber");
        DefaultSymbols.put(NAME, "Name");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(STREET, "STREET");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC1779Symbols.put(C, "C");
        RFC1779Symbols.put(O, "O");
        RFC1779Symbols.put(OU, "OU");
        RFC1779Symbols.put(CN, "CN");
        RFC1779Symbols.put(L, "L");
        RFC1779Symbols.put(ST, "ST");
        RFC1779Symbols.put(STREET, "STREET");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("serialnumber", SN);
        DefaultLookUp.put("street", STREET);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
        DefaultLookUp.put("unstructuredaddress", UnstructuredAddress);
        DefaultLookUp.put("unstructuredname", UnstructuredName);
        DefaultLookUp.put("uniqueidentifier", UNIQUE_IDENTIFIER);
        DefaultLookUp.put("dn", DN_QUALIFIER);
        DefaultLookUp.put("pseudonym", PSEUDONYM);
        DefaultLookUp.put("postaladdress", POSTAL_ADDRESS);
        DefaultLookUp.put("nameofbirth", NAME_AT_BIRTH);
        DefaultLookUp.put("countryofcitizenship", COUNTRY_OF_CITIZENSHIP);
        DefaultLookUp.put("countryofresidence", COUNTRY_OF_RESIDENCE);
        DefaultLookUp.put("gender", GENDER);
        DefaultLookUp.put("placeofbirth", PLACE_OF_BIRTH);
        DefaultLookUp.put("dateofbirth", DATE_OF_BIRTH);
        DefaultLookUp.put("postalcode", POSTAL_CODE);
        DefaultLookUp.put("businesscategory", BUSINESS_CATEGORY);
        DefaultLookUp.put("telephonenumber", TELEPHONE_NUMBER);
        DefaultLookUp.put("name", NAME);
    }
}

