/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.misc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class ScryptParams
extends ASN1Object {
    private final byte[] a;
    private final BigInteger b;
    private final BigInteger c;
    private final BigInteger d;
    private final BigInteger e;

    public ScryptParams(byte[] byArray, int n2, int n3, int n4) {
        this(byArray, BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigInteger.valueOf(n4), null);
    }

    public ScryptParams(byte[] byArray, int n2, int n3, int n4, int n5) {
        this(byArray, BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigInteger.valueOf(n4), BigInteger.valueOf(n5));
    }

    public ScryptParams(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.a = Arrays.clone(byArray);
        this.b = bigInteger;
        this.c = bigInteger2;
        this.d = bigInteger3;
        this.e = bigInteger4;
    }

    public static ScryptParams getInstance(Object object) {
        if (object instanceof ScryptParams) {
            return (ScryptParams)object;
        }
        if (object != null) {
            return new ScryptParams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private ScryptParams(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 4 && aSN1Sequence.size() != 5) {
            throw new IllegalArgumentException("invalid sequence: size = " + aSN1Sequence.size());
        }
        this.a = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets());
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        this.c = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2)).getValue();
        this.d = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(3)).getValue();
        this.e = aSN1Sequence.size() == 5 ? ASN1Integer.getInstance(aSN1Sequence.getObjectAt(4)).getValue() : null;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.a);
    }

    public BigInteger getCostParameter() {
        return this.b;
    }

    public BigInteger getBlockSize() {
        return this.c;
    }

    public BigInteger getParallelizationParameter() {
        return this.d;
    }

    public BigInteger getKeyLength() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new ASN1Integer(this.c));
        aSN1EncodableVector.add(new ASN1Integer(this.d));
        if (this.e != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.e));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

