/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.icao;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERPrintableString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;

public class LDSVersionInfo
extends ASN1Object {
    private DERPrintableString a;
    private DERPrintableString b;

    public LDSVersionInfo(String string, String string2) {
        this.a = new DERPrintableString(string);
        this.b = new DERPrintableString(string2);
    }

    private LDSVersionInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("sequence wrong size for LDSVersionInfo");
        }
        this.a = DERPrintableString.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = DERPrintableString.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static LDSVersionInfo getInstance(Object object) {
        if (object instanceof LDSVersionInfo) {
            return (LDSVersionInfo)object;
        }
        if (object != null) {
            return new LDSVersionInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public String getLdsVersion() {
        return this.a.getString();
    }

    public String getUnicodeVersion() {
        return this.b.getString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

