/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cryptopro;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class Gost2814789KeyWrapParameters
extends ASN1Object {
    private final ASN1ObjectIdentifier a;
    private final byte[] b;

    private Gost2814789KeyWrapParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.a = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
        } else if (aSN1Sequence.size() == 1) {
            this.a = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.b = null;
        } else {
            throw new IllegalArgumentException("unknown sequence length: " + aSN1Sequence.size());
        }
    }

    public static Gost2814789KeyWrapParameters getInstance(Object object) {
        if (object instanceof Gost2814789KeyWrapParameters) {
            return (Gost2814789KeyWrapParameters)object;
        }
        if (object != null) {
            return new Gost2814789KeyWrapParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Gost2814789KeyWrapParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, null);
    }

    public Gost2814789KeyWrapParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        this.a = aSN1ObjectIdentifier;
        this.b = Arrays.clone(byArray);
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.a;
    }

    public byte[] getUkm() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DEROctetString(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

