/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.crmf;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERBitString;
import com.aspose.psd.internal.bouncycastle.asn1.crmf.OptionalValidity;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import java.util.Enumeration;

public class CertTemplate
extends ASN1Object {
    private ASN1Sequence a;
    private ASN1Integer b;
    private ASN1Integer c;
    private AlgorithmIdentifier d;
    private X500Name e;
    private OptionalValidity f;
    private X500Name g;
    private SubjectPublicKeyInfo h;
    private DERBitString i;
    private DERBitString j;
    private Extensions k;

    private CertTemplate(ASN1Sequence aSN1Sequence) {
        this.a = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        block12: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 1: {
                    this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 2: {
                    this.d = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 3: {
                    this.e = X500Name.getInstance(aSN1TaggedObject, true);
                    continue block12;
                }
                case 4: {
                    this.f = OptionalValidity.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                    continue block12;
                }
                case 5: {
                    this.g = X500Name.getInstance(aSN1TaggedObject, true);
                    continue block12;
                }
                case 6: {
                    this.h = SubjectPublicKeyInfo.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 7: {
                    this.i = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 8: {
                    this.j = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 9: {
                    this.k = Extensions.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("unknown tag: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static CertTemplate getInstance(Object object) {
        if (object instanceof CertTemplate) {
            return (CertTemplate)object;
        }
        if (object != null) {
            return new CertTemplate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getVersion() {
        return this.b.getValue().intValue();
    }

    public ASN1Integer getSerialNumber() {
        return this.c;
    }

    public AlgorithmIdentifier getSigningAlg() {
        return this.d;
    }

    public X500Name getIssuer() {
        return this.e;
    }

    public OptionalValidity getValidity() {
        return this.f;
    }

    public X500Name getSubject() {
        return this.g;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.h;
    }

    public DERBitString getIssuerUID() {
        return this.i;
    }

    public DERBitString getSubjectUID() {
        return this.j;
    }

    public Extensions getExtensions() {
        return this.k;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

